/*
 * Decompiled with CFR 0.152.
 */
package user.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import java.util.Map;
import javax.accessibility.Accessible;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingWorker;
import javax.swing.border.EmptyBorder;
import user.gui.CreateGroupWithUserDialog;
import user.gui.UIHelper;
import user.gui.ZaloMainFrame;
import user.service.UserService;

public class AddFriendDialog
extends JDialog {
    private static final Color PRIMARY_COLOR = new Color(0, 132, 255);
    private static final Color BG_COLOR = new Color(250, 250, 250);
    private ZaloMainFrame mainFrame;
    private String currentUsername;
    private JTextField searchField;
    private JPanel resultsPanel;
    private UserService userService;

    public AddFriendDialog(ZaloMainFrame zaloMainFrame, String string) {
        super(zaloMainFrame, "Th\u00eam b\u1ea1n", false);
        this.mainFrame = zaloMainFrame;
        this.currentUsername = string;
        this.userService = new UserService();
        this.initializeUI();
        this.setLocationRelativeTo(zaloMainFrame);
    }

    private void initializeUI() {
        this.setSize(550, 600);
        this.setLayout(new BorderLayout());
        this.getContentPane().setBackground(Color.WHITE);
        JPanel jPanel = this.createHeader();
        JPanel jPanel2 = this.createSearchPanel();
        this.resultsPanel = new JPanel();
        this.resultsPanel.setLayout(new BoxLayout(this.resultsPanel, 1));
        this.resultsPanel.setBackground(BG_COLOR);
        JScrollPane jScrollPane = new JScrollPane(this.resultsPanel);
        jScrollPane.setBorder(null);
        jScrollPane.getVerticalScrollBar().setUnitIncrement(16);
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.add((Component)jPanel2, "North");
        jPanel3.add((Component)jScrollPane, "Center");
        this.add((Component)jPanel, "North");
        this.add((Component)jPanel3, "Center");
        this.showHelperMessage();
    }

    private JPanel createHeader() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBackground(PRIMARY_COLOR);
        jPanel.setBorder(new EmptyBorder(15, 15, 15, 15));
        JLabel jLabel = new JLabel("Th\u00eam b\u1ea1n");
        jLabel.setFont(new Font(UIHelper.getDefaultFontName(), 1, 18));
        jLabel.setForeground(Color.WHITE);
        JButton jButton = new JButton("\u2715");
        jButton.setFont(new Font(UIHelper.getDefaultFontName(), 0, 20));
        jButton.setForeground(Color.WHITE);
        jButton.setBorderPainted(false);
        jButton.setContentAreaFilled(false);
        jButton.setFocusPainted(false);
        jButton.setCursor(new Cursor(12));
        jButton.addActionListener(actionEvent -> this.dispose());
        jPanel.add((Component)jLabel, "West");
        jPanel.add((Component)jButton, "East");
        return jPanel;
    }

    private JPanel createSearchPanel() {
        JPanel jPanel = new JPanel(new BorderLayout(10, 10));
        jPanel.setBackground(Color.WHITE);
        jPanel.setBorder(new EmptyBorder(15, 15, 15, 15));
        JPanel jPanel2 = new JPanel(new BorderLayout(5, 0));
        jPanel2.setBackground(Color.WHITE);
        this.searchField = new JTextField();
        this.searchField.setFont(new Font(UIHelper.getDefaultFontName(), 0, 15));
        this.searchField.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(new Color(220, 220, 220), 1), new EmptyBorder(10, 12, 10, 12)));
        this.searchField.setForeground(new Color(150, 150, 150));
        this.searchField.setText("Nh\u1eadp t\u00ean \u0111\u0103ng nh\u1eadp ho\u1eb7c email");
        this.searchField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                if (AddFriendDialog.this.searchField.getText().equals("Nh\u1eadp t\u00ean \u0111\u0103ng nh\u1eadp ho\u1eb7c email")) {
                    AddFriendDialog.this.searchField.setText("");
                    AddFriendDialog.this.searchField.setForeground(Color.BLACK);
                }
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                if (AddFriendDialog.this.searchField.getText().isEmpty()) {
                    AddFriendDialog.this.searchField.setForeground(new Color(150, 150, 150));
                    AddFriendDialog.this.searchField.setText("Nh\u1eadp t\u00ean \u0111\u0103ng nh\u1eadp ho\u1eb7c email");
                }
            }
        });
        this.searchField.addActionListener(actionEvent -> this.performSearch());
        jPanel2.add((Component)this.searchField, "Center");
        JButton jButton = new JButton("T\u00ecm ki\u1ebfm");
        jButton.setFont(new Font(UIHelper.getDefaultFontName(), 1, 14));
        jButton.setForeground(Color.WHITE);
        jButton.setBackground(PRIMARY_COLOR);
        jButton.setBorderPainted(false);
        jButton.setFocusPainted(false);
        jButton.setOpaque(true);
        jButton.setContentAreaFilled(true);
        jButton.setCursor(new Cursor(12));
        jButton.setPreferredSize(new Dimension(100, 42));
        jButton.addActionListener(actionEvent -> this.performSearch());
        jPanel.add((Component)jPanel2, "Center");
        jPanel.add((Component)jButton, "East");
        JLabel jLabel = new JLabel("C\u00f3 th\u1ec3 b\u1ea1n quen");
        jLabel.setFont(new Font(UIHelper.getDefaultFontName(), 0, 12));
        jLabel.setForeground(new Color(120, 120, 120));
        jLabel.setIcon(new ImageIcon());
        jPanel.add((Component)jLabel, "South");
        return jPanel;
    }

    private void showHelperMessage() {
        this.resultsPanel.removeAll();
        JLabel jLabel = new JLabel("<html><center><b>[?]</b><br><br>Nh\u1eadp t\u00ean \u0111\u0103ng nh\u1eadp ho\u1eb7c email<br>\u0111\u1ec3 t\u00ecm ki\u1ebfm b\u1ea1n b\u00e8</center></html>");
        jLabel.setFont(new Font(UIHelper.getDefaultFontName(), 0, 14));
        jLabel.setForeground(new Color(150, 150, 150));
        jLabel.setAlignmentX(0.5f);
        jLabel.setBorder(new EmptyBorder(100, 20, 100, 20));
        this.resultsPanel.add(jLabel);
        this.resultsPanel.revalidate();
        this.resultsPanel.repaint();
    }

    private void performSearch() {
        final String string = this.searchField.getText().trim();
        if (string.isEmpty() || string.equals("Nh\u1eadp t\u00ean \u0111\u0103ng nh\u1eadp ho\u1eb7c email")) {
            this.showHelperMessage();
            return;
        }
        this.resultsPanel.removeAll();
        JLabel jLabel = new JLabel("\u0110ang t\u00ecm ki\u1ebfm...");
        jLabel.setFont(new Font(UIHelper.getDefaultFontName(), 0, 14));
        jLabel.setForeground(new Color(120, 120, 120));
        jLabel.setAlignmentX(0.5f);
        this.resultsPanel.add(jLabel);
        this.resultsPanel.revalidate();
        this.resultsPanel.repaint();
        SwingWorker<List<Map<String, Object>>, Void> swingWorker = new SwingWorker<List<Map<String, Object>>, Void>(){

            @Override
            protected List<Map<String, Object>> doInBackground() throws Exception {
                return AddFriendDialog.this.userService.searchUsers(string, AddFriendDialog.this.currentUsername);
            }

            @Override
            protected void done() {
                try {
                    List list = (List)this.get();
                    AddFriendDialog.this.displayResults(list);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    AddFriendDialog.this.showError("L\u1ed7i khi t\u00ecm ki\u1ebfm: " + exception.getMessage());
                }
            }
        };
        swingWorker.execute();
    }

    private void displayResults(List<Map<String, Object>> list) {
        this.resultsPanel.removeAll();
        if (list == null || list.isEmpty()) {
            JLabel jLabel = new JLabel("<html><center>\ud83d\ude14<br><br>Kh\u00f4ng t\u00ecm th\u1ea5y k\u1ebft qu\u1ea3</center></html>");
            jLabel.setFont(new Font(UIHelper.getDefaultFontName(), 0, 14));
            jLabel.setForeground(new Color(150, 150, 150));
            jLabel.setAlignmentX(0.5f);
            jLabel.setBorder(new EmptyBorder(100, 20, 100, 20));
            this.resultsPanel.add(jLabel);
        } else {
            for (Map<String, Object> map : list) {
                UserResultPanel userResultPanel = new UserResultPanel(map);
                this.resultsPanel.add(userResultPanel);
            }
        }
        this.resultsPanel.revalidate();
        this.resultsPanel.repaint();
    }

    private void showError(String string) {
        this.resultsPanel.removeAll();
        JLabel jLabel = new JLabel("<html><center>\u274c<br><br>" + string + "</center></html>");
        jLabel.setFont(new Font(UIHelper.getDefaultFontName(), 0, 14));
        jLabel.setForeground(new Color(255, 59, 48));
        jLabel.setAlignmentX(0.5f);
        jLabel.setBorder(new EmptyBorder(100, 20, 100, 20));
        this.resultsPanel.add(jLabel);
        this.resultsPanel.revalidate();
        this.resultsPanel.repaint();
    }

    private void openCreateGroupWithUser(String string, String string2) {
        CreateGroupWithUserDialog createGroupWithUserDialog = new CreateGroupWithUserDialog(this.mainFrame, string, string2);
        createGroupWithUserDialog.setVisible(true);
        this.dispose();
    }

    private void sendFriendRequest(final String string, final JButton jButton) {
        jButton.setEnabled(false);
        jButton.setText("\u0110ang g\u1eedi...");
        SwingWorker<Boolean, Void> swingWorker = new SwingWorker<Boolean, Void>(){

            @Override
            protected Boolean doInBackground() throws Exception {
                boolean bl = AddFriendDialog.this.userService.sendFriendRequest(AddFriendDialog.this.currentUsername, string);
                if (bl) {
                    System.out.println("\u2705 \u0110\u00e3 l\u01b0u l\u1eddi m\u1eddi k\u1ebft b\u1ea1n v\u00e0o database: " + AddFriendDialog.this.currentUsername + " \u2192 " + string);
                    AddFriendDialog.this.mainFrame.sendFriendRequestNotification(string);
                }
                return bl;
            }

            @Override
            protected void done() {
                try {
                    boolean bl = (Boolean)this.get();
                    if (bl) {
                        jButton.setText("\u0110\u00e3 g\u1eedi");
                        jButton.setForeground(new Color(67, 220, 96));
                        jButton.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(new Color(67, 220, 96), 1, true), new EmptyBorder(6, 20, 6, 20)));
                        AddFriendDialog.this.mainFrame.refreshFriendRequestPanel();
                        JOptionPane.showMessageDialog(AddFriendDialog.this, "\u2705 \u0110\u00e3 g\u1eedi l\u1eddi m\u1eddi k\u1ebft b\u1ea1n!", "Th\u00e0nh c\u00f4ng", 1);
                    } else {
                        jButton.setEnabled(true);
                        jButton.setText("K\u1ebft b\u1ea1n");
                        JOptionPane.showMessageDialog(AddFriendDialog.this, "\u274c Kh\u00f4ng th\u1ec3 g\u1eedi l\u1eddi m\u1eddi k\u1ebft b\u1ea1n!\nC\u00f3 th\u1ec3 b\u1ea1n \u0111\u00e3 b\u1ecb ch\u1eb7n ho\u1eb7c \u0111\u00e3 c\u00f3 l\u1eddi m\u1eddi tr\u01b0\u1edbc \u0111\u00f3.", "L\u1ed7i", 0);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    jButton.setEnabled(true);
                    jButton.setText("K\u1ebft b\u1ea1n");
                    JOptionPane.showMessageDialog(AddFriendDialog.this, "\u274c L\u1ed7i: " + exception.getMessage(), "L\u1ed7i", 0);
                }
            }
        };
        swingWorker.execute();
    }

    private class UserResultPanel
    extends JPanel {
        public UserResultPanel(Map<String, Object> map) {
            Object object;
            Accessible accessible;
            this.setLayout(new BorderLayout(10, 0));
            this.setBackground(Color.WHITE);
            this.setBorder(new EmptyBorder(12, 15, 12, 15));
            this.setMaximumSize(new Dimension(Integer.MAX_VALUE, 80));
            JLabel jLabel = new JLabel();
            jLabel.setPreferredSize(new Dimension(50, 50));
            jLabel.setHorizontalAlignment(0);
            try {
                accessible = new ImageIcon("icons/user.png");
                object = ((ImageIcon)accessible).getImage().getScaledInstance(40, 40, 4);
                jLabel.setIcon(new ImageIcon((Image)object));
            }
            catch (Exception exception) {
                jLabel.setText("[A]");
                jLabel.setFont(new Font(UIHelper.getDefaultFontName(), 1, 18));
                jLabel.setForeground(new Color(0, 132, 255));
            }
            accessible = new JPanel();
            ((Container)((Object)accessible)).setLayout(new BoxLayout((Container)((Object)accessible), 1));
            ((JComponent)((Object)accessible)).setOpaque(false);
            object = (String)map.get("username");
            String string = (String)map.get("full_name");
            String string2 = (String)map.get("email");
            JLabel jLabel2 = new JLabel((String)(string != null ? string : object));
            jLabel2.setFont(new Font(UIHelper.getDefaultFontName(), 1, 15));
            JLabel jLabel3 = new JLabel("@" + (String)object);
            jLabel3.setFont(new Font(UIHelper.getDefaultFontName(), 0, 12));
            jLabel3.setForeground(new Color(120, 120, 120));
            ((Container)((Object)accessible)).add(jLabel2);
            ((Container)((Object)accessible)).add(jLabel3);
            String string3 = AddFriendDialog.this.userService.getFriendshipStatus(AddFriendDialog.this.currentUsername, (String)object);
            final JButton jButton = new JButton();
            jButton.setFont(new Font(UIHelper.getDefaultFontName(), 1, 12));
            jButton.setFocusPainted(false);
            jButton.setCursor(new Cursor(12));
            final JButton jButton2 = new JButton("Nh\u1eafn tin");
            jButton2.setFont(new Font(UIHelper.getDefaultFontName(), 1, 12));
            jButton2.setFocusPainted(false);
            jButton2.setCursor(new Cursor(12));
            jButton2.setForeground(new Color(0, 150, 80));
            jButton2.setBackground(Color.WHITE);
            jButton2.setOpaque(true);
            jButton2.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(new Color(0, 150, 80), 1, true), new EmptyBorder(6, 12, 6, 12)));
            jButton2.addActionListener(arg_0 -> this.lambda$new$0((String)object, arg_0));
            jButton2.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent mouseEvent) {
                    jButton2.setBackground(new Color(240, 255, 245));
                }

                @Override
                public void mouseExited(MouseEvent mouseEvent) {
                    jButton2.setBackground(Color.WHITE);
                }
            });
            final JButton jButton3 = new JButton("T\u1ea1o nh\u00f3m");
            jButton3.setFont(new Font(UIHelper.getDefaultFontName(), 1, 12));
            jButton3.setFocusPainted(false);
            jButton3.setCursor(new Cursor(12));
            jButton3.setForeground(new Color(255, 140, 0));
            jButton3.setBackground(Color.WHITE);
            jButton3.setOpaque(true);
            jButton3.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(new Color(255, 140, 0), 1, true), new EmptyBorder(6, 12, 6, 12)));
            jButton3.addActionListener(arg_0 -> this.lambda$new$1((String)object, string, arg_0));
            jButton3.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent mouseEvent) {
                    jButton3.setBackground(new Color(255, 250, 240));
                }

                @Override
                public void mouseExited(MouseEvent mouseEvent) {
                    jButton3.setBackground(Color.WHITE);
                }
            });
            switch (string3) {
                case "friends": {
                    jButton.setText("B\u1ea1n b\u00e8");
                    jButton.setForeground(new Color(67, 220, 96));
                    jButton.setBackground(Color.WHITE);
                    jButton.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(new Color(67, 220, 96), 1, true), new EmptyBorder(6, 12, 6, 12)));
                    jButton.setEnabled(false);
                    break;
                }
                case "pending_sent": {
                    jButton.setText("\u0110\u00e3 g\u1eedi");
                    jButton.setForeground(new Color(120, 120, 120));
                    jButton.setBackground(Color.WHITE);
                    jButton.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(new Color(200, 200, 200), 1, true), new EmptyBorder(6, 12, 6, 12)));
                    jButton.setEnabled(false);
                    break;
                }
                case "pending_received": {
                    jButton.setText("Ph\u1ea3n h\u1ed3i");
                    jButton.setForeground(PRIMARY_COLOR);
                    jButton.setBackground(Color.WHITE);
                    jButton.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(PRIMARY_COLOR, 1, true), new EmptyBorder(6, 12, 6, 12)));
                    jButton.addActionListener(actionEvent -> {
                        AddFriendDialog.this.mainFrame.showContactPanel();
                        AddFriendDialog.this.mainFrame.showContactContent("FRIEND_REQUESTS");
                        AddFriendDialog.this.dispose();
                    });
                    break;
                }
                default: {
                    jButton.setText("K\u1ebft b\u1ea1n");
                    jButton.setForeground(PRIMARY_COLOR);
                    jButton.setBackground(Color.WHITE);
                    jButton.setOpaque(true);
                    jButton.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(PRIMARY_COLOR, 1, true), new EmptyBorder(6, 12, 6, 12)));
                    jButton.addActionListener(arg_0 -> this.lambda$new$3((String)object, jButton, arg_0));
                }
            }
            if (jButton.isEnabled() && string3.equals("none")) {
                jButton.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mouseEntered(MouseEvent mouseEvent) {
                        jButton.setBackground(new Color(240, 245, 255));
                    }

                    @Override
                    public void mouseExited(MouseEvent mouseEvent) {
                        jButton.setBackground(Color.WHITE);
                    }
                });
            }
            Object object2 = new JPanel(new FlowLayout(2, 5, 0));
            ((JComponent)object2).setOpaque(false);
            ((Container)object2).add(jButton2);
            ((Container)object2).add(jButton3);
            ((Container)object2).add(jButton);
            this.add((Component)jLabel, "West");
            this.add((Component)((Object)accessible), "Center");
            this.add((Component)object2, "East");
            this.setBorder(BorderFactory.createCompoundBorder(new EmptyBorder(12, 15, 12, 15), BorderFactory.createMatteBorder(0, 0, 1, 0, new Color(240, 240, 240))));
        }

        private /* synthetic */ void lambda$new$3(String string, JButton jButton, ActionEvent actionEvent) {
            AddFriendDialog.this.sendFriendRequest(string, jButton);
        }

        private /* synthetic */ void lambda$new$1(String string, String string2, ActionEvent actionEvent) {
            AddFriendDialog.this.openCreateGroupWithUser(string, string2);
        }

        private /* synthetic */ void lambda$new$0(String string, ActionEvent actionEvent) {
            AddFriendDialog.this.mainFrame.openChat(string);
            AddFriendDialog.this.dispose();
        }
    }
}

