/*
 * Decompiled with CFR 0.152.
 */
package user.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Image;
import java.util.List;
import java.util.Map;
import javax.accessibility.Accessible;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingWorker;
import user.gui.UIHelper;
import user.gui.ZaloMainFrame;
import user.service.UserService;

public class BlockedUsersDialog
extends JDialog {
    private static final Color PRIMARY_COLOR = new Color(0, 132, 255);
    private static final Color BG_COLOR = new Color(250, 250, 250);
    private ZaloMainFrame mainFrame;
    private UserService userService;
    private JPanel blockedListPanel;

    public BlockedUsersDialog(ZaloMainFrame zaloMainFrame) {
        super(zaloMainFrame, "Danh s\u00e1ch ng\u01b0\u1eddi \u0111\u00e3 ch\u1eb7n", true);
        this.mainFrame = zaloMainFrame;
        this.userService = new UserService();
        this.initializeUI();
        this.loadBlockedUsers();
    }

    private void initializeUI() {
        this.setSize(500, 600);
        this.setLocationRelativeTo(this.mainFrame);
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBackground(PRIMARY_COLOR);
        jPanel.setBorder(BorderFactory.createEmptyBorder(15, 20, 15, 20));
        JLabel jLabel = new JLabel("Danh s\u00e1ch ng\u01b0\u1eddi \u0111\u00e3 ch\u1eb7n");
        jLabel.setFont(new Font(UIHelper.getDefaultFontName(), 1, 18));
        jLabel.setForeground(Color.WHITE);
        jPanel.add((Component)jLabel, "West");
        this.blockedListPanel = new JPanel();
        this.blockedListPanel.setLayout(new BoxLayout(this.blockedListPanel, 1));
        this.blockedListPanel.setBackground(BG_COLOR);
        this.blockedListPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        JScrollPane jScrollPane = new JScrollPane(this.blockedListPanel);
        jScrollPane.setBorder(null);
        jScrollPane.getVerticalScrollBar().setUnitIncrement(16);
        JPanel jPanel2 = new JPanel(new FlowLayout(2, 15, 15));
        jPanel2.setBackground(Color.WHITE);
        JButton jButton = new JButton("\u0110\u00f3ng");
        jButton.setFont(new Font(UIHelper.getDefaultFontName(), 0, 14));
        jButton.setPreferredSize(new Dimension(100, 35));
        jButton.addActionListener(actionEvent -> this.dispose());
        jPanel2.add(jButton);
        this.add((Component)jPanel, "North");
        this.add((Component)jScrollPane, "Center");
        this.add((Component)jPanel2, "South");
    }

    private void loadBlockedUsers() {
        this.blockedListPanel.removeAll();
        SwingWorker<List<Map<String, Object>>, Void> swingWorker = new SwingWorker<List<Map<String, Object>>, Void>(){

            @Override
            protected List<Map<String, Object>> doInBackground() {
                return BlockedUsersDialog.this.userService.getBlockedUsers(BlockedUsersDialog.this.mainFrame.getUsername());
            }

            @Override
            protected void done() {
                try {
                    List list = (List)this.get();
                    if (list == null || list.isEmpty()) {
                        JLabel jLabel = new JLabel("B\u1ea1n ch\u01b0a ch\u1eb7n ai");
                        jLabel.setFont(new Font(UIHelper.getDefaultFontName(), 2, 14));
                        jLabel.setForeground(new Color(150, 150, 150));
                        jLabel.setAlignmentX(0.5f);
                        BlockedUsersDialog.this.blockedListPanel.add(Box.createVerticalGlue());
                        BlockedUsersDialog.this.blockedListPanel.add(jLabel);
                        BlockedUsersDialog.this.blockedListPanel.add(Box.createVerticalGlue());
                    } else {
                        for (Map map : list) {
                            String string = (String)map.get("username");
                            String string2 = (String)map.get("full_name");
                            String string3 = string2 != null && !string2.isEmpty() ? string2 : string;
                            JPanel jPanel = BlockedUsersDialog.this.createBlockedUserItem(string, string3);
                            BlockedUsersDialog.this.blockedListPanel.add(jPanel);
                            BlockedUsersDialog.this.blockedListPanel.add(Box.createVerticalStrut(5));
                        }
                    }
                    BlockedUsersDialog.this.blockedListPanel.revalidate();
                    BlockedUsersDialog.this.blockedListPanel.repaint();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    JOptionPane.showMessageDialog(BlockedUsersDialog.this, "L\u1ed7i khi t\u1ea3i danh s\u00e1ch: " + exception.getMessage(), "L\u1ed7i", 0);
                }
            }
        };
        swingWorker.execute();
    }

    private JPanel createBlockedUserItem(String string, String string2) {
        Object object;
        Accessible accessible;
        JPanel jPanel = new JPanel(new BorderLayout(15, 0));
        jPanel.setBackground(Color.WHITE);
        jPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(new Color(230, 230, 230)), BorderFactory.createEmptyBorder(12, 15, 12, 15)));
        jPanel.setMaximumSize(new Dimension(Integer.MAX_VALUE, 70));
        JLabel jLabel = new JLabel();
        jLabel.setPreferredSize(new Dimension(50, 50));
        jLabel.setHorizontalAlignment(0);
        try {
            accessible = new ImageIcon("icons/user.png");
            object = ((ImageIcon)accessible).getImage().getScaledInstance(40, 40, 4);
            jLabel.setIcon(new ImageIcon((Image)object));
        }
        catch (Exception exception) {
            jLabel.setText("[A]");
            jLabel.setFont(new Font(UIHelper.getDefaultFontName(), 1, 18));
            jLabel.setForeground(new Color(0, 132, 255));
        }
        accessible = new JPanel();
        ((Container)((Object)accessible)).setLayout(new BoxLayout((Container)((Object)accessible), 1));
        ((JComponent)((Object)accessible)).setOpaque(false);
        object = new JLabel(string2);
        ((JComponent)object).setFont(new Font(UIHelper.getDefaultFontName(), 1, 15));
        JLabel jLabel2 = new JLabel("@" + string);
        jLabel2.setFont(new Font(UIHelper.getDefaultFontName(), 0, 12));
        jLabel2.setForeground(new Color(120, 120, 120));
        ((Container)((Object)accessible)).add((Component)object);
        ((Container)((Object)accessible)).add(Box.createVerticalStrut(3));
        ((Container)((Object)accessible)).add(jLabel2);
        JButton jButton = new JButton("B\u1ecf ch\u1eb7n");
        jButton.setFont(new Font(UIHelper.getDefaultFontName(), 0, 13));
        jButton.setBackground(new Color(220, 53, 69));
        jButton.setForeground(Color.WHITE);
        jButton.setBorderPainted(false);
        jButton.setFocusPainted(false);
        jButton.setOpaque(true);
        jButton.setContentAreaFilled(true);
        jButton.setCursor(new Cursor(12));
        jButton.setPreferredSize(new Dimension(90, 32));
        jButton.addActionListener(actionEvent -> {
            int n = JOptionPane.showConfirmDialog(this, "B\u1ea1n c\u00f3 ch\u1eafc mu\u1ed1n b\u1ecf ch\u1eb7n " + string2 + "?", "X\u00e1c nh\u1eadn b\u1ecf ch\u1eb7n", 0);
            if (n == 0) {
                this.unblockUser(string, jButton);
            }
        });
        jPanel.add((Component)jLabel, "West");
        jPanel.add((Component)((Object)accessible), "Center");
        jPanel.add((Component)jButton, "East");
        return jPanel;
    }

    private void unblockUser(final String string, final JButton jButton) {
        jButton.setEnabled(false);
        jButton.setText("\u0110ang x\u1eed l\u00fd...");
        SwingWorker<Boolean, Void> swingWorker = new SwingWorker<Boolean, Void>(){

            @Override
            protected Boolean doInBackground() {
                return BlockedUsersDialog.this.userService.unblockUser(BlockedUsersDialog.this.mainFrame.getUsername(), string);
            }

            @Override
            protected void done() {
                try {
                    boolean bl = (Boolean)this.get();
                    if (bl) {
                        JOptionPane.showMessageDialog(BlockedUsersDialog.this, "\u0110\u00e3 b\u1ecf ch\u1eb7n th\u00e0nh c\u00f4ng!", "Th\u00e0nh c\u00f4ng", 1);
                        BlockedUsersDialog.this.loadBlockedUsers();
                    } else {
                        JOptionPane.showMessageDialog(BlockedUsersDialog.this, "Kh\u00f4ng th\u1ec3 b\u1ecf ch\u1eb7n. Vui l\u00f2ng th\u1eed l\u1ea1i!", "L\u1ed7i", 0);
                        jButton.setEnabled(true);
                        jButton.setText("B\u1ecf ch\u1eb7n");
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    JOptionPane.showMessageDialog(BlockedUsersDialog.this, "L\u1ed7i: " + exception.getMessage(), "L\u1ed7i", 0);
                    jButton.setEnabled(true);
                    jButton.setText("B\u1ecf ch\u1eb7n");
                }
            }
        };
        swingWorker.execute();
    }
}

