/*
 * Decompiled with CFR 0.152.
 */
package user.gui;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.UIManager;

public class UIHelper {
    private static final boolean IS_MAC = System.getProperty("os.name").toLowerCase().contains("mac");
    private static final boolean IS_WINDOWS = System.getProperty("os.name").toLowerCase().contains("windows");
    private static final String DEFAULT_FONT = IS_MAC ? "SF Pro Display" : "Segoe UI";
    private static final String EMOJI_FONT = IS_MAC ? "Apple Color Emoji" : "Segoe UI Emoji";
    private static final String FALLBACK_FONT = "Arial";

    public static void setupLookAndFeel() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            if (IS_MAC) {
                UIManager.put("Button.arc", 10);
                UIManager.put("Component.arc", 10);
                UIManager.put("Button.background", Color.WHITE);
            }
        }
        catch (Exception exception) {
            System.err.println("Could not set look and feel: " + exception.getMessage());
        }
    }

    public static Font getFont(int n, int n2) {
        String[] stringArray;
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        for (String string : stringArray = graphicsEnvironment.getAvailableFontFamilyNames()) {
            if (!string.equals(DEFAULT_FONT)) continue;
            return new Font(DEFAULT_FONT, n, n2);
        }
        return new Font(FALLBACK_FONT, n, n2);
    }

    public static JButton createPrimaryButton(String string, Color color) {
        JButton jButton = new JButton(string);
        jButton.setFont(UIHelper.getFont(1, 14));
        jButton.setForeground(Color.WHITE);
        jButton.setBackground(color);
        jButton.setPreferredSize(new Dimension(300, 45));
        jButton.setCursor(new Cursor(12));
        jButton.setOpaque(true);
        jButton.setBorderPainted(false);
        jButton.setFocusPainted(false);
        if (IS_MAC) {
            jButton.putClientProperty("JButton.buttonType", "roundRect");
        }
        jButton.setBorder(BorderFactory.createEmptyBorder(10, 20, 10, 20));
        return jButton;
    }

    public static JButton createSecondaryButton(String string, Color color) {
        JButton jButton = new JButton(string);
        jButton.setFont(UIHelper.getFont(0, 14));
        jButton.setForeground(color);
        jButton.setBackground(Color.WHITE);
        jButton.setPreferredSize(new Dimension(300, 45));
        jButton.setCursor(new Cursor(12));
        jButton.setOpaque(true);
        jButton.setFocusPainted(false);
        if (IS_MAC) {
            jButton.putClientProperty("JButton.buttonType", "roundRect");
            jButton.setBorderPainted(true);
        }
        jButton.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(color, 1), BorderFactory.createEmptyBorder(10, 20, 10, 20)));
        return jButton;
    }

    public static JButton createLinkButton(String string, Color color) {
        JButton jButton = new JButton(string);
        jButton.setFont(UIHelper.getFont(0, 12));
        jButton.setForeground(color);
        jButton.setBorderPainted(false);
        jButton.setContentAreaFilled(false);
        jButton.setFocusPainted(false);
        jButton.setCursor(new Cursor(12));
        if (IS_MAC) {
            jButton.putClientProperty("JButton.buttonType", "text");
        }
        return jButton;
    }

    public static JTextField createStyledTextField(int n) {
        JTextField jTextField = new JTextField(n);
        jTextField.setFont(UIHelper.getFont(0, 14));
        jTextField.setPreferredSize(new Dimension(300, 45));
        jTextField.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(new Color(220, 220, 220), 1), BorderFactory.createEmptyBorder(10, 15, 10, 15)));
        return jTextField;
    }

    public static JPasswordField createStyledPasswordField(int n) {
        JPasswordField jPasswordField = new JPasswordField(n);
        jPasswordField.setFont(UIHelper.getFont(0, 14));
        jPasswordField.setPreferredSize(new Dimension(300, 45));
        jPasswordField.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(new Color(220, 220, 220), 1), BorderFactory.createEmptyBorder(10, 15, 10, 15)));
        return jPasswordField;
    }

    public static boolean isMac() {
        return IS_MAC;
    }

    public static boolean isWindows() {
        return IS_WINDOWS;
    }

    public static String getDefaultFontName() {
        return DEFAULT_FONT;
    }

    public static String getEmojiFontName() {
        return EMOJI_FONT;
    }
}

