/*
 * Decompiled with CFR 0.152.
 */
package user.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.sql.Date;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerDateModel;
import javax.swing.SwingWorker;
import user.gui.UIHelper;
import user.gui.ZaloMainFrame;
import user.service.UserService;

public class UpdateProfileDialog
extends JDialog {
    private static final Color PRIMARY_COLOR = new Color(0, 132, 255);
    private ZaloMainFrame mainFrame;
    private UserService userService;
    private JTextField fullNameField;
    private JTextField emailField;
    private JTextField addressField;
    private JSpinner birthDateSpinner;
    private JComboBox<String> genderComboBox;
    private JButton saveButton;

    public UpdateProfileDialog(ZaloMainFrame zaloMainFrame) {
        super(zaloMainFrame, "C\u1eadp nh\u1eadt th\u00f4ng tin", true);
        this.mainFrame = zaloMainFrame;
        this.userService = new UserService();
        this.initializeUI();
        this.loadCurrentInfo();
    }

    private void initializeUI() {
        this.setSize(550, 600);
        this.setLocationRelativeTo(this.mainFrame);
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBackground(PRIMARY_COLOR);
        jPanel.setBorder(BorderFactory.createEmptyBorder(15, 20, 15, 20));
        JLabel jLabel = new JLabel("C\u1eadp nh\u1eadt th\u00f4ng tin t\u00e0i kho\u1ea3n");
        jLabel.setFont(new Font(UIHelper.getDefaultFontName(), 1, 18));
        jLabel.setForeground(Color.WHITE);
        jPanel.add((Component)jLabel, "West");
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        jPanel2.setBackground(Color.WHITE);
        jPanel2.setBorder(BorderFactory.createEmptyBorder(25, 50, 25, 50));
        this.addLabel(jPanel2, "T\u00ean \u0111\u0103ng nh\u1eadp:");
        JLabel jLabel2 = new JLabel(this.mainFrame.getUsername());
        jLabel2.setFont(new Font(UIHelper.getDefaultFontName(), 0, 14));
        jLabel2.setForeground(new Color(100, 100, 100));
        jPanel2.add(jLabel2);
        jPanel2.add(Box.createVerticalStrut(15));
        this.addLabel(jPanel2, "H\u1ecd v\u00e0 t\u00ean:");
        this.fullNameField = this.createTextField();
        jPanel2.add(this.fullNameField);
        jPanel2.add(Box.createVerticalStrut(15));
        this.addLabel(jPanel2, "Email:");
        this.emailField = this.createTextField();
        jPanel2.add(this.emailField);
        jPanel2.add(Box.createVerticalStrut(15));
        this.addLabel(jPanel2, "Ng\u00e0y sinh:");
        SpinnerDateModel spinnerDateModel = new SpinnerDateModel();
        this.birthDateSpinner = new JSpinner(spinnerDateModel);
        JSpinner.DateEditor dateEditor = new JSpinner.DateEditor(this.birthDateSpinner, "dd/MM/yyyy");
        this.birthDateSpinner.setEditor(dateEditor);
        this.birthDateSpinner.setFont(new Font(UIHelper.getDefaultFontName(), 0, 14));
        this.birthDateSpinner.setPreferredSize(new Dimension(200, 35));
        this.birthDateSpinner.setMaximumSize(new Dimension(200, 35));
        this.birthDateSpinner.setAlignmentX(0.0f);
        jPanel2.add(this.birthDateSpinner);
        jPanel2.add(Box.createVerticalStrut(15));
        this.addLabel(jPanel2, "Gi\u1edbi t\u00ednh:");
        this.genderComboBox = new JComboBox<String>(new String[]{"Nam", "N\u1eef", "Kh\u00e1c"});
        this.genderComboBox.setFont(new Font(UIHelper.getDefaultFontName(), 0, 14));
        this.genderComboBox.setPreferredSize(new Dimension(150, 35));
        this.genderComboBox.setMaximumSize(new Dimension(150, 35));
        this.genderComboBox.setAlignmentX(0.0f);
        jPanel2.add(this.genderComboBox);
        jPanel2.add(Box.createVerticalStrut(15));
        this.addLabel(jPanel2, "\u0110\u1ecba ch\u1ec9:");
        this.addressField = this.createTextField();
        jPanel2.add(this.addressField);
        JScrollPane jScrollPane = new JScrollPane(jPanel2);
        jScrollPane.setBorder(null);
        jScrollPane.getVerticalScrollBar().setUnitIncrement(16);
        JPanel jPanel3 = new JPanel(new FlowLayout(2, 15, 15));
        jPanel3.setBackground(Color.WHITE);
        JButton jButton = new JButton("H\u1ee7y");
        jButton.setFont(new Font(UIHelper.getDefaultFontName(), 0, 14));
        jButton.setPreferredSize(new Dimension(100, 35));
        jButton.addActionListener(actionEvent -> this.dispose());
        this.saveButton = new JButton("L\u01b0u");
        this.saveButton.setFont(new Font(UIHelper.getDefaultFontName(), 1, 14));
        this.saveButton.setBackground(PRIMARY_COLOR);
        this.saveButton.setForeground(Color.WHITE);
        this.saveButton.setPreferredSize(new Dimension(100, 35));
        this.saveButton.setFocusPainted(false);
        this.saveButton.setBorderPainted(false);
        this.saveButton.setOpaque(true);
        this.saveButton.setContentAreaFilled(true);
        this.saveButton.addActionListener(actionEvent -> this.saveChanges());
        jPanel3.add(jButton);
        jPanel3.add(this.saveButton);
        this.add((Component)jPanel, "North");
        this.add((Component)jScrollPane, "Center");
        this.add((Component)jPanel3, "South");
    }

    private void addLabel(JPanel jPanel, String string) {
        JLabel jLabel = new JLabel(string);
        jLabel.setFont(new Font(UIHelper.getDefaultFontName(), 1, 13));
        jLabel.setAlignmentX(0.0f);
        jPanel.add(jLabel);
        jPanel.add(Box.createVerticalStrut(5));
    }

    private JTextField createTextField() {
        JTextField jTextField = new JTextField();
        jTextField.setFont(new Font(UIHelper.getDefaultFontName(), 0, 14));
        jTextField.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(new Color(200, 200, 200)), BorderFactory.createEmptyBorder(8, 10, 8, 10)));
        jTextField.setMaximumSize(new Dimension(Integer.MAX_VALUE, 35));
        jTextField.setAlignmentX(0.0f);
        return jTextField;
    }

    private void loadCurrentInfo() {
        SwingWorker<Map<String, Object>, Void> swingWorker = new SwingWorker<Map<String, Object>, Void>(){

            @Override
            protected Map<String, Object> doInBackground() {
                return UpdateProfileDialog.this.userService.getUserInfo(UpdateProfileDialog.this.mainFrame.getUsername());
            }

            @Override
            protected void done() {
                try {
                    Map map = (Map)this.get();
                    if (map != null) {
                        String string = (String)map.get("full_name");
                        String string2 = (String)map.get("email");
                        String string3 = (String)map.get("address");
                        Date date = (Date)map.get("dob");
                        String string4 = (String)map.get("gender");
                        UpdateProfileDialog.this.fullNameField.setText(string != null ? string : "");
                        UpdateProfileDialog.this.emailField.setText(string2 != null ? string2 : "");
                        UpdateProfileDialog.this.addressField.setText(string3 != null ? string3 : "");
                        if (date != null) {
                            UpdateProfileDialog.this.birthDateSpinner.setValue(new java.util.Date(date.getTime()));
                        }
                        if (string4 != null) {
                            if (string4.equalsIgnoreCase("Nam")) {
                                UpdateProfileDialog.this.genderComboBox.setSelectedIndex(0);
                            } else if (string4.equalsIgnoreCase("N\u1eef")) {
                                UpdateProfileDialog.this.genderComboBox.setSelectedIndex(1);
                            } else {
                                UpdateProfileDialog.this.genderComboBox.setSelectedIndex(2);
                            }
                        }
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        };
        swingWorker.execute();
    }

    private void saveChanges() {
        final String string = this.fullNameField.getText().trim();
        final String string2 = this.emailField.getText().trim();
        final String string3 = this.addressField.getText().trim();
        java.util.Date date = (java.util.Date)this.birthDateSpinner.getValue();
        final Date date2 = new Date(date.getTime());
        final String string4 = (String)this.genderComboBox.getSelectedItem();
        if (string.isEmpty()) {
            JOptionPane.showMessageDialog(this, "Vui l\u00f2ng nh\u1eadp h\u1ecd v\u00e0 t\u00ean!", "L\u1ed7i", 0);
            return;
        }
        this.saveButton.setEnabled(false);
        this.saveButton.setText("\u0110ang l\u01b0u...");
        SwingWorker<Boolean, Void> swingWorker = new SwingWorker<Boolean, Void>(){

            @Override
            protected Boolean doInBackground() {
                return UpdateProfileDialog.this.userService.updateUserProfile(UpdateProfileDialog.this.mainFrame.getUsername(), string, string2, string3, date2, string4);
            }

            @Override
            protected void done() {
                try {
                    boolean bl = (Boolean)this.get();
                    if (bl) {
                        JOptionPane.showMessageDialog(UpdateProfileDialog.this, "C\u1eadp nh\u1eadt th\u00f4ng tin th\u00e0nh c\u00f4ng!", "Th\u00e0nh c\u00f4ng", 1);
                        UpdateProfileDialog.this.dispose();
                    } else {
                        JOptionPane.showMessageDialog(UpdateProfileDialog.this, "C\u00f3 l\u1ed7i x\u1ea3y ra khi c\u1eadp nh\u1eadt th\u00f4ng tin!", "L\u1ed7i", 0);
                        UpdateProfileDialog.this.saveButton.setEnabled(true);
                        UpdateProfileDialog.this.saveButton.setText("L\u01b0u");
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    JOptionPane.showMessageDialog(UpdateProfileDialog.this, "L\u1ed7i: " + exception.getMessage(), "L\u1ed7i", 0);
                    UpdateProfileDialog.this.saveButton.setEnabled(true);
                    UpdateProfileDialog.this.saveButton.setText("L\u01b0u");
                }
            }
        };
        swingWorker.execute();
    }
}

