/*
 * Decompiled with CFR 0.152.
 */
package user.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Image;
import java.io.Serializable;
import java.sql.Date;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import user.gui.UIHelper;
import user.service.UserService;

public class UserProfileDialog
extends JDialog {
    private static final Color PRIMARY_COLOR = new Color(0, 132, 255);
    private static final Color BG_COLOR = new Color(245, 247, 250);
    private UserService userService;
    private String username;
    private Map<String, Object> userInfo;

    public UserProfileDialog(Frame frame, String string) {
        super(frame, "Trang c\u00e1 nh\u00e2n", true);
        this.username = string;
        this.userService = new UserService();
        this.loadUserInfo();
        this.initComponents();
    }

    private void loadUserInfo() {
        this.userInfo = this.userService.getUserInfo(this.username);
    }

    private void initComponents() {
        this.setSize(450, 550);
        this.setLocationRelativeTo(this.getParent());
        this.setResizable(false);
        this.getContentPane().setBackground(BG_COLOR);
        this.setLayout(new BorderLayout(0, 0));
        JPanel jPanel = this.createHeaderPanel();
        JPanel jPanel2 = this.createContentPanel();
        JPanel jPanel3 = this.createFooterPanel();
        this.add((Component)jPanel, "North");
        this.add((Component)jPanel2, "Center");
        this.add((Component)jPanel3, "South");
    }

    private JPanel createHeaderPanel() {
        Object object;
        Object object2;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.setBackground(PRIMARY_COLOR);
        jPanel.setBorder(new EmptyBorder(30, 20, 30, 20));
        JLabel jLabel = new JLabel();
        jLabel.setPreferredSize(new Dimension(100, 100));
        jLabel.setMaximumSize(new Dimension(100, 100));
        jLabel.setHorizontalAlignment(0);
        try {
            object2 = new ImageIcon("icons/user.png");
            object = ((ImageIcon)object2).getImage().getScaledInstance(80, 80, 4);
            jLabel.setIcon(new ImageIcon((Image)object));
        }
        catch (Exception exception) {
            jLabel.setText("\ud83d\udc64");
            jLabel.setFont(new Font(UIHelper.getDefaultFontName(), 0, 60));
            jLabel.setForeground(Color.WHITE);
        }
        jLabel.setAlignmentX(0.5f);
        object2 = this.userInfo != null ? (String)this.userInfo.get("full_name") : "";
        object = new JLabel((String)(object2 != null && !((String)object2).isEmpty() ? object2 : this.username));
        ((JComponent)object).setFont(new Font(UIHelper.getDefaultFontName(), 1, 24));
        ((JComponent)object).setForeground(Color.WHITE);
        ((JComponent)object).setAlignmentX(0.5f);
        JLabel jLabel2 = new JLabel("@" + this.username);
        jLabel2.setFont(new Font(UIHelper.getDefaultFontName(), 0, 14));
        jLabel2.setForeground(new Color(230, 240, 255));
        jLabel2.setAlignmentX(0.5f);
        jPanel.add(jLabel);
        jPanel.add(Box.createVerticalStrut(15));
        jPanel.add((Component)object);
        jPanel.add(Box.createVerticalStrut(5));
        jPanel.add(jLabel2);
        return jPanel;
    }

    private JPanel createContentPanel() {
        Serializable serializable;
        Timestamp timestamp;
        Object object;
        Object object2;
        String string;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.setBackground(Color.WHITE);
        jPanel.setBorder(new EmptyBorder(25, 30, 25, 30));
        if (this.userInfo == null) {
            JLabel jLabel = new JLabel("Kh\u00f4ng th\u1ec3 t\u1ea3i th\u00f4ng tin ng\u01b0\u1eddi d\u00f9ng");
            jLabel.setFont(new Font(UIHelper.getDefaultFontName(), 0, 14));
            jLabel.setForeground(Color.RED);
            jLabel.setAlignmentX(0.5f);
            jPanel.add(jLabel);
            JScrollPane jScrollPane = new JScrollPane(jPanel);
            jScrollPane.setBorder(null);
            jScrollPane.getVerticalScrollBar().setUnitIncrement(16);
            JPanel jPanel2 = new JPanel(new BorderLayout());
            jPanel2.add((Component)jScrollPane, "Center");
            return jPanel2;
        }
        JLabel jLabel = new JLabel("Th\u00f4ng tin c\u00e1 nh\u00e2n");
        jLabel.setFont(new Font(UIHelper.getDefaultFontName(), 1, 16));
        jLabel.setForeground(PRIMARY_COLOR);
        jLabel.setAlignmentX(0.0f);
        jPanel.add(jLabel);
        jPanel.add(Box.createVerticalStrut(20));
        String string2 = (String)this.userInfo.get("email");
        if (string2 != null && !string2.isEmpty()) {
            jPanel.add(this.createInfoRow("Email", string2));
            jPanel.add(Box.createVerticalStrut(15));
        }
        if ((string = (String)this.userInfo.get("gender")) != null && !string.isEmpty()) {
            object2 = string.equals("male") ? "Nam" : (string.equals("female") ? "N\u1eef" : "Kh\u00e1c");
            jPanel.add(this.createInfoRow("Gi\u1edbi t\u00ednh", (String)object2));
            jPanel.add(Box.createVerticalStrut(15));
        }
        if ((object2 = (Date)this.userInfo.get("dob")) != null) {
            object = new SimpleDateFormat("dd/MM/yyyy");
            jPanel.add(this.createInfoRow("Ng\u00e0y sinh", ((DateFormat)object).format((java.util.Date)object2)));
            jPanel.add(Box.createVerticalStrut(15));
        }
        if ((object = (String)this.userInfo.get("address")) != null && !((String)object).isEmpty()) {
            jPanel.add(this.createInfoRow("\u0110\u1ecba ch\u1ec9", (String)object));
            jPanel.add(Box.createVerticalStrut(15));
        }
        if ((timestamp = (Timestamp)this.userInfo.get("created_at")) != null) {
            serializable = new SimpleDateFormat("dd/MM/yyyy HH:mm");
            jPanel.add(this.createInfoRow("Ng\u00e0y tham gia", ((DateFormat)serializable).format(timestamp)));
        }
        jPanel.add(Box.createVerticalGlue());
        serializable = new JScrollPane(jPanel);
        ((JComponent)serializable).setBorder(null);
        ((JScrollPane)serializable).getVerticalScrollBar().setUnitIncrement(16);
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.add((Component)serializable, "Center");
        return jPanel3;
    }

    private JPanel createInfoRow(String string, String string2) {
        JPanel jPanel = new JPanel(new BorderLayout(10, 0));
        jPanel.setBackground(Color.WHITE);
        jPanel.setAlignmentX(0.0f);
        jPanel.setMaximumSize(new Dimension(Integer.MAX_VALUE, 30));
        JLabel jLabel = new JLabel(string);
        jLabel.setFont(new Font(UIHelper.getDefaultFontName(), 0, 13));
        jLabel.setForeground(new Color(100, 100, 100));
        jLabel.setPreferredSize(new Dimension(120, 25));
        JLabel jLabel2 = new JLabel(string2);
        jLabel2.setFont(new Font(UIHelper.getDefaultFontName(), 1, 13));
        jLabel2.setForeground(Color.BLACK);
        jPanel.add((Component)jLabel, "West");
        jPanel.add((Component)jLabel2, "Center");
        return jPanel;
    }

    private JPanel createFooterPanel() {
        JPanel jPanel = new JPanel(new FlowLayout(1, 10, 15));
        jPanel.setBackground(Color.WHITE);
        jPanel.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, new Color(230, 230, 230)));
        JButton jButton = new JButton("\u0110\u00f3ng");
        jButton.setFont(new Font(UIHelper.getDefaultFontName(), 1, 14));
        jButton.setForeground(Color.WHITE);
        jButton.setBackground(PRIMARY_COLOR);
        jButton.setOpaque(true);
        jButton.setBorderPainted(false);
        jButton.setFocusPainted(false);
        jButton.setCursor(new Cursor(12));
        jButton.setPreferredSize(new Dimension(120, 38));
        jButton.addActionListener(actionEvent -> this.dispose());
        jPanel.add(jButton);
        return jPanel;
    }
}

