/*
 * Decompiled with CFR 0.152.
 */
package user.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Image;
import java.sql.Date;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Map;
import javax.accessibility.Accessible;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingWorker;
import user.gui.UIHelper;
import user.gui.UpdateProfileDialog;
import user.gui.ZaloMainFrame;
import user.service.UserService;

public class ViewProfileDialog
extends JDialog {
    private static final Color PRIMARY_COLOR = new Color(0, 132, 255);
    private static final Color BG_COLOR = new Color(245, 247, 250);
    private ZaloMainFrame mainFrame;
    private UserService userService;
    private JPanel infoContainer;

    public ViewProfileDialog(ZaloMainFrame zaloMainFrame) {
        super(zaloMainFrame, "Th\u00f4ng tin t\u00e0i kho\u1ea3n", true);
        this.mainFrame = zaloMainFrame;
        this.userService = new UserService();
        this.initializeUI();
        this.loadUserInfo();
    }

    private void initializeUI() {
        this.setSize(500, 650);
        this.setLocationRelativeTo(this.mainFrame);
        this.setLayout(new BorderLayout());
        this.getContentPane().setBackground(BG_COLOR);
        JPanel jPanel = this.createHeaderPanel();
        this.infoContainer = new JPanel();
        this.infoContainer.setLayout(new BoxLayout(this.infoContainer, 1));
        this.infoContainer.setBackground(BG_COLOR);
        this.infoContainer.setBorder(BorderFactory.createEmptyBorder(20, 25, 20, 25));
        JScrollPane jScrollPane = new JScrollPane(this.infoContainer);
        jScrollPane.setBorder(null);
        jScrollPane.getVerticalScrollBar().setUnitIncrement(16);
        jScrollPane.setBackground(BG_COLOR);
        JPanel jPanel2 = this.createButtonPanel();
        this.add((Component)jPanel, "North");
        this.add((Component)jScrollPane, "Center");
        this.add((Component)jPanel2, "South");
    }

    private JPanel createHeaderPanel() {
        Accessible accessible;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.setBackground(PRIMARY_COLOR);
        jPanel.setBorder(BorderFactory.createEmptyBorder(25, 20, 25, 20));
        JLabel jLabel = new JLabel();
        jLabel.setHorizontalAlignment(0);
        jLabel.setAlignmentX(0.5f);
        jLabel.setPreferredSize(new Dimension(80, 80));
        try {
            accessible = new ImageIcon("icons/user.png");
            Image image = ((ImageIcon)accessible).getImage().getScaledInstance(60, 60, 4);
            jLabel.setIcon(new ImageIcon(image));
        }
        catch (Exception exception) {
            jLabel.setText("[Avatar]");
            jLabel.setFont(new Font(UIHelper.getDefaultFontName(), 1, 24));
            jLabel.setForeground(Color.WHITE);
        }
        accessible = new JLabel(this.mainFrame.getUsername(), 0);
        ((JComponent)((Object)accessible)).setFont(new Font(UIHelper.getDefaultFontName(), 1, 22));
        ((JComponent)((Object)accessible)).setForeground(Color.WHITE);
        ((JComponent)((Object)accessible)).setAlignmentX(0.5f);
        jPanel.add(jLabel);
        jPanel.add(Box.createVerticalStrut(10));
        jPanel.add((Component)((Object)accessible));
        return jPanel;
    }

    private JPanel createButtonPanel() {
        JPanel jPanel = new JPanel(new FlowLayout(2, 15, 15));
        jPanel.setBackground(Color.WHITE);
        jPanel.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, new Color(230, 230, 230)));
        JButton jButton = new JButton("Ch\u1ec9nh s\u1eeda");
        jButton.setFont(new Font(UIHelper.getDefaultFontName(), 1, 14));
        jButton.setBackground(PRIMARY_COLOR);
        jButton.setForeground(Color.WHITE);
        jButton.setPreferredSize(new Dimension(130, 38));
        jButton.setFocusPainted(false);
        jButton.setBorderPainted(false);
        jButton.setOpaque(true);
        jButton.setContentAreaFilled(true);
        jButton.setCursor(new Cursor(12));
        jButton.addActionListener(actionEvent -> {
            this.dispose();
            UpdateProfileDialog updateProfileDialog = new UpdateProfileDialog(this.mainFrame);
            updateProfileDialog.setVisible(true);
        });
        JButton jButton2 = new JButton("\u0110\u00f3ng");
        jButton2.setFont(new Font(UIHelper.getDefaultFontName(), 0, 14));
        jButton2.setPreferredSize(new Dimension(100, 38));
        jButton2.setCursor(new Cursor(12));
        jButton2.addActionListener(actionEvent -> this.dispose());
        jPanel.add(jButton);
        jPanel.add(jButton2);
        return jPanel;
    }

    private void loadUserInfo() {
        SwingWorker<Map<String, Object>, Void> swingWorker = new SwingWorker<Map<String, Object>, Void>(){

            @Override
            protected Map<String, Object> doInBackground() {
                return ViewProfileDialog.this.userService.getUserInfo(ViewProfileDialog.this.mainFrame.getUsername());
            }

            @Override
            protected void done() {
                try {
                    Map map = (Map)this.get();
                    if (map != null) {
                        Object object;
                        ViewProfileDialog.this.infoContainer.removeAll();
                        String string = (String)map.get("username");
                        String string2 = (String)map.get("full_name");
                        String string3 = (String)map.get("email");
                        String string4 = (String)map.get("address");
                        Date date = (Date)map.get("dob");
                        String string5 = (String)map.get("gender");
                        Timestamp timestamp = (Timestamp)map.get("created_at");
                        ViewProfileDialog.this.addSectionTitle("Th\u00f4ng tin c\u00e1 nh\u00e2n");
                        ViewProfileDialog.this.addInfoCard("T\u00ean \u0111\u0103ng nh\u1eadp", string != null ? string : "N/A");
                        ViewProfileDialog.this.addInfoCard("H\u1ecd v\u00e0 t\u00ean", string2 != null && !string2.isEmpty() ? string2 : "Ch\u01b0a c\u1eadp nh\u1eadt");
                        String string6 = "Ch\u01b0a c\u1eadp nh\u1eadt";
                        if (date != null) {
                            object = new SimpleDateFormat("dd/MM/yyyy");
                            string6 = ((DateFormat)object).format(date);
                        }
                        ViewProfileDialog.this.addInfoCard("Ng\u00e0y sinh", string6);
                        ViewProfileDialog.this.addInfoCard("Gi\u1edbi t\u00ednh", string5 != null && !string5.isEmpty() ? string5 : "Ch\u01b0a c\u1eadp nh\u1eadt");
                        ViewProfileDialog.this.infoContainer.add(Box.createVerticalStrut(15));
                        ViewProfileDialog.this.addSectionTitle("Th\u00f4ng tin li\u00ean h\u1ec7");
                        ViewProfileDialog.this.addInfoCard("Email", string3 != null && !string3.isEmpty() ? string3 : "Ch\u01b0a c\u1eadp nh\u1eadt");
                        ViewProfileDialog.this.addInfoCard("\u0110\u1ecba ch\u1ec9", string4 != null && !string4.isEmpty() ? string4 : "Ch\u01b0a c\u1eadp nh\u1eadt");
                        ViewProfileDialog.this.infoContainer.add(Box.createVerticalStrut(15));
                        ViewProfileDialog.this.addSectionTitle("Th\u00f4ng tin t\u00e0i kho\u1ea3n");
                        object = "N/A";
                        if (timestamp != null) {
                            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd/MM/yyyy HH:mm");
                            object = simpleDateFormat.format(timestamp);
                        }
                        ViewProfileDialog.this.addInfoCard("Ng\u00e0y t\u1ea1o t\u00e0i kho\u1ea3n", (String)object);
                        ViewProfileDialog.this.infoContainer.revalidate();
                        ViewProfileDialog.this.infoContainer.repaint();
                    } else {
                        JOptionPane.showMessageDialog(ViewProfileDialog.this, "Kh\u00f4ng th\u1ec3 t\u1ea3i th\u00f4ng tin t\u00e0i kho\u1ea3n!", "L\u1ed7i", 0);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    JOptionPane.showMessageDialog(ViewProfileDialog.this, "L\u1ed7i khi t\u1ea3i th\u00f4ng tin: " + exception.getMessage(), "L\u1ed7i", 0);
                }
            }
        };
        swingWorker.execute();
    }

    private void addSectionTitle(String string) {
        JLabel jLabel = new JLabel(string);
        jLabel.setFont(new Font(UIHelper.getDefaultFontName(), 1, 15));
        jLabel.setForeground(new Color(80, 80, 80));
        jLabel.setAlignmentX(0.0f);
        jLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 12, 0));
        this.infoContainer.add(jLabel);
    }

    private void addInfoCard(String string, String string2) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.setBackground(Color.WHITE);
        jPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(new Color(220, 220, 220), 1), BorderFactory.createEmptyBorder(14, 16, 14, 16)));
        jPanel.setAlignmentX(0.0f);
        JLabel jLabel = new JLabel(string);
        jLabel.setFont(new Font(UIHelper.getDefaultFontName(), 0, 12));
        jLabel.setForeground(new Color(130, 130, 130));
        jLabel.setAlignmentX(0.0f);
        JLabel jLabel2 = new JLabel(string2);
        jLabel2.setFont(new Font(UIHelper.getDefaultFontName(), 1, 15));
        jLabel2.setForeground(new Color(30, 30, 30));
        jLabel2.setAlignmentX(0.0f);
        jPanel.add(jLabel);
        jPanel.add(Box.createVerticalStrut(6));
        jPanel.add(jLabel2);
        int n = 70;
        jPanel.setPreferredSize(new Dimension(450, n));
        jPanel.setMaximumSize(new Dimension(Integer.MAX_VALUE, n));
        this.infoContainer.add(jPanel);
        this.infoContainer.add(Box.createVerticalStrut(10));
    }
}

