/*
 * Decompiled with CFR 0.152.
 */
package user.gui;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import user.gui.ChatContentPanel;
import user.gui.ChatListPanel;
import user.gui.ContactPanel;
import user.gui.FriendListPanel;
import user.gui.FriendRequestPanel;
import user.gui.GroupChatPanel;
import user.gui.GroupListPanel;
import user.gui.SidebarPanel;
import user.gui.UIHelper;
import user.socket.Message;
import user.socket.SocketClient;

public class ZaloMainFrame
extends JFrame {
    private static final Color SIDEBAR_COLOR = new Color(0, 132, 255);
    private static final Color CHAT_LIST_BG = new Color(250, 250, 250);
    private static final Color CHAT_CONTENT_BG = Color.WHITE;
    private static final Color PRIMARY_COLOR = new Color(0, 132, 255);
    private SidebarPanel sidebarPanel;
    private ChatListPanel chatListPanel;
    private ContactPanel contactPanel;
    private ChatContentPanel chatContentPanel;
    private FriendRequestPanel friendRequestPanel;
    private FriendListPanel friendListPanel;
    private GroupListPanel groupListPanel;
    private GroupChatPanel currentGroupChatPanel;
    private int currentGroupId = -1;
    private JPanel leftPanel;
    private CardLayout leftCardLayout;
    private JPanel rightPanel;
    private CardLayout rightCardLayout;
    private String username;
    private SocketClient socketClient;

    public ZaloMainFrame(String string) {
        this.username = string;
        this.initializeComponents();
        this.setupLayout();
        this.initializeSocket();
    }

    private void initializeComponents() {
        this.setTitle("Zalo - " + this.username);
        this.setDefaultCloseOperation(3);
        this.setExtendedState(6);
        this.setMinimumSize(new Dimension(1000, 700));
        this.sidebarPanel = new SidebarPanel(this);
        this.chatListPanel = new ChatListPanel(this);
        this.contactPanel = new ContactPanel(this);
        this.chatContentPanel = new ChatContentPanel(this);
        this.leftCardLayout = new CardLayout();
        this.leftPanel = new JPanel(this.leftCardLayout);
        this.leftPanel.add((Component)this.chatListPanel, "CHAT");
        this.leftPanel.add((Component)this.contactPanel, "CONTACT");
        this.rightCardLayout = new CardLayout();
        this.rightPanel = new JPanel(this.rightCardLayout);
        this.rightPanel.add((Component)this.chatContentPanel, "CHAT_CONTENT");
        this.friendListPanel = new FriendListPanel(this);
        this.rightPanel.add((Component)this.friendListPanel, "FRIENDS");
        this.groupListPanel = new GroupListPanel(this);
        this.rightPanel.add((Component)this.groupListPanel, "GROUPS");
        this.friendRequestPanel = new FriendRequestPanel(this);
        this.rightPanel.add((Component)this.friendRequestPanel, "FRIEND_REQUESTS");
    }

    private void setupLayout() {
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)this.sidebarPanel, "West");
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)this.leftPanel, "West");
        jPanel2.add((Component)this.rightPanel, "Center");
        jPanel.add((Component)jPanel2, "Center");
        this.add(jPanel);
    }

    private void initializeSocket() {
        this.socketClient = new SocketClient(this.username, this::handleIncomingMessage);
        new Thread(() -> {
            boolean bl = this.socketClient.connect();
            if (!bl) {
                System.err.println("\u26a0\ufe0f Kh\u00f4ng th\u1ec3 k\u1ebft n\u1ed1i \u0111\u1ebfn chat server. Socket features s\u1ebd b\u1ecb t\u1eaft.");
            } else {
                System.out.println("\u2705 Connected to chat server!");
            }
        }).start();
    }

    private void handleIncomingMessage(Message message) {
        SwingUtilities.invokeLater(() -> {
            if (message.getType() == Message.MessageType.PRIVATE_MESSAGE || message.getType() == Message.MessageType.BROADCAST) {
                this.chatContentPanel.handleMessage(message);
                this.chatListPanel.updateChatList(message);
            } else if (message.getType() == Message.MessageType.USER_JOINED || message.getType() == Message.MessageType.USER_LEFT || message.getType() == Message.MessageType.ONLINE_USERS) {
                this.chatContentPanel.refreshOnlineStatus();
                if (this.friendListPanel != null) {
                    this.friendListPanel.refreshOnlineStatus();
                }
                if (this.chatListPanel != null && this.socketClient != null) {
                    this.chatListPanel.updateOnlineUsers(this.socketClient.getOnlineUsers());
                }
            } else if (message.getType() == Message.MessageType.FRIEND_REQUEST_SENT) {
                System.out.println("\ud83d\udd14 Nh\u1eadn th\u00f4ng b\u00e1o l\u1eddi m\u1eddi k\u1ebft b\u1ea1n t\u1eeb: " + message.getSender());
                if (this.friendRequestPanel != null) {
                    this.friendRequestPanel.refreshFriendRequests();
                }
            } else if (message.getType() == Message.MessageType.FRIEND_REQUEST_ACCEPTED) {
                System.out.println("\u2705 L\u1eddi m\u1eddi k\u1ebft b\u1ea1n \u0111\u01b0\u1ee3c ch\u1ea5p nh\u1eadn: " + message.getContent());
                if (this.friendRequestPanel != null) {
                    this.friendRequestPanel.refreshFriendRequests();
                }
                if (this.chatListPanel != null) {
                    this.chatListPanel.refreshChatList();
                }
                if (this.friendListPanel != null) {
                    this.friendListPanel.refreshFriendList();
                }
            } else if (message.getType() == Message.MessageType.FRIEND_REQUEST_REJECTED) {
                System.out.println("\u274c L\u1eddi m\u1eddi k\u1ebft b\u1ea1n b\u1ecb t\u1eeb ch\u1ed1i: " + message.getContent());
                if (this.friendRequestPanel != null) {
                    this.friendRequestPanel.refreshFriendRequests();
                }
            } else if (message.getType() == Message.MessageType.FRIEND_REQUEST_RECALLED) {
                System.out.println("\u21a9\ufe0f L\u1eddi m\u1eddi k\u1ebft b\u1ea1n b\u1ecb thu h\u1ed3i: " + message.getContent());
                if (this.friendRequestPanel != null) {
                    this.friendRequestPanel.refreshFriendRequests();
                }
            } else if (message.getType() == Message.MessageType.UNFRIEND) {
                System.out.println("\ud83d\udc94 B\u1ecb h\u1ee7y k\u1ebft b\u1ea1n: " + message.getContent());
                if (this.chatListPanel != null) {
                    this.chatListPanel.refreshChatList();
                }
                if (this.friendListPanel != null) {
                    this.friendListPanel.refreshFriendList();
                }
                SwingUtilities.invokeLater(() -> JOptionPane.showMessageDialog(this, message.getSender() + " \u0111\u00e3 h\u1ee7y k\u1ebft b\u1ea1n v\u1edbi b\u1ea1n", "Th\u00f4ng b\u00e1o", 1));
            } else if (message.getType() == Message.MessageType.BLOCK) {
                System.out.println("\ud83d\udeab B\u1ecb ch\u1eb7n: " + message.getContent());
                if (this.chatListPanel != null) {
                    this.chatListPanel.refreshChatList();
                }
                if (this.friendListPanel != null) {
                    this.friendListPanel.refreshFriendList();
                }
                SwingUtilities.invokeLater(() -> JOptionPane.showMessageDialog(this, message.getSender() + " \u0111\u00e3 ch\u1eb7n b\u1ea1n", "Th\u00f4ng b\u00e1o", 2));
            } else if (message.getType() == Message.MessageType.GROUP_MESSAGE) {
                int n = (Integer)message.getData();
                System.out.println("\ud83d\udce8 Nh\u1eadn tin nh\u1eafn nh\u00f3m " + n + " t\u1eeb: " + message.getSender());
                if (this.currentGroupChatPanel != null && this.currentGroupId == n) {
                    this.currentGroupChatPanel.handleIncomingMessage(message);
                }
            } else if (message.getType() == Message.MessageType.GROUP_CREATED) {
                String string = message.getContent();
                String string2 = message.getSender();
                System.out.println("\ud83d\udce8 Nh\u1eadn th\u00f4ng b\u00e1o nh\u00f3m m\u1edbi: " + string + " t\u1eeb " + string2);
                if (this.groupListPanel != null) {
                    this.groupListPanel.refreshGroupList();
                }
                SwingUtilities.invokeLater(() -> JOptionPane.showMessageDialog(this, string2 + " \u0111\u00e3 th\u00eam b\u1ea1n v\u00e0o nh\u00f3m \"" + string + "\"", "Nh\u00f3m m\u1edbi", 1));
            }
        });
    }

    public void sendFriendRequestNotification(String string) {
        if (this.socketClient != null && this.socketClient.isConnected()) {
            Message message = new Message(Message.MessageType.FRIEND_REQUEST_SENT, this.username, string, this.username + " \u0111\u00e3 g\u1eedi l\u1eddi m\u1eddi k\u1ebft b\u1ea1n");
            this.socketClient.sendMessage(message);
            System.out.println("\ud83d\udce4 G\u1eedi notification l\u1eddi m\u1eddi k\u1ebft b\u1ea1n \u0111\u1ebfn: " + string);
        }
    }

    public void sendFriendRequestAcceptedNotification(String string) {
        if (this.socketClient != null && this.socketClient.isConnected()) {
            Message message = new Message(Message.MessageType.FRIEND_REQUEST_ACCEPTED, this.username, string, this.username + " \u0111\u00e3 ch\u1ea5p nh\u1eadn l\u1eddi m\u1eddi k\u1ebft b\u1ea1n");
            this.socketClient.sendMessage(message);
            System.out.println("\ud83d\udce4 G\u1eedi notification ch\u1ea5p nh\u1eadn l\u1eddi m\u1eddi \u0111\u1ebfn: " + string);
        }
    }

    public void sendFriendRequestRejectedNotification(String string) {
        if (this.socketClient != null && this.socketClient.isConnected()) {
            Message message = new Message(Message.MessageType.FRIEND_REQUEST_REJECTED, this.username, string, this.username + " \u0111\u00e3 t\u1eeb ch\u1ed1i l\u1eddi m\u1eddi k\u1ebft b\u1ea1n");
            this.socketClient.sendMessage(message);
            System.out.println("\ud83d\udce4 G\u1eedi notification t\u1eeb ch\u1ed1i l\u1eddi m\u1eddi \u0111\u1ebfn: " + string);
        }
    }

    public void sendFriendRequestRecalledNotification(String string) {
        if (this.socketClient != null && this.socketClient.isConnected()) {
            Message message = new Message(Message.MessageType.FRIEND_REQUEST_RECALLED, this.username, string, this.username + " \u0111\u00e3 thu h\u1ed3i l\u1eddi m\u1eddi k\u1ebft b\u1ea1n");
            this.socketClient.sendMessage(message);
            System.out.println("\ud83d\udce4 G\u1eedi notification thu h\u1ed3i l\u1eddi m\u1eddi \u0111\u1ebfn: " + string);
        }
    }

    public void sendUnfriendNotification(String string) {
        if (this.socketClient != null && this.socketClient.isConnected()) {
            Message message = new Message(Message.MessageType.UNFRIEND, this.username, string, this.username + " \u0111\u00e3 h\u1ee7y k\u1ebft b\u1ea1n v\u1edbi b\u1ea1n");
            this.socketClient.sendMessage(message);
            System.out.println("\ud83d\udce4 G\u1eedi notification h\u1ee7y k\u1ebft b\u1ea1n \u0111\u1ebfn: " + string);
        }
    }

    public void sendBlockNotification(String string) {
        if (this.socketClient != null && this.socketClient.isConnected()) {
            Message message = new Message(Message.MessageType.BLOCK, this.username, string, this.username + " \u0111\u00e3 ch\u1eb7n b\u1ea1n");
            this.socketClient.sendMessage(message);
            System.out.println("\ud83d\udce4 G\u1eedi notification ch\u1eb7n user \u0111\u1ebfn: " + string);
        }
    }

    public void refreshFriendRequestPanel() {
        if (this.friendRequestPanel != null) {
            this.friendRequestPanel.refreshFriendRequests();
        }
    }

    public void refreshChatAndFriendList() {
        System.out.println("\ud83d\udd04 Refreshing chat list and friend list for current user...");
        if (this.chatListPanel != null) {
            this.chatListPanel.refreshChatList();
        }
        if (this.friendListPanel != null) {
            this.friendListPanel.refreshFriendList();
        }
    }

    public void refreshChatList() {
        if (this.chatListPanel != null) {
            this.chatListPanel.refreshChatList();
        }
    }

    public void sendMessage(String string, String string2) {
        if (this.socketClient != null && this.socketClient.isConnected()) {
            System.out.println("\ud83d\udce4 G\u1eedi tin nh\u1eafn \u0111\u1ebfn " + string2 + ": " + string);
            if (string2 == null) {
                this.socketClient.sendChatMessage(string);
            } else {
                this.socketClient.sendPrivateMessage(string2, string);
            }
        } else {
            System.err.println("\u274c Socket ch\u01b0a k\u1ebft n\u1ed1i! Kh\u00f4ng th\u1ec3 g\u1eedi tin nh\u1eafn.");
            SwingUtilities.invokeLater(() -> JOptionPane.showMessageDialog(this, "Kh\u00f4ng th\u1ec3 g\u1eedi tin nh\u1eafn!\nVui l\u00f2ng ki\u1ec3m tra k\u1ebft n\u1ed1i server.", "L\u1ed7i k\u1ebft n\u1ed1i", 0));
        }
    }

    public void openChat(String string) {
        this.chatContentPanel.openChat(string);
    }

    public void openChatAndScrollToMessage(String string, int n) {
        this.chatContentPanel.openChat(string);
        SwingUtilities.invokeLater(() -> {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            this.chatContentPanel.scrollToMessage(n);
        });
    }

    public void scrollToMessageInChat(int n) {
        this.chatContentPanel.scrollToMessage(n);
    }

    public void openGroupChat(int n, String string, boolean bl) {
        this.openGroupChat(n, string, bl, false);
    }

    public void openGroupChat(int n, String string, boolean bl, boolean bl2) {
        this.currentGroupId = n;
        if (this.currentGroupChatPanel != null) {
            this.rightPanel.remove(this.currentGroupChatPanel);
        }
        this.currentGroupChatPanel = new GroupChatPanel(this, n, string, bl, bl2);
        this.rightPanel.add((Component)this.currentGroupChatPanel, "GROUP_CHAT");
        this.rightPanel.revalidate();
        this.rightPanel.repaint();
        this.rightCardLayout.show(this.rightPanel, "GROUP_CHAT");
    }

    public String getUsername() {
        return this.username;
    }

    public SocketClient getSocketClient() {
        return this.socketClient;
    }

    public void showChatPanel() {
        this.leftCardLayout.show(this.leftPanel, "CHAT");
        this.rightCardLayout.show(this.rightPanel, "CHAT_CONTENT");
    }

    public void showContactPanel() {
        this.leftCardLayout.show(this.leftPanel, "CONTACT");
        this.rightCardLayout.show(this.rightPanel, "FRIEND_REQUESTS");
    }

    public void showGroupList() {
        this.leftCardLayout.show(this.leftPanel, "CONTACT");
        this.rightCardLayout.show(this.rightPanel, "GROUPS");
        if (this.groupListPanel != null) {
            this.groupListPanel.refreshGroupList();
        }
    }

    public void refreshGroupList() {
        if (this.groupListPanel != null) {
            this.groupListPanel.refreshGroupList();
        }
    }

    public void updateChatListAfterDelete(String string) {
        if (this.chatListPanel != null) {
            this.chatListPanel.updateChatItemAfterDelete(string);
        }
    }

    public void showContactContent(String string) {
        this.rightCardLayout.show(this.rightPanel, string);
    }

    public void switchToTab(String string) {
        if ("chat".equalsIgnoreCase(string)) {
            this.showChatPanel();
        } else if ("contact".equalsIgnoreCase(string)) {
            this.showContactPanel();
        }
    }

    private JPanel createPlaceholderPanel(String string) {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBackground(Color.WHITE);
        JLabel jLabel = new JLabel(string, 0);
        jLabel.setFont(new Font(UIHelper.getDefaultFontName(), 1, 18));
        jLabel.setForeground(new Color(150, 150, 150));
        jPanel.add((Component)jLabel, "Center");
        return jPanel;
    }

    @Override
    public void dispose() {
        if (this.socketClient != null) {
            this.socketClient.disconnect();
        }
        super.dispose();
    }

    public static void main(String[] stringArray) {
        UIHelper.setupLookAndFeel();
        SwingUtilities.invokeLater(() -> {
            String string = JOptionPane.showInputDialog(null, "Nh\u1eadp t\u00ean c\u1ee7a b\u1ea1n:", "\u0110\u0103ng nh\u1eadp Zalo", 3);
            if (string != null && !string.trim().isEmpty()) {
                ZaloMainFrame zaloMainFrame = new ZaloMainFrame(string.trim());
                zaloMainFrame.setVisible(true);
            } else {
                System.exit(0);
            }
        });
    }
}

