/*
 * Decompiled with CFR 0.152.
 */
package admin.gui;

import admin.service.DatabaseConnection;
import admin.service.SpamReportDAO;
import admin.service.UserDAO;
import admin.socket.SpamReport;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumnModel;

public class SpamReportPanel
extends JPanel {
    private static final Color DANGER_RED = new Color(220, 53, 69);
    private static final Color ZALO_BLUE = new Color(0, 102, 255);
    private static final Color SUCCESS_GREEN = new Color(40, 167, 69);
    private static final Color WARNING_ORANGE = new Color(255, 193, 7);
    private static final Color NEUTRAL_GRAY = new Color(108, 117, 125);
    private static final Color INFO_CYAN = new Color(23, 162, 184);
    private JTable spamTable;
    private DefaultTableModel tableModel;
    private JComboBox<String> statusFilter;
    private JComboBox<String> timeFilterCombo;
    private JComboBox<String> sortCombo;
    private JTextField searchField;
    private JComboBox<String> searchTypeCombo;
    private JLabel totalLabel;
    private JLabel pendingLabel;
    private JLabel resolvedLabel;
    private JLabel rejectedLabel;
    private SpamReportDAO spamReportDAO;
    private UserDAO userDAO;
    private Map<Integer, SpamReport> reportsMap = new HashMap<Integer, SpamReport>();
    private DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("dd/MM/yyyy HH:mm");

    public SpamReportPanel() {
        this.spamReportDAO = new SpamReportDAO();
        this.userDAO = new UserDAO();
        this.initComponents();
        this.setupLayout();
        this.loadSpamReportsFromDatabase();
        this.setupEventHandlers();
    }

    private void initComponents() {
        Object[] objectArray = new String[]{"ID", "Ng\u01b0\u1eddi b\u00e1o c\u00e1o", "Ng\u01b0\u1eddi b\u1ecb b\u00e1o c\u00e1o", "L\u00fd do", "Tr\u1ea1ng th\u00e1i", "Ng\u00e0y b\u00e1o c\u00e1o"};
        this.tableModel = new DefaultTableModel(objectArray, 0){

            @Override
            public boolean isCellEditable(int n, int n2) {
                return false;
            }
        };
        this.spamTable = new JTable(this.tableModel);
        this.spamTable.setRowHeight(28);
        this.spamTable.setAutoCreateRowSorter(true);
        this.spamTable.getTableHeader().setFont(new Font("Arial", 1, 13));
        this.spamTable.getTableHeader().setBackground(Color.WHITE);
        this.spamTable.getTableHeader().setForeground(Color.BLACK);
        TableColumnModel tableColumnModel = this.spamTable.getColumnModel();
        tableColumnModel.getColumn(0).setPreferredWidth(50);
        tableColumnModel.getColumn(1).setPreferredWidth(130);
        tableColumnModel.getColumn(2).setPreferredWidth(150);
        tableColumnModel.getColumn(3).setPreferredWidth(200);
        tableColumnModel.getColumn(4).setPreferredWidth(100);
        tableColumnModel.getColumn(5).setPreferredWidth(120);
        this.searchField = new JTextField(20);
        this.searchTypeCombo = new JComboBox<String>(new String[]{"T\u00ecm ng\u01b0\u1eddi b\u1ecb b\u00e1o c\u00e1o", "T\u00ecm ng\u01b0\u1eddi b\u00e1o c\u00e1o"});
        this.timeFilterCombo = new JComboBox<String>(new String[]{"T\u1ea5t c\u1ea3 th\u1eddi gian", "H\u00f4m nay", "7 ng\u00e0y qua", "30 ng\u00e0y qua", "Th\u00e1ng n\u00e0y"});
        this.statusFilter = new JComboBox<String>(new String[]{"T\u1ea5t c\u1ea3 tr\u1ea1ng th\u00e1i", "Ch\u1edd x\u1eed l\u00fd", "\u0110\u00e3 x\u1eed l\u00fd", "T\u1eeb ch\u1ed1i"});
        this.sortCombo = new JComboBox<String>(new String[]{"S\u1eafp x\u1ebfp theo th\u1eddi gian (M\u1edbi nh\u1ea5t)", "S\u1eafp x\u1ebfp theo th\u1eddi gian (C\u0169 nh\u1ea5t)", "S\u1eafp x\u1ebfp theo ng\u01b0\u1eddi b\u1ecb b\u00e1o c\u00e1o (A-Z)", "S\u1eafp x\u1ebfp theo ng\u01b0\u1eddi b\u1ecb b\u00e1o c\u00e1o (Z-A)", "S\u1eafp x\u1ebfp theo ng\u01b0\u1eddi b\u00e1o c\u00e1o (A-Z)", "S\u1eafp x\u1ebfp theo ng\u01b0\u1eddi b\u00e1o c\u00e1o (Z-A)"});
    }

    private void loadSpamReportsFromDatabase() {
        try {
            List<SpamReport> list = this.spamReportDAO.getAllSpamReports();
            this.displaySpamReports(list);
            this.updateStatistics(list);
        }
        catch (SQLException sQLException) {
            String string = sQLException.getMessage();
            String string2 = "L\u1ed7i load d\u1eef li\u1ec7u b\u00e1o c\u00e1o spam: " + string;
            if (string != null && (string.contains("connection") || string.contains("Connection"))) {
                string2 = string2 + "\n\nVui l\u00f2ng ki\u1ec3m tra:\n- K\u1ebft n\u1ed1i database\n- File config.properties\nHo\u1eb7c li\u00ean h\u1ec7 admin \u0111\u1ec3 \u0111\u01b0\u1ee3c h\u1ed7 tr\u1ee3.";
            }
            this.showError(string2);
            sQLException.printStackTrace();
        }
    }

    private void displaySpamReports(List<SpamReport> list) {
        this.tableModel.setRowCount(0);
        this.reportsMap.clear();
        for (SpamReport spamReport : list) {
            Object[] objectArray = new Object[]{spamReport.getId(), spamReport.getReporterName(), spamReport.getReportedUserName(), spamReport.getReason(), spamReport.getStatus(), spamReport.getCreatedAt() != null ? spamReport.getCreatedAt().format(this.dateTimeFormatter) : ""};
            this.tableModel.addRow(objectArray);
            this.reportsMap.put(spamReport.getId(), spamReport);
        }
    }

    private void setupLayout() {
        this.setLayout(new BorderLayout(10, 10));
        this.setBorder(new EmptyBorder(15, 15, 15, 15));
        this.setBackground(new Color(248, 249, 250));
        JPanel jPanel = this.createFilterPanel();
        this.add((Component)jPanel, "North");
        JPanel jPanel2 = this.createTablePanel();
        this.add((Component)jPanel2, "Center");
        JPanel jPanel3 = this.createButtonPanel();
        this.add((Component)jPanel3, "South");
    }

    private JPanel createFilterPanel() {
        JLabel jLabel;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.setBackground(Color.WHITE);
        jPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY), new EmptyBorder(15, 15, 15, 15)));
        ImageIcon imageIcon = this.loadIcon("search", 18, 18);
        if (imageIcon != null) {
            jLabel = new JLabel("T\u00ecm ki\u1ebfm & L\u1ecdc b\u00e1o c\u00e1o spam", imageIcon, 2);
            jLabel.setIconTextGap(6);
        } else {
            jLabel = new JLabel("T\u00ecm ki\u1ebfm & L\u1ecdc b\u00e1o c\u00e1o spam");
        }
        jLabel.setFont(new Font("Arial", 1, 14));
        jLabel.setForeground(ZALO_BLUE);
        jLabel.setAlignmentX(0.0f);
        jPanel.add(jLabel);
        jPanel.add(Box.createVerticalStrut(10));
        JPanel jPanel2 = new JPanel(new FlowLayout(0, 10, 5));
        jPanel2.setOpaque(false);
        jPanel2.setAlignmentX(0.0f);
        jPanel2.add(new JLabel("Lo\u1ea1i t\u00ecm ki\u1ebfm:"));
        this.searchTypeCombo.setPreferredSize(new Dimension(170, 30));
        jPanel2.add(this.searchTypeCombo);
        jPanel2.add(new JLabel("T\u1eeb kh\u00f3a:"));
        this.searchField.setPreferredSize(new Dimension(200, 30));
        jPanel2.add(this.searchField);
        jPanel.add(jPanel2);
        jPanel.add(Box.createVerticalStrut(5));
        JPanel jPanel3 = new JPanel(new FlowLayout(0, 10, 5));
        jPanel3.setOpaque(false);
        jPanel3.setAlignmentX(0.0f);
        jPanel3.add(new JLabel("Th\u1eddi gian:"));
        this.timeFilterCombo.setPreferredSize(new Dimension(140, 30));
        jPanel3.add(this.timeFilterCombo);
        jPanel3.add(Box.createHorizontalStrut(10));
        jPanel3.add(new JLabel("Tr\u1ea1ng th\u00e1i:"));
        this.statusFilter.setPreferredSize(new Dimension(130, 30));
        jPanel3.add(this.statusFilter);
        jPanel3.add(Box.createHorizontalStrut(10));
        jPanel3.add(new JLabel("S\u1eafp x\u1ebfp:"));
        this.sortCombo.setPreferredSize(new Dimension(240, 30));
        jPanel3.add(this.sortCombo);
        jPanel.add(jPanel3);
        jPanel.add(Box.createVerticalStrut(5));
        JPanel jPanel4 = new JPanel(new FlowLayout(0, 10, 5));
        jPanel4.setOpaque(false);
        jPanel4.setAlignmentX(0.0f);
        JButton jButton = this.createStyledButton("T\u00ecm ki\u1ebfm + L\u1ecdc", ZALO_BLUE);
        jPanel4.add(jButton);
        JButton jButton2 = this.createStyledButton("\u0110\u1eb7t l\u1ea1i", ZALO_BLUE);
        jPanel4.add(jButton2);
        jPanel.add(jPanel4);
        return jPanel;
    }

    private JPanel createTablePanel() {
        JLabel jLabel;
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBackground(Color.WHITE);
        jPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY), new EmptyBorder(10, 10, 10, 10)));
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.setOpaque(false);
        ImageIcon imageIcon = this.loadIcon("spam", 18, 18);
        if (imageIcon != null) {
            jLabel = new JLabel("Danh s\u00e1ch b\u00e1o c\u00e1o spam", imageIcon, 2);
            jLabel.setIconTextGap(6);
        } else {
            jLabel = new JLabel("Danh s\u00e1ch b\u00e1o c\u00e1o spam");
        }
        jLabel.setFont(new Font("Arial", 1, 16));
        jLabel.setForeground(ZALO_BLUE);
        JPanel jPanel3 = new JPanel(new FlowLayout(2, 15, 0));
        jPanel3.setOpaque(false);
        if (this.pendingLabel == null) {
            this.pendingLabel = new JLabel("\u23f3 Pending: 0");
        }
        this.pendingLabel.setFont(new Font("Arial", 0, 12));
        this.pendingLabel.setForeground(WARNING_ORANGE);
        if (this.resolvedLabel == null) {
            this.resolvedLabel = new JLabel("\u2705 Resolved: 0");
        }
        this.resolvedLabel.setFont(new Font("Arial", 0, 12));
        this.resolvedLabel.setForeground(SUCCESS_GREEN);
        if (this.rejectedLabel == null) {
            this.rejectedLabel = new JLabel("\u274c Rejected: 0");
        }
        this.rejectedLabel.setFont(new Font("Arial", 0, 12));
        this.rejectedLabel.setForeground(DANGER_RED);
        if (this.totalLabel == null) {
            this.totalLabel = new JLabel("T\u1ed5ng: 0");
        }
        this.totalLabel.setFont(new Font("Arial", 1, 12));
        jPanel3.add(this.pendingLabel);
        jPanel3.add(this.resolvedLabel);
        jPanel3.add(this.rejectedLabel);
        jPanel3.add(this.totalLabel);
        jPanel2.add((Component)jLabel, "West");
        jPanel2.add((Component)jPanel3, "East");
        jPanel2.setBorder(new EmptyBorder(0, 0, 10, 0));
        jPanel.add((Component)jPanel2, "North");
        jPanel.add((Component)new JScrollPane(this.spamTable), "Center");
        return jPanel;
    }

    private JPanel createButtonPanel() {
        JPanel jPanel = new JPanel(new FlowLayout(1, 15, 10));
        jPanel.setOpaque(false);
        JButton jButton = this.createStyledButtonWithIcon("X\u1eed l\u00fd b\u00e1o c\u00e1o", INFO_CYAN, "process");
        jButton.addActionListener(actionEvent -> this.processReport());
        JButton jButton2 = this.createStyledButtonWithIcon("Kh\u00f3a t\u00e0i kho\u1ea3n", INFO_CYAN, "lock");
        jButton2.addActionListener(actionEvent -> this.lockUserAccount());
        JButton jButton3 = this.createStyledButtonWithIcon("Xu\u1ea5t CSV", INFO_CYAN, "export");
        jButton3.addActionListener(actionEvent -> this.exportSpamReportsToCSV());
        jPanel.add(jButton);
        jPanel.add(jButton2);
        jPanel.add(jButton3);
        return jPanel;
    }

    private void setupEventHandlers() {
        this.addActionToButton("T\u00ecm ki\u1ebfm + L\u1ecdc", actionEvent -> this.handleSearchAndFilter());
        this.addActionToButton("\u21ba \u0110\u1eb7t l\u1ea1i", actionEvent -> this.handleReset());
        this.addActionToButton("\u2705 X\u1eed l\u00fd b\u00e1o c\u00e1o", actionEvent -> this.processReport());
        this.addActionToButton("\ud83d\udd12 Kh\u00f3a t\u00e0i kho\u1ea3n", actionEvent -> this.lockUserAccount());
        this.addActionToButton("\ud83d\udcca Xu\u1ea5t CSV", actionEvent -> this.handleExportCSV());
    }

    private void handleSearchAndFilter() {
        try {
            String string = this.searchField.getText().trim();
            String string2 = (String)this.searchTypeCombo.getSelectedItem();
            String string3 = "T\u00ecm ng\u01b0\u1eddi b\u00e1o c\u00e1o".equals(string2) ? "reporter" : "reported";
            String string4 = (String)this.timeFilterCombo.getSelectedItem();
            String string5 = (String)this.statusFilter.getSelectedItem();
            String string6 = (String)this.sortCombo.getSelectedItem();
            List<SpamReport> list = this.spamReportDAO.searchSpamReports(string3, string.isEmpty() ? null : string, string4, string5, string6);
            this.displaySpamReports(list);
            this.updateStatistics(list);
            String string7 = !string.isEmpty() ? "T\u00ecm th\u1ea5y " + list.size() + " k\u1ebft qu\u1ea3" : "\u0110\u00e3 l\u1ecdc " + list.size() + " b\u00e1o c\u00e1o";
            JOptionPane.showMessageDialog(this, string7, "K\u1ebft qu\u1ea3", 1);
        }
        catch (SQLException sQLException) {
            String string = sQLException.getMessage();
            String string8 = "L\u1ed7i t\u00ecm ki\u1ebfm/l\u1ecdc b\u00e1o c\u00e1o spam: " + string;
            if (string != null && (string.contains("connection") || string.contains("Connection"))) {
                string8 = string8 + "\n\nVui l\u00f2ng ki\u1ec3m tra:\n- K\u1ebft n\u1ed1i database\n- Th\u00f4ng tin b\u1ed9 l\u1ecdc\nHo\u1eb7c li\u00ean h\u1ec7 admin \u0111\u1ec3 \u0111\u01b0\u1ee3c h\u1ed7 tr\u1ee3.";
            }
            this.showError(string8);
            sQLException.printStackTrace();
        }
    }

    private void handleReset() {
        this.searchField.setText("");
        this.searchTypeCombo.setSelectedIndex(0);
        this.timeFilterCombo.setSelectedIndex(0);
        this.statusFilter.setSelectedIndex(0);
        this.sortCombo.setSelectedIndex(0);
        this.loadSpamReportsFromDatabase();
        JOptionPane.showMessageDialog(this, "\u0110\u00e3 \u0111\u1eb7t l\u1ea1i t\u1ea5t c\u1ea3 b\u1ed9 l\u1ecdc!", "Th\u00f4ng b\u00e1o", 1);
    }

    private void updateStatistics(List<SpamReport> list) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        for (SpamReport spamReport : list) {
            String string = spamReport.getStatus();
            if ("pending".equalsIgnoreCase(string)) {
                ++n;
                continue;
            }
            if ("resolved".equalsIgnoreCase(string)) {
                ++n2;
                continue;
            }
            if (!"rejected".equalsIgnoreCase(string)) continue;
            ++n3;
        }
        int n4 = n + n2 + n3;
        if (this.pendingLabel != null) {
            this.pendingLabel.setText("\u23f3 Pending: " + n);
        }
        if (this.resolvedLabel != null) {
            this.resolvedLabel.setText("\u2705 Resolved: " + n2);
        }
        if (this.rejectedLabel != null) {
            this.rejectedLabel.setText("\u274c Rejected: " + n3);
        }
        if (this.totalLabel != null) {
            this.totalLabel.setText("\ud83d\udcca T\u1ed5ng: " + n4);
        }
    }

    private void processReport() {
        int n = this.spamTable.getSelectedRow();
        if (n == -1) {
            JOptionPane.showMessageDialog(this, "Vui l\u00f2ng ch\u1ecdn b\u00e1o c\u00e1o c\u1ea7n x\u1eed l\u00fd!", "C\u1ea3nh b\u00e1o", 2);
            return;
        }
        int n2 = (Integer)this.spamTable.getValueAt(n, 0);
        String string = this.spamTable.getValueAt(n, 2).toString();
        int n3 = this.showStyledConfirmDialog(this, "X\u00e1c nh\u1eadn x\u1eed l\u00fd b\u00e1o c\u00e1o spam cho ng\u01b0\u1eddi d\u00f9ng: " + string + "?", "X\u00e1c nh\u1eadn x\u1eed l\u00fd");
        if (n3 == 0) {
            try {
                boolean bl = this.spamReportDAO.updateReportStatus(n2, "resolved");
                if (bl) {
                    this.spamTable.setValueAt("resolved", n, 4);
                    this.loadSpamReportsFromDatabase();
                    JOptionPane.showMessageDialog(this, "\u0110\u00e3 x\u1eed l\u00fd b\u00e1o c\u00e1o th\u00e0nh c\u00f4ng!", "Th\u00e0nh c\u00f4ng", 1);
                } else {
                    JOptionPane.showMessageDialog(this, "Kh\u00f4ng th\u1ec3 c\u1eadp nh\u1eadt tr\u1ea1ng th\u00e1i b\u00e1o c\u00e1o trong database!", "L\u1ed7i", 0);
                }
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
                JOptionPane.showMessageDialog(this, "L\u1ed7i database: " + sQLException.getMessage(), "L\u1ed7i", 0);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                JOptionPane.showMessageDialog(this, "L\u1ed7i: " + exception.getMessage(), "L\u1ed7i", 0);
            }
        }
    }

    private void lockUserAccount() {
        int n = this.spamTable.getSelectedRow();
        if (n == -1) {
            JOptionPane.showMessageDialog(this, "Vui l\u00f2ng ch\u1ecdn b\u00e1o c\u00e1o!", "C\u1ea3nh b\u00e1o", 2);
            return;
        }
        String string = this.spamTable.getValueAt(n, 2).toString();
        String string2 = this.spamTable.getValueAt(n, 3).toString();
        JDialog jDialog = new JDialog((Frame)SwingUtilities.getWindowAncestor(this), "Kh\u00f3a t\u00e0i kho\u1ea3n - " + string, true);
        jDialog.setLayout(new BorderLayout(10, 10));
        jDialog.setSize(450, 300);
        jDialog.setLocationRelativeTo(this);
        JPanel jPanel = new JPanel(new BorderLayout(10, 10));
        jPanel.setBorder(new EmptyBorder(20, 20, 20, 20));
        JPanel jPanel2 = new JPanel(new GridLayout(3, 1, 5, 10));
        jPanel2.setOpaque(false);
        JLabel jLabel = new JLabel("Ng\u01b0\u1eddi d\u00f9ng: " + string);
        jLabel.setFont(new Font("Arial", 1, 13));
        JLabel jLabel2 = new JLabel("L\u00fd do b\u00e1o c\u00e1o: " + string2);
        jLabel2.setFont(new Font("Arial", 0, 12));
        JLabel jLabel3 = new JLabel("\u26a0\ufe0f C\u1ea3nh b\u00e1o: H\u00e0nh \u0111\u1ed9ng n\u00e0y s\u1ebd kh\u00f3a t\u00e0i kho\u1ea3n ng\u01b0\u1eddi d\u00f9ng!");
        jLabel3.setFont(new Font("Arial", 1, 12));
        jLabel3.setForeground(DANGER_RED);
        jPanel2.add(jLabel);
        jPanel2.add(jLabel2);
        jPanel2.add(jLabel3);
        JPanel jPanel3 = new JPanel(new BorderLayout(5, 5));
        jPanel3.setOpaque(false);
        JLabel jLabel4 = new JLabel("Ghi ch\u00fa l\u00fd do kh\u00f3a:");
        jLabel4.setFont(new Font("Arial", 1, 12));
        JTextArea jTextArea = new JTextArea(3, 30);
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        jTextArea.setBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY));
        jPanel3.add((Component)jLabel4, "North");
        jPanel3.add((Component)new JScrollPane(jTextArea), "Center");
        jPanel.add((Component)jPanel2, "North");
        jPanel.add((Component)jPanel3, "Center");
        JPanel jPanel4 = new JPanel(new FlowLayout(2, 10, 10));
        JButton jButton = this.createStyledButton("Kh\u00f3a t\u00e0i kho\u1ea3n", DANGER_RED);
        JButton jButton2 = this.createStyledButton("H\u1ee7y", NEUTRAL_GRAY);
        jButton.addActionListener(actionEvent -> {
            String string2 = jTextArea.getText().trim();
            if (string2.isEmpty()) {
                JOptionPane.showMessageDialog(jDialog, "Vui l\u00f2ng nh\u1eadp ghi ch\u00fa l\u00fd do kh\u00f3a!", "C\u1ea3nh b\u00e1o", 2);
                return;
            }
            int n2 = this.showStyledConfirmDialog(jDialog, "B\u1ea1n c\u00f3 ch\u1eafc ch\u1eafn mu\u1ed1n kh\u00f3a t\u00e0i kho\u1ea3n " + string + "?", "X\u00e1c nh\u1eadn kh\u00f3a t\u00e0i kho\u1ea3n");
            if (n2 == 0) {
                Object object;
                Connection connection = null;
                try {
                    connection = DatabaseConnection.getInstance().getConnection();
                    connection.setAutoCommit(false);
                    int n3 = (Integer)this.spamTable.getValueAt(n, 0);
                    object = this.reportsMap.get(n3);
                    if (object == null) {
                        JOptionPane.showMessageDialog(jDialog, "Kh\u00f4ng t\u00ecm th\u1ea5y th\u00f4ng tin b\u00e1o c\u00e1o!", "L\u1ed7i", 0);
                        return;
                    }
                    int n4 = ((SpamReport)object).getReportedUserId();
                    String string3 = "UPDATE users SET status = 'locked' WHERE user_id = ?";
                    try (Object object2 = connection.prepareStatement(string3);){
                        object2.setInt(1, n4);
                        int n5 = object2.executeUpdate();
                        if (n5 == 0) {
                            connection.rollback();
                            JOptionPane.showMessageDialog(jDialog, "Kh\u00f4ng th\u1ec3 kh\u00f3a t\u00e0i kho\u1ea3n ng\u01b0\u1eddi d\u00f9ng!\nC\u00f3 th\u1ec3 user kh\u00f4ng t\u1ed3n t\u1ea1i ho\u1eb7c \u0111\u00e3 b\u1ecb kh\u00f3a.", "L\u1ed7i", 0);
                            return;
                        }
                    }
                    object2 = "UPDATE spam_reports SET status = 'resolved' WHERE report_id = ?";
                    try (PreparedStatement preparedStatement = connection.prepareStatement((String)object2);){
                        preparedStatement.setInt(1, n3);
                        int n6 = preparedStatement.executeUpdate();
                        if (n6 == 0) {
                            connection.rollback();
                            JOptionPane.showMessageDialog(jDialog, "Kh\u00f4ng th\u1ec3 c\u1eadp nh\u1eadt tr\u1ea1ng th\u00e1i b\u00e1o c\u00e1o!", "L\u1ed7i", 0);
                            return;
                        }
                    }
                    connection.commit();
                    this.spamTable.setValueAt("resolved", n, 4);
                    this.loadSpamReportsFromDatabase();
                    JOptionPane.showMessageDialog(jDialog, "\u0110\u00e3 kh\u00f3a t\u00e0i kho\u1ea3n " + string + " th\u00e0nh c\u00f4ng!\nGhi ch\u00fa: " + string2, "Th\u00e0nh c\u00f4ng", 1);
                    jDialog.dispose();
                }
                catch (SQLException sQLException) {
                    if (connection != null) {
                        try {
                            connection.rollback();
                        }
                        catch (SQLException sQLException2) {
                            sQLException2.printStackTrace();
                        }
                    }
                    object = sQLException.getMessage();
                    Object object3 = "L\u1ed7i khi kh\u00f3a t\u00e0i kho\u1ea3n: " + (String)object;
                    object3 = object != null && ((String)object).contains("foreign key") ? "Kh\u00f4ng th\u1ec3 kh\u00f3a t\u00e0i kho\u1ea3n!\n\nL\u00fd do: C\u00f3 d\u1eef li\u1ec7u li\u00ean quan \u0111\u1ebfn ng\u01b0\u1eddi d\u00f9ng n\u00e0y.\nVui l\u00f2ng ki\u1ec3m tra l\u1ea1i ho\u1eb7c li\u00ean h\u1ec7 admin." : (String)object3 + "\n\nVui l\u00f2ng ki\u1ec3m tra:\n- K\u1ebft n\u1ed1i database\n- Quy\u1ec1n truy c\u1eadp\nHo\u1eb7c li\u00ean h\u1ec7 admin \u0111\u1ec3 \u0111\u01b0\u1ee3c h\u1ed7 tr\u1ee3.";
                    JOptionPane.showMessageDialog(jDialog, object3, "L\u1ed7i", 0);
                    sQLException.printStackTrace();
                }
                catch (Exception exception) {
                    if (connection != null) {
                        try {
                            connection.rollback();
                        }
                        catch (SQLException sQLException) {
                            sQLException.printStackTrace();
                        }
                    }
                    JOptionPane.showMessageDialog(jDialog, "L\u1ed7i kh\u00f4ng mong \u0111\u1ee3i: " + exception.getMessage() + "\n\nVui l\u00f2ng li\u00ean h\u1ec7 admin \u0111\u1ec3 \u0111\u01b0\u1ee3c h\u1ed7 tr\u1ee3.", "L\u1ed7i", 0);
                    exception.printStackTrace();
                }
                finally {
                    if (connection != null) {
                        try {
                            connection.setAutoCommit(true);
                            connection.close();
                        }
                        catch (SQLException sQLException) {
                            sQLException.printStackTrace();
                        }
                    }
                }
            }
        });
        jButton2.addActionListener(actionEvent -> jDialog.dispose());
        jPanel4.add(jButton);
        jPanel4.add(jButton2);
        jDialog.add((Component)jPanel, "Center");
        jDialog.add((Component)jPanel4, "South");
        jDialog.setVisible(true);
    }

    private JButton createStyledButton(String string, Color color) {
        JButton jButton = new JButton(string);
        jButton.setFont(new Font("Arial", 1, 12));
        jButton.setBackground(color);
        jButton.setForeground(Color.WHITE);
        jButton.setOpaque(true);
        jButton.setBorderPainted(false);
        jButton.setContentAreaFilled(true);
        return jButton;
    }

    private void showError(String string) {
        JOptionPane.showMessageDialog(this, string, "L\u1ed7i", 0);
    }

    private void addActionToButton(String string, ActionListener actionListener) {
        Component[] componentArray;
        for (Component component : componentArray = this.getAllComponents(this)) {
            JButton jButton;
            if (!(component instanceof JButton) || !(jButton = (JButton)component).getText().equals(string)) continue;
            jButton.addActionListener(actionListener);
            break;
        }
    }

    private Component[] getAllComponents(Container container) {
        Component[] componentArray;
        ArrayList<Component> arrayList = new ArrayList<Component>();
        for (Component component : componentArray = container.getComponents()) {
            Component[] componentArray2;
            arrayList.add(component);
            if (!(component instanceof Container)) continue;
            for (Component component2 : componentArray2 = this.getAllComponents((Container)component)) {
                arrayList.add(component2);
            }
        }
        return arrayList.toArray(new Component[0]);
    }

    private void handleExportCSV() {
        try {
            List<SpamReport> list = this.spamReportDAO.getAllSpamReports();
            if (list.isEmpty()) {
                JOptionPane.showMessageDialog(this, "Kh\u00f4ng c\u00f3 d\u1eef li\u1ec7u \u0111\u1ec3 xu\u1ea5t!", "C\u1ea3nh b\u00e1o", 2);
                return;
            }
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.setDialogTitle("L\u01b0u file CSV");
            jFileChooser.setSelectedFile(new File("BaoCaoSpam.csv"));
            int n = jFileChooser.showSaveDialog(this);
            if (n != 0) {
                return;
            }
            File file = jFileChooser.getSelectedFile();
            Object object = file.getAbsolutePath();
            if (!((String)object).toLowerCase().endsWith(".csv")) {
                object = (String)object + ".csv";
            }
            try (PrintWriter printWriter = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream((String)object), StandardCharsets.UTF_8));){
                printWriter.write(65279);
                printWriter.println("ID,Ng\u01b0\u1eddi b\u00e1o c\u00e1o,Ng\u01b0\u1eddi b\u1ecb b\u00e1o c\u00e1o,L\u00fd do,Tr\u1ea1ng th\u00e1i,Ng\u00e0y b\u00e1o c\u00e1o");
                for (SpamReport spamReport : list) {
                    String string = String.format("%d,\"%s\",\"%s\",\"%s\",\"%s\",\"%s\"", spamReport.getId(), this.escapeCsv(spamReport.getReporterName()), this.escapeCsv(spamReport.getReportedUserName()), this.escapeCsv(spamReport.getReason()), this.escapeCsv(spamReport.getStatus()), spamReport.getCreatedAt() != null ? spamReport.getCreatedAt().format(this.dateTimeFormatter) : "");
                    printWriter.println(string);
                }
            }
            JOptionPane.showMessageDialog(this, "\u0110\u00e3 xu\u1ea5t " + list.size() + " b\u00e1o c\u00e1o v\u00e0o file:\n" + (String)object, "Th\u00e0nh c\u00f4ng", 1);
        }
        catch (Exception exception) {
            this.showError("L\u1ed7i xu\u1ea5t file: " + exception.getMessage());
            exception.printStackTrace();
        }
    }

    private String escapeCsv(String string) {
        if (string == null) {
            return "";
        }
        return string.replace("\"", "\"\"");
    }

    private int showStyledConfirmDialog(Component component, Object object, String string) {
        JComponent jComponent;
        JDialog jDialog = new JDialog((Frame)SwingUtilities.getWindowAncestor(component), string, true);
        jDialog.setLayout(new BorderLayout(10, 10));
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(20, 20, 10, 20));
        if (object instanceof Component) {
            jPanel.add((Component)object, "Center");
        } else {
            jComponent = new JLabel("<html>" + object.toString() + "</html>");
            jComponent.setFont(new Font("Arial", 0, 14));
            jPanel.add((Component)jComponent, "Center");
        }
        jComponent = new JPanel(new FlowLayout(1, 10, 10));
        jComponent.setBorder(BorderFactory.createEmptyBorder(10, 20, 20, 20));
        int[] nArray = new int[]{-1};
        JButton jButton = new JButton("C\u00f3");
        jButton.setBackground(new Color(40, 167, 69));
        jButton.setForeground(Color.WHITE);
        jButton.setFont(new Font("Arial", 1, 12));
        jButton.setOpaque(true);
        jButton.setBorderPainted(false);
        jButton.setFocusPainted(false);
        jButton.setPreferredSize(new Dimension(80, 35));
        jButton.setCursor(new Cursor(12));
        jButton.addActionListener(actionEvent -> {
            nArray[0] = 0;
            jDialog.dispose();
        });
        JButton jButton2 = new JButton("H\u1ee7y");
        jButton2.setBackground(new Color(220, 53, 69));
        jButton2.setForeground(Color.WHITE);
        jButton2.setFont(new Font("Arial", 1, 12));
        jButton2.setOpaque(true);
        jButton2.setBorderPainted(false);
        jButton2.setFocusPainted(false);
        jButton2.setPreferredSize(new Dimension(80, 35));
        jButton2.setCursor(new Cursor(12));
        jButton2.addActionListener(actionEvent -> {
            nArray[0] = 1;
            jDialog.dispose();
        });
        jComponent.add(jButton);
        jComponent.add(jButton2);
        jDialog.add((Component)jPanel, "Center");
        jDialog.add((Component)jComponent, "South");
        jDialog.setDefaultCloseOperation(2);
        jDialog.pack();
        jDialog.setLocationRelativeTo(component);
        jDialog.setVisible(true);
        return nArray[0];
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Deprecated
    private boolean lockUser(int n, String string) {
        String string2 = "UPDATE users SET status = 'locked' WHERE user_id = ?";
        try (Connection connection = DatabaseConnection.getInstance().getConnection();){
            boolean bl;
            block14: {
                PreparedStatement preparedStatement = connection.prepareStatement(string2);
                try {
                    preparedStatement.setInt(1, n);
                    int n2 = preparedStatement.executeUpdate();
                    boolean bl2 = bl = n2 > 0;
                    if (preparedStatement == null) break block14;
                }
                catch (Throwable throwable) {
                    if (preparedStatement != null) {
                        try {
                            preparedStatement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                preparedStatement.close();
            }
            return bl;
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
            return false;
        }
    }

    private ImageIcon loadIcon(String string, int n, int n2) {
        try {
            String string2 = "icons/" + string + ".png";
            ImageIcon imageIcon = new ImageIcon(string2);
            if (imageIcon.getImageLoadStatus() == 8) {
                Image image = imageIcon.getImage().getScaledInstance(n, n2, 4);
                return new ImageIcon(image);
            }
        }
        catch (Exception exception) {
            System.err.println("Could not load icon: " + string);
        }
        return null;
    }

    private JButton createStyledButtonWithIcon(String string, Color color, String string2) {
        JButton jButton = new JButton(string);
        ImageIcon imageIcon = this.loadIcon(string2, 16, 16);
        if (imageIcon != null) {
            jButton.setIcon(imageIcon);
            jButton.setHorizontalTextPosition(4);
            jButton.setIconTextGap(8);
        }
        jButton.setFont(new Font("Arial", 1, 12));
        jButton.setBackground(color);
        jButton.setForeground(Color.WHITE);
        jButton.setOpaque(true);
        jButton.setBorderPainted(false);
        jButton.setFocusPainted(false);
        jButton.setCursor(new Cursor(12));
        jButton.setPreferredSize(new Dimension(200, 35));
        return jButton;
    }

    private void exportSpamReportsToCSV() {
        try {
            if (this.spamTable.getRowCount() == 0) {
                JOptionPane.showMessageDialog(this, "Kh\u00f4ng c\u00f3 d\u1eef li\u1ec7u \u0111\u1ec3 xu\u1ea5t!", "C\u1ea3nh b\u00e1o", 2);
                return;
            }
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.setDialogTitle("L\u01b0u file CSV");
            jFileChooser.setSelectedFile(new File("BaoCaoSpam.csv"));
            if (jFileChooser.showSaveDialog(this) != 0) {
                return;
            }
            Object object = jFileChooser.getSelectedFile().getAbsolutePath();
            if (!((String)object).toLowerCase().endsWith(".csv")) {
                object = (String)object + ".csv";
            }
            try (PrintWriter printWriter = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream((String)object), StandardCharsets.UTF_8));){
                printWriter.write(65279);
                printWriter.println("ID,Ng\u01b0\u1eddi b\u00e1o c\u00e1o,Ng\u01b0\u1eddi b\u1ecb b\u00e1o c\u00e1o,L\u00fd do,Tr\u1ea1ng th\u00e1i,Ng\u00e0y b\u00e1o c\u00e1o");
                for (int i = 0; i < this.spamTable.getRowCount(); ++i) {
                    printWriter.printf("%s,\"%s\",\"%s\",\"%s\",\"%s\",\"%s\"\n", this.spamTable.getValueAt(i, 0), this.spamTable.getValueAt(i, 1), this.spamTable.getValueAt(i, 2), this.spamTable.getValueAt(i, 3), this.spamTable.getValueAt(i, 4), this.spamTable.getValueAt(i, 5));
                }
            }
            JOptionPane.showMessageDialog(this, "\u0110\u00e3 xu\u1ea5t " + this.spamTable.getRowCount() + " b\u00e1o c\u00e1o v\u00e0o:\n" + (String)object, "Th\u00e0nh c\u00f4ng", 1);
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this, "L\u1ed7i xu\u1ea5t file: " + exception.getMessage(), "L\u1ed7i", 0);
            exception.printStackTrace();
        }
    }
}

