/*
 * Decompiled with CFR 0.152.
 */
package admin.gui;

import admin.service.LoginHistoryDAO;
import admin.service.StatisticsDAO;
import admin.service.UserDAO;
import admin.socket.LoginHistory;
import admin.socket.User;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.sql.SQLException;
import java.text.Collator;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumnModel;

public class UserManagementPanel
extends JPanel {
    private static final Color ZALO_BLUE = new Color(0, 102, 255);
    private static final Color SUCCESS_GREEN = new Color(40, 167, 69);
    private static final Color DANGER_RED = new Color(220, 53, 69);
    private static final Color INFO_CYAN = new Color(23, 162, 184);
    private JTable userTable;
    private DefaultTableModel tableModel;
    private JTextField searchField;
    private JComboBox<String> statusFilter;
    private JComboBox<String> sortCombo;
    private JComboBox<String> searchTypeCombo;
    private UserDAO userDAO;
    private LoginHistoryDAO loginHistoryDAO;
    private StatisticsDAO statisticsDAO;
    private List<User> currentUsers = new ArrayList<User>();
    private String lastSortOption;
    private DateTimeFormatter dateFormatter = DateTimeFormatter.ofPattern("dd/MM/yyyy");
    private DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("dd/MM/yyyy HH:mm");

    public UserManagementPanel() {
        try {
            this.userDAO = new UserDAO();
            this.loginHistoryDAO = new LoginHistoryDAO();
            this.statisticsDAO = new StatisticsDAO();
            this.initComponents();
            this.setupLayout();
            this.lastSortOption = (String)this.sortCombo.getSelectedItem();
            this.loadUsersFromDatabase();
            this.setupEventHandlers();
        }
        catch (Exception exception) {
            this.showError("L\u1ed7i kh\u1edfi t\u1ea1o: " + exception.getMessage());
            exception.printStackTrace();
        }
    }

    private void initComponents() {
        Object[] objectArray = new String[]{"ID", "T\u00ean \u0111\u0103ng nh\u1eadp", "H\u1ecd t\u00ean", "\u0110\u1ecba ch\u1ec9", "Ng\u00e0y sinh", "Gi\u1edbi t\u00ednh", "Email", "Tr\u1ea1ng th\u00e1i", "Ng\u00e0y t\u1ea1o"};
        this.tableModel = new DefaultTableModel(objectArray, 0){

            @Override
            public boolean isCellEditable(int n, int n2) {
                return false;
            }
        };
        this.userTable = new JTable(this.tableModel);
        this.userTable.setRowHeight(25);
        this.userTable.setAutoCreateRowSorter(true);
        this.userTable.getTableHeader().setFont(new Font("Arial", 1, 13));
        this.userTable.getTableHeader().setBackground(Color.WHITE);
        this.userTable.getTableHeader().setForeground(Color.BLACK);
        this.searchField = new JTextField(20);
        this.searchTypeCombo = new JComboBox<String>(new String[]{"T\u00ecm theo t\u00ean", "T\u00ecm theo t\u00ean \u0111\u0103ng nh\u1eadp", "T\u00ecm theo email"});
        this.statusFilter = new JComboBox<String>(new String[]{"T\u1ea5t c\u1ea3", "Ho\u1ea1t \u0111\u1ed9ng", "B\u1ecb kh\u00f3a", "\u0110\u00e3 x\u00f3a"});
        this.sortCombo = new JComboBox<String>(new String[]{"S\u1eafp x\u1ebfp theo t\u00ean (A-Z)", "S\u1eafp x\u1ebfp theo t\u00ean (Z-A)", "S\u1eafp x\u1ebfp theo ng\u00e0y t\u1ea1o (M\u1edbi nh\u1ea5t)", "S\u1eafp x\u1ebfp theo ng\u00e0y t\u1ea1o (C\u0169 nh\u1ea5t)"});
        TableColumnModel tableColumnModel = this.userTable.getColumnModel();
        tableColumnModel.getColumn(0).setPreferredWidth(40);
        tableColumnModel.getColumn(1).setPreferredWidth(100);
        tableColumnModel.getColumn(2).setPreferredWidth(120);
        tableColumnModel.getColumn(3).setPreferredWidth(150);
        tableColumnModel.getColumn(4).setPreferredWidth(80);
        tableColumnModel.getColumn(5).setPreferredWidth(60);
        tableColumnModel.getColumn(6).setPreferredWidth(150);
        tableColumnModel.getColumn(7).setPreferredWidth(80);
        tableColumnModel.getColumn(8).setPreferredWidth(90);
    }

    private void loadUsersFromDatabase() {
        try {
            List<User> list = this.userDAO.getAllUsers();
            this.sortUsers(list, this.lastSortOption);
            this.currentUsers = list;
            this.displayUsers(this.currentUsers);
        }
        catch (SQLException sQLException) {
            String string = sQLException.getMessage();
            String string2 = "L\u1ed7i load d\u1eef li\u1ec7u: " + string;
            if (string != null && (string.contains("ch\u01b0a \u0111\u01b0\u1ee3c c\u1ea5u h\u00ecnh") || string.contains("YOUR_") || string.contains("configuration"))) {
                string2 = string2 + "\n\n\u26a0\ufe0f Database ch\u01b0a \u0111\u01b0\u1ee3c c\u1ea5u h\u00ecnh!\n\nC\u00e1ch s\u1eeda:\n1. Ch\u1ea1y: ./configure_db.sh\n2. Ho\u1eb7c s\u1eeda file: release/config.properties\n3. Thay YOUR_PROJECT_REF v\u00e0 YOUR_PASSWORD_HERE\n   b\u1eb1ng th\u00f4ng tin Supabase th\u1ef1c t\u1ebf";
            }
            this.showError(string2);
            sQLException.printStackTrace();
        }
    }

    private void displayUsers(List<User> list) {
        this.currentUsers = new ArrayList<User>(list);
        this.tableModel.setRowCount(0);
        for (User user : this.currentUsers) {
            Object[] objectArray = new Object[]{user.getId(), user.getUsername(), user.getFullName(), user.getAddress() != null ? user.getAddress() : "", user.getBirthDate() != null ? user.getBirthDate().format(this.dateFormatter) : "", user.getGender() != null ? user.getGender() : "", user.getEmail(), this.formatStatus(user.getStatus()), user.getCreatedAt() != null ? user.getCreatedAt().format(this.dateTimeFormatter) : ""};
            this.tableModel.addRow(objectArray);
        }
    }

    private void setupLayout() {
        this.setLayout(new BorderLayout(10, 10));
        this.setBorder(new EmptyBorder(15, 15, 15, 15));
        this.setBackground(new Color(248, 249, 250));
        JPanel jPanel = this.createSearchPanel();
        this.add((Component)jPanel, "North");
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.setBackground(Color.WHITE);
        jPanel2.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY), new EmptyBorder(10, 10, 10, 10)));
        ImageIcon imageIcon = this.loadIcon("user", 20, 20);
        JLabel jLabel = new JLabel("Danh s\u00e1ch ng\u01b0\u1eddi d\u00f9ng");
        if (imageIcon != null) {
            jLabel.setIcon(imageIcon);
            jLabel.setHorizontalTextPosition(4);
            jLabel.setIconTextGap(8);
        }
        jLabel.setFont(new Font("Arial", 1, 14));
        jLabel.setForeground(ZALO_BLUE);
        jLabel.setBorder(new EmptyBorder(0, 0, 10, 0));
        jPanel2.add((Component)jLabel, "North");
        jPanel2.add((Component)new JScrollPane(this.userTable), "Center");
        this.add((Component)jPanel2, "Center");
        JPanel jPanel3 = this.createButtonPanel();
        this.add((Component)jPanel3, "South");
    }

    private JPanel createSearchPanel() {
        JPanel jPanel = new JPanel(new BorderLayout(10, 10));
        jPanel.setBackground(Color.WHITE);
        jPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY), new EmptyBorder(15, 15, 15, 15)));
        ImageIcon imageIcon = this.loadIcon("search", 20, 20);
        JLabel jLabel = new JLabel("T\u00ecm ki\u1ebfm & L\u1ecdc ng\u01b0\u1eddi d\u00f9ng");
        if (imageIcon != null) {
            jLabel.setIcon(imageIcon);
            jLabel.setHorizontalTextPosition(4);
            jLabel.setIconTextGap(8);
        }
        jLabel.setFont(new Font("Arial", 1, 14));
        jLabel.setForeground(ZALO_BLUE);
        JPanel jPanel2 = new JPanel(new FlowLayout(0, 10, 5));
        jPanel2.setOpaque(false);
        jPanel2.add(new JLabel("Lo\u1ea1i t\u00ecm ki\u1ebfm:"));
        jPanel2.add(this.searchTypeCombo);
        jPanel2.add(new JLabel("T\u1eeb kh\u00f3a:"));
        jPanel2.add(this.searchField);
        JPanel jPanel3 = new JPanel(new FlowLayout(0, 10, 5));
        jPanel3.setOpaque(false);
        jPanel3.add(new JLabel("Tr\u1ea1ng th\u00e1i:"));
        jPanel3.add(this.statusFilter);
        jPanel3.add(new JLabel("S\u1eafp x\u1ebfp:"));
        jPanel3.add(this.sortCombo);
        jPanel3.add(this.createStyledButton("\ud83d\udd0d T\u00ecm ki\u1ebfm + L\u1ecdc", ZALO_BLUE));
        jPanel3.add(this.createStyledButton("\u21ba \u0110\u1eb7t l\u1ea1i", ZALO_BLUE));
        JPanel jPanel4 = new JPanel(new BorderLayout(5, 5));
        jPanel4.setOpaque(false);
        jPanel4.add((Component)jPanel2, "North");
        jPanel4.add((Component)jPanel3, "Center");
        jPanel.add((Component)jLabel, "North");
        jPanel.add((Component)jPanel4, "Center");
        return jPanel;
    }

    private JPanel createButtonPanel() {
        JPanel jPanel = new JPanel(new BorderLayout(10, 10));
        jPanel.setOpaque(false);
        jPanel.setBorder(new EmptyBorder(10, 0, 0, 0));
        JPanel jPanel2 = new JPanel(new GridLayout(2, 1, 0, 10));
        jPanel2.setOpaque(false);
        JPanel jPanel3 = new JPanel(new FlowLayout(1, 15, 5));
        jPanel3.setOpaque(false);
        JButton jButton = this.createButtonWithIcon("Th\u00eam ng\u01b0\u1eddi d\u00f9ng", "add.png", INFO_CYAN);
        jButton.addActionListener(actionEvent -> this.showAddUserDialog());
        JButton jButton2 = this.createButtonWithIcon("S\u1eeda th\u00f4ng tin", "edit.png", INFO_CYAN);
        jButton2.addActionListener(actionEvent -> this.showEditUserDialog());
        JButton jButton3 = this.createButtonWithIcon("X\u00f3a ng\u01b0\u1eddi d\u00f9ng", "delete.png", INFO_CYAN);
        jButton3.addActionListener(actionEvent -> this.showDeleteUserDialog());
        JButton jButton4 = this.createButtonWithIcon("Kh\u00f3a t\u00e0i kho\u1ea3n", "lock.png", INFO_CYAN);
        jButton4.addActionListener(actionEvent -> this.showLockAccountDialog());
        JButton jButton5 = this.createButtonWithIcon("M\u1edf kh\u00f3a", "unlock.png", INFO_CYAN);
        jButton5.addActionListener(actionEvent -> this.showUnlockAccountDialog());
        jPanel3.add(jButton);
        jPanel3.add(jButton2);
        jPanel3.add(jButton3);
        jPanel3.add(jButton4);
        jPanel3.add(jButton5);
        JPanel jPanel4 = new JPanel(new FlowLayout(1, 15, 5));
        jPanel4.setOpaque(false);
        JButton jButton6 = this.createButtonWithIcon("\u0110\u1ed5i m\u1eadt kh\u1ea9u", "password.png", INFO_CYAN);
        jButton6.addActionListener(actionEvent -> this.showChangePasswordDialog());
        JButton jButton7 = this.createButtonWithIcon("Reset m\u1eadt kh\u1ea9u", "reset.png", INFO_CYAN);
        jButton7.addActionListener(actionEvent -> this.showResetPasswordDialog());
        JButton jButton8 = this.createButtonWithIcon("L\u1ecbch s\u1eed", "history.png", INFO_CYAN);
        jButton8.addActionListener(actionEvent -> this.showLoginHistoryDialog());
        JButton jButton9 = this.createButtonWithIcon("Danh s\u00e1ch b\u1ea1n", "contact.png", INFO_CYAN);
        jButton9.addActionListener(actionEvent -> this.showFriendsListDialog());
        JButton jButton10 = this.createButtonWithIcon("Xu\u1ea5t CSV", "export.png", INFO_CYAN);
        jButton10.addActionListener(actionEvent -> this.exportUsersToCSV());
        jPanel4.add(jButton6);
        jPanel4.add(jButton7);
        jPanel4.add(jButton8);
        jPanel4.add(jButton9);
        jPanel4.add(jButton10);
        jPanel2.add(jPanel3);
        jPanel2.add(jPanel4);
        jPanel.add((Component)jPanel2, "Center");
        return jPanel;
    }

    private void setupEventHandlers() {
        this.addActionToButton("\u2795 Th\u00eam ng\u01b0\u1eddi d\u00f9ng", actionEvent -> this.showAddUserDialog());
        this.addActionToButton("\u270f\ufe0f S\u1eeda th\u00f4ng tin", actionEvent -> this.showEditUserDialog());
        this.addActionToButton("\ud83d\uddd1\ufe0f X\u00f3a ng\u01b0\u1eddi d\u00f9ng", actionEvent -> this.showDeleteUserDialog());
        this.addActionToButton("\ud83d\udd12 Kh\u00f3a t\u00e0i kho\u1ea3n", actionEvent -> this.showLockAccountDialog());
        this.addActionToButton("\ud83d\udd13 M\u1edf kh\u00f3a", actionEvent -> this.showUnlockAccountDialog());
        this.addActionToButton("\ud83d\udd11 \u0110\u1ed5i m\u1eadt kh\u1ea9u", actionEvent -> this.showChangePasswordDialog());
        this.addActionToButton("\ud83d\udd04 Reset m\u1eadt kh\u1ea9u", actionEvent -> this.showResetPasswordDialog());
        this.addActionToButton("\ud83d\udcdc L\u1ecbch s\u1eed \u0111\u0103ng nh\u1eadp", actionEvent -> this.showLoginHistoryDialog());
        this.addActionToButton("\ud83d\udc65 Danh s\u00e1ch b\u1ea1n b\u00e8", actionEvent -> this.showFriendsListDialog());
        this.addActionToButton("\ud83d\udcca Xu\u1ea5t CSV", actionEvent -> this.handleExportCSV());
        this.addActionToButton("\ud83d\udd0d T\u00ecm ki\u1ebfm + L\u1ecdc", actionEvent -> this.applyAllFilters(false));
        this.addActionToButton("\u21ba \u0110\u1eb7t l\u1ea1i", actionEvent -> this.handleReset());
    }

    private void showAddUserDialog() {
        JComponent jComponent;
        JDialog jDialog = new JDialog((Frame)SwingUtilities.getWindowAncestor(this), "Th\u00eam ng\u01b0\u1eddi d\u00f9ng m\u1edbi", true);
        jDialog.setLayout(new BorderLayout(10, 10));
        jDialog.setSize(500, 600);
        jDialog.setLocationRelativeTo(this);
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(new EmptyBorder(20, 20, 20, 20));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(8, 8, 8, 8);
        gridBagConstraints.fill = 2;
        String[] stringArray = new String[]{"T\u00ean \u0111\u0103ng nh\u1eadp:", "M\u1eadt kh\u1ea9u:", "H\u1ecd t\u00ean:", "\u0110\u1ecba ch\u1ec9:", "Ng\u00e0y sinh:", "Gi\u1edbi t\u00ednh:", "Email:"};
        final JTextField jTextField = new JTextField(20);
        jTextField.setForeground(Color.GRAY);
        jTextField.setText("dd/MM/yyyy");
        jTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                if (jTextField.getText().equals("dd/MM/yyyy")) {
                    jTextField.setText("");
                    jTextField.setForeground(Color.BLACK);
                }
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                if (jTextField.getText().isEmpty()) {
                    jTextField.setForeground(Color.GRAY);
                    jTextField.setText("dd/MM/yyyy");
                }
            }
        });
        JComponent[] jComponentArray = new JComponent[]{new JTextField(20), new JPasswordField(20), new JTextField(20), new JTextField(20), jTextField, new JComboBox<String>(new String[]{"Nam", "N\u1eef", "Kh\u00e1c"}), new JTextField(20)};
        for (int i = 0; i < stringArray.length; ++i) {
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = i;
            gridBagConstraints.weightx = 0.0;
            jComponent = new JLabel(stringArray[i]);
            jComponent.setFont(new Font("Arial", 1, 12));
            jPanel.add((Component)jComponent, gridBagConstraints);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.weightx = 1.0;
            jPanel.add((Component)jComponentArray[i], gridBagConstraints);
        }
        JPanel jPanel2 = new JPanel(new FlowLayout(2, 10, 10));
        jComponent = this.createStyledButton("\ud83d\udcbe L\u01b0u", SUCCESS_GREEN);
        JButton jButton = this.createStyledButton("\u274c H\u1ee7y", DANGER_RED);
        ((AbstractButton)jComponent).addActionListener(actionEvent -> {
            try {
                String string = ((JTextField)jComponentArray[0]).getText().trim();
                String string2 = new String(((JPasswordField)jComponentArray[1]).getPassword());
                String string3 = ((JTextField)jComponentArray[2]).getText().trim();
                String string4 = ((JTextField)jComponentArray[3]).getText().trim();
                String string5 = ((JTextField)jComponentArray[4]).getText().trim();
                if (string5.equals("dd/MM/yyyy")) {
                    string5 = "";
                }
                String string6 = (String)((JComboBox)jComponentArray[5]).getSelectedItem();
                String string7 = ((JTextField)jComponentArray[6]).getText().trim();
                if (string.isEmpty()) {
                    this.showWarning("T\u00ean \u0111\u0103ng nh\u1eadp kh\u00f4ng \u0111\u01b0\u1ee3c \u0111\u1ec3 tr\u1ed1ng!");
                    return;
                }
                if (string.length() < 3 || string.length() > 50) {
                    this.showWarning("T\u00ean \u0111\u0103ng nh\u1eadp ph\u1ea3i t\u1eeb 3 \u0111\u1ebfn 50 k\u00fd t\u1ef1!");
                    return;
                }
                if (!string.matches("^[a-zA-Z0-9_]+$")) {
                    this.showWarning("T\u00ean \u0111\u0103ng nh\u1eadp ch\u1ec9 \u0111\u01b0\u1ee3c ch\u1ee9a ch\u1eef c\u00e1i, s\u1ed1 v\u00e0 d\u1ea5u g\u1ea1ch d\u01b0\u1edbi!");
                    return;
                }
                try {
                    if (this.userDAO.usernameExists(string)) {
                        this.showWarning("T\u00ean \u0111\u0103ng nh\u1eadp \u0111\u00e3 t\u1ed3n t\u1ea1i! Vui l\u00f2ng ch\u1ecdn t\u00ean kh\u00e1c.");
                        return;
                    }
                }
                catch (SQLException sQLException) {
                    this.showError("L\u1ed7i ki\u1ec3m tra t\u00ean \u0111\u0103ng nh\u1eadp: " + sQLException.getMessage());
                    return;
                }
                if (string2.isEmpty()) {
                    this.showWarning("M\u1eadt kh\u1ea9u kh\u00f4ng \u0111\u01b0\u1ee3c \u0111\u1ec3 tr\u1ed1ng!");
                    return;
                }
                if (string2.length() < 6) {
                    this.showWarning("M\u1eadt kh\u1ea9u ph\u1ea3i c\u00f3 \u00edt nh\u1ea5t 6 k\u00fd t\u1ef1!");
                    return;
                }
                if (string3.isEmpty()) {
                    this.showWarning("H\u1ecd t\u00ean kh\u00f4ng \u0111\u01b0\u1ee3c \u0111\u1ec3 tr\u1ed1ng!");
                    return;
                }
                if (string3.length() > 100) {
                    this.showWarning("H\u1ecd t\u00ean kh\u00f4ng \u0111\u01b0\u1ee3c v\u01b0\u1ee3t qu\u00e1 100 k\u00fd t\u1ef1!");
                    return;
                }
                if (string7.isEmpty()) {
                    this.showWarning("Email kh\u00f4ng \u0111\u01b0\u1ee3c \u0111\u1ec3 tr\u1ed1ng!");
                    return;
                }
                if (string7.length() > 255) {
                    this.showWarning("Email kh\u00f4ng \u0111\u01b0\u1ee3c v\u01b0\u1ee3t qu\u00e1 255 k\u00fd t\u1ef1!");
                    return;
                }
                if (!string7.matches("^[A-Za-z0-9+_.-]+@(.+)$")) {
                    this.showWarning("Email kh\u00f4ng \u0111\u00fang \u0111\u1ecbnh d\u1ea1ng!\nV\u00ed d\u1ee5: user@example.com");
                    return;
                }
                try {
                    if (this.userDAO.emailExists(string7)) {
                        this.showWarning("Email \u0111\u00e3 t\u1ed3n t\u1ea1i! Vui l\u00f2ng s\u1eed d\u1ee5ng email kh\u00e1c.");
                        return;
                    }
                }
                catch (SQLException sQLException) {
                    this.showError("L\u1ed7i ki\u1ec3m tra email: " + sQLException.getMessage());
                    return;
                }
                LocalDate localDate = null;
                if (!string5.isEmpty()) {
                    try {
                        localDate = LocalDate.parse(string5, this.dateFormatter);
                        if (localDate.isAfter(LocalDate.now())) {
                            this.showWarning("Ng\u00e0y sinh kh\u00f4ng \u0111\u01b0\u1ee3c \u1edf t\u01b0\u01a1ng lai!");
                            return;
                        }
                        int n = LocalDate.now().getYear() - localDate.getYear();
                        if (n < 1 || n > 150) {
                            this.showWarning("Ng\u00e0y sinh kh\u00f4ng h\u1ee3p l\u1ec7! Tu\u1ed5i ph\u1ea3i t\u1eeb 1 \u0111\u1ebfn 150.");
                            return;
                        }
                    }
                    catch (DateTimeParseException dateTimeParseException) {
                        this.showWarning("Ng\u00e0y sinh kh\u00f4ng \u0111\u00fang \u0111\u1ecbnh d\u1ea1ng!\nVui l\u00f2ng nh\u1eadp theo \u0111\u1ecbnh d\u1ea1ng: dd/MM/yyyy\nV\u00ed d\u1ee5: 15/03/1990");
                        return;
                    }
                }
                User user = new User();
                user.setUsername(string);
                user.setPassword(string2);
                user.setFullName(string3);
                user.setAddress(string4.isEmpty() ? null : string4);
                user.setBirthDate(localDate);
                user.setGender(string6);
                user.setEmail(string7);
                user.setStatus("active");
                user.setCreatedAt(LocalDateTime.now());
                boolean bl = this.userDAO.addUser(user);
                if (bl) {
                    this.showSuccess("Th\u00eam ng\u01b0\u1eddi d\u00f9ng th\u00e0nh c\u00f4ng!");
                    this.loadUsersFromDatabase();
                    jDialog.dispose();
                } else {
                    this.showError("Kh\u00f4ng th\u1ec3 th\u00eam ng\u01b0\u1eddi d\u00f9ng!\n\nC\u00f3 th\u1ec3 do:\n- L\u1ed7i k\u1ebft n\u1ed1i database\n- D\u1eef li\u1ec7u kh\u00f4ng h\u1ee3p l\u1ec7\nVui l\u00f2ng th\u1eed l\u1ea1i ho\u1eb7c li\u00ean h\u1ec7 admin.");
                }
            }
            catch (SQLException sQLException) {
                String string = sQLException.getMessage();
                Object object = "L\u1ed7i khi th\u00eam ng\u01b0\u1eddi d\u00f9ng: " + string;
                object = string != null && (string.contains("duplicate") || string.contains("unique") || string.contains("UNIQUE")) ? "T\u00ean \u0111\u0103ng nh\u1eadp ho\u1eb7c email \u0111\u00e3 t\u1ed3n t\u1ea1i!\nVui l\u00f2ng ch\u1ecdn t\u00ean \u0111\u0103ng nh\u1eadp ho\u1eb7c email kh\u00e1c." : (String)object + "\n\nVui l\u00f2ng ki\u1ec3m tra:\n- K\u1ebft n\u1ed1i database\n- Th\u00f4ng tin nh\u1eadp v\u00e0o\nHo\u1eb7c li\u00ean h\u1ec7 admin \u0111\u1ec3 \u0111\u01b0\u1ee3c h\u1ed7 tr\u1ee3.";
                this.showError((String)object);
                sQLException.printStackTrace();
            }
        });
        jButton.addActionListener(actionEvent -> jDialog.dispose());
        jPanel2.add(jComponent);
        jPanel2.add(jButton);
        jDialog.add((Component)new JScrollPane(jPanel), "Center");
        jDialog.add((Component)jPanel2, "South");
        jDialog.setVisible(true);
    }

    private void showEditUserDialog() {
        int n = this.userTable.getSelectedRow();
        if (n == -1) {
            this.showWarning("Vui l\u00f2ng ch\u1ecdn ng\u01b0\u1eddi d\u00f9ng c\u1ea7n s\u1eeda!");
            return;
        }
        int n2 = (Integer)this.userTable.getValueAt(n, 0);
        try {
            JComponent jComponent;
            User user = this.userDAO.getUserById(n2);
            if (user == null) {
                this.showError("Kh\u00f4ng t\u00ecm th\u1ea5y ng\u01b0\u1eddi d\u00f9ng!");
                return;
            }
            JDialog jDialog = new JDialog((Frame)SwingUtilities.getWindowAncestor(this), "S\u1eeda th\u00f4ng tin: " + user.getUsername(), true);
            jDialog.setLayout(new BorderLayout(10, 10));
            jDialog.setSize(500, 600);
            jDialog.setLocationRelativeTo(this);
            JPanel jPanel = new JPanel(new GridBagLayout());
            jPanel.setBorder(new EmptyBorder(20, 20, 20, 20));
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.insets = new Insets(8, 8, 8, 8);
            gridBagConstraints.fill = 2;
            String[] stringArray = new String[]{"T\u00ean \u0111\u0103ng nh\u1eadp:", "H\u1ecd t\u00ean:", "\u0110\u1ecba ch\u1ec9:", "Ng\u00e0y sinh:", "Gi\u1edbi t\u00ednh:", "Email:"};
            JTextField jTextField = new JTextField(user.getUsername(), 20);
            jTextField.setEnabled(false);
            jTextField.setBackground(Color.LIGHT_GRAY);
            JTextField jTextField2 = new JTextField(user.getFullName(), 20);
            JTextField jTextField3 = new JTextField(user.getAddress() != null ? user.getAddress() : "", 20);
            final JTextField jTextField4 = new JTextField(20);
            if (user.getBirthDate() != null) {
                jTextField4.setText(user.getBirthDate().format(this.dateFormatter));
                jTextField4.setForeground(Color.BLACK);
            } else {
                jTextField4.setText("dd/MM/yyyy");
                jTextField4.setForeground(Color.GRAY);
            }
            jTextField4.addFocusListener(new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent focusEvent) {
                    if (jTextField4.getText().equals("dd/MM/yyyy")) {
                        jTextField4.setText("");
                        jTextField4.setForeground(Color.BLACK);
                    }
                }

                @Override
                public void focusLost(FocusEvent focusEvent) {
                    if (jTextField4.getText().isEmpty()) {
                        jTextField4.setForeground(Color.GRAY);
                        jTextField4.setText("dd/MM/yyyy");
                    }
                }
            });
            JComboBox<String> jComboBox = new JComboBox<String>(new String[]{"Nam", "N\u1eef", "Kh\u00e1c"});
            if (user.getGender() != null) {
                jComboBox.setSelectedItem(user.getGender());
            }
            JTextField jTextField5 = new JTextField(user.getEmail(), 20);
            JComponent[] jComponentArray = new JComponent[]{jTextField, jTextField2, jTextField3, jTextField4, jComboBox, jTextField5};
            for (int i = 0; i < stringArray.length; ++i) {
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = i;
                gridBagConstraints.weightx = 0.0;
                jComponent = new JLabel(stringArray[i]);
                jComponent.setFont(new Font("Arial", 1, 12));
                jPanel.add((Component)jComponent, gridBagConstraints);
                gridBagConstraints.gridx = 1;
                gridBagConstraints.weightx = 1.0;
                jPanel.add((Component)jComponentArray[i], gridBagConstraints);
            }
            JPanel jPanel2 = new JPanel(new FlowLayout(2, 10, 10));
            jComponent = this.createStyledButton("\ud83d\udcbe L\u01b0u", SUCCESS_GREEN);
            JButton jButton = this.createStyledButton("\u274c H\u1ee7y", DANGER_RED);
            ((AbstractButton)jComponent).addActionListener(actionEvent -> {
                try {
                    int n;
                    String string = jTextField2.getText().trim();
                    String string2 = jTextField3.getText().trim();
                    String string3 = jTextField4.getText().trim();
                    if (string3.equals("dd/MM/yyyy")) {
                        string3 = "";
                    }
                    String string4 = (String)jComboBox.getSelectedItem();
                    String string5 = jTextField5.getText().trim();
                    if (string.isEmpty()) {
                        this.showWarning("H\u1ecd t\u00ean kh\u00f4ng \u0111\u01b0\u1ee3c \u0111\u1ec3 tr\u1ed1ng!");
                        return;
                    }
                    if (string.length() > 100) {
                        this.showWarning("H\u1ecd t\u00ean kh\u00f4ng \u0111\u01b0\u1ee3c v\u01b0\u1ee3t qu\u00e1 100 k\u00fd t\u1ef1!");
                        return;
                    }
                    if (string5.isEmpty()) {
                        this.showWarning("Email kh\u00f4ng \u0111\u01b0\u1ee3c \u0111\u1ec3 tr\u1ed1ng!");
                        return;
                    }
                    if (string5.length() > 255) {
                        this.showWarning("Email kh\u00f4ng \u0111\u01b0\u1ee3c v\u01b0\u1ee3t qu\u00e1 255 k\u00fd t\u1ef1!");
                        return;
                    }
                    if (!string5.matches("^[A-Za-z0-9+_.-]+@(.+)$")) {
                        this.showWarning("Email kh\u00f4ng \u0111\u00fang \u0111\u1ecbnh d\u1ea1ng!\nV\u00ed d\u1ee5: user@example.com");
                        return;
                    }
                    try {
                        if (this.userDAO.emailExists(string5, user.getId())) {
                            this.showWarning("Email \u0111\u00e3 \u0111\u01b0\u1ee3c s\u1eed d\u1ee5ng b\u1edfi ng\u01b0\u1eddi d\u00f9ng kh\u00e1c!\nVui l\u00f2ng s\u1eed d\u1ee5ng email kh\u00e1c.");
                            return;
                        }
                    }
                    catch (SQLException sQLException) {
                        this.showError("L\u1ed7i ki\u1ec3m tra email: " + sQLException.getMessage());
                        return;
                    }
                    LocalDate localDate = null;
                    if (!string3.isEmpty()) {
                        try {
                            localDate = LocalDate.parse(string3, this.dateFormatter);
                            if (localDate.isAfter(LocalDate.now())) {
                                this.showWarning("Ng\u00e0y sinh kh\u00f4ng \u0111\u01b0\u1ee3c \u1edf t\u01b0\u01a1ng lai!");
                                return;
                            }
                            n = LocalDate.now().getYear() - localDate.getYear();
                            if (n < 1 || n > 150) {
                                this.showWarning("Ng\u00e0y sinh kh\u00f4ng h\u1ee3p l\u1ec7! Tu\u1ed5i ph\u1ea3i t\u1eeb 1 \u0111\u1ebfn 150.");
                                return;
                            }
                        }
                        catch (DateTimeParseException dateTimeParseException) {
                            this.showWarning("Ng\u00e0y sinh kh\u00f4ng \u0111\u00fang \u0111\u1ecbnh d\u1ea1ng!\nVui l\u00f2ng nh\u1eadp theo \u0111\u1ecbnh d\u1ea1ng: dd/MM/yyyy\nV\u00ed d\u1ee5: 15/03/1990");
                            return;
                        }
                    }
                    user.setFullName(string);
                    user.setAddress(string2.isEmpty() ? null : string2);
                    user.setBirthDate(localDate);
                    user.setGender(string4);
                    user.setEmail(string5);
                    n = this.userDAO.updateUser(user) ? 1 : 0;
                    if (n != 0) {
                        this.showSuccess("C\u1eadp nh\u1eadt th\u00f4ng tin th\u00e0nh c\u00f4ng!");
                        this.loadUsersFromDatabase();
                        jDialog.dispose();
                    } else {
                        this.showError("Kh\u00f4ng th\u1ec3 c\u1eadp nh\u1eadt th\u00f4ng tin!\n\nC\u00f3 th\u1ec3 do:\n- L\u1ed7i k\u1ebft n\u1ed1i database\n- D\u1eef li\u1ec7u kh\u00f4ng h\u1ee3p l\u1ec7\nVui l\u00f2ng th\u1eed l\u1ea1i ho\u1eb7c li\u00ean h\u1ec7 admin.");
                    }
                }
                catch (SQLException sQLException) {
                    String string = sQLException.getMessage();
                    Object object = "L\u1ed7i khi c\u1eadp nh\u1eadt th\u00f4ng tin: " + string;
                    object = string != null && (string.contains("duplicate") || string.contains("unique") || string.contains("UNIQUE")) ? "Email \u0111\u00e3 \u0111\u01b0\u1ee3c s\u1eed d\u1ee5ng b\u1edfi ng\u01b0\u1eddi d\u00f9ng kh\u00e1c!\nVui l\u00f2ng ch\u1ecdn email kh\u00e1c." : (String)object + "\n\nVui l\u00f2ng ki\u1ec3m tra:\n- K\u1ebft n\u1ed1i database\n- Th\u00f4ng tin nh\u1eadp v\u00e0o\nHo\u1eb7c li\u00ean h\u1ec7 admin \u0111\u1ec3 \u0111\u01b0\u1ee3c h\u1ed7 tr\u1ee3.";
                    this.showError((String)object);
                    sQLException.printStackTrace();
                }
            });
            jButton.addActionListener(actionEvent -> jDialog.dispose());
            jPanel2.add(jComponent);
            jPanel2.add(jButton);
            jDialog.add((Component)new JScrollPane(jPanel), "Center");
            jDialog.add((Component)jPanel2, "South");
            jDialog.setVisible(true);
        }
        catch (SQLException sQLException) {
            this.showError("L\u1ed7i khi l\u1ea5y th\u00f4ng tin ng\u01b0\u1eddi d\u00f9ng: " + sQLException.getMessage());
            sQLException.printStackTrace();
        }
    }

    private void applyAllFilters(boolean bl) {
        try {
            String string = this.searchField.getText().trim();
            if (bl && string.isEmpty()) {
                JOptionPane.showMessageDialog(this, "Vui l\u00f2ng nh\u1eadp t\u1eeb kh\u00f3a t\u00ecm ki\u1ebfm!");
                return;
            }
            List<User> list = this.userDAO.getAllUsers();
            String string2 = (String)this.statusFilter.getSelectedItem();
            if (!"T\u1ea5t c\u1ea3".equals(string2)) {
                list.removeIf(user -> !this.matchesStatus((User)user, string2));
            }
            if (!string.isEmpty()) {
                UserDAO.SearchType searchType = this.resolveSearchType((String)this.searchTypeCombo.getSelectedItem());
                list.removeIf(user -> !this.matchesKeyword((User)user, string, searchType));
            }
            this.lastSortOption = (String)this.sortCombo.getSelectedItem();
            this.sortUsers(list, this.lastSortOption);
            this.displayUsers(list);
            if (bl) {
                this.showSuccess("T\u00ecm th\u1ea5y " + list.size() + " k\u1ebft qu\u1ea3");
            } else {
                this.showSuccess("\u0110\u00e3 l\u1ecdc " + list.size() + " ng\u01b0\u1eddi d\u00f9ng");
            }
        }
        catch (SQLException sQLException) {
            this.showError("L\u1ed7i: " + sQLException.getMessage());
            sQLException.printStackTrace();
        }
    }

    private void handleReset() {
        this.searchField.setText("");
        this.searchTypeCombo.setSelectedIndex(0);
        this.statusFilter.setSelectedIndex(0);
        this.sortCombo.setSelectedIndex(0);
        this.loadUsersFromDatabase();
        this.showSuccess("\u0110\u00e3 \u0111\u1eb7t l\u1ea1i b\u1ed9 l\u1ecdc!");
    }

    private void showDeleteUserDialog() {
        int n = this.userTable.getSelectedRow();
        if (n == -1) {
            this.showWarning("Vui l\u00f2ng ch\u1ecdn ng\u01b0\u1eddi d\u00f9ng c\u1ea7n x\u00f3a!");
            return;
        }
        int n2 = (Integer)this.userTable.getValueAt(n, 0);
        String string = this.userTable.getValueAt(n, 1).toString();
        String string2 = this.userTable.getValueAt(n, 7).toString();
        if ("\u0110\u00e3 x\u00f3a".equals(string2)) {
            this.showWarning("Ng\u01b0\u1eddi d\u00f9ng n\u00e0y \u0111\u00e3 b\u1ecb x\u00f3a tr\u01b0\u1edbc \u0111\u00f3!");
            return;
        }
        JPanel jPanel = new JPanel(new BorderLayout(10, 10));
        jPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        JLabel jLabel = new JLabel("<html><b>B\u1ea1n c\u00f3 ch\u1eafc mu\u1ed1n x\u00f3a ng\u01b0\u1eddi d\u00f9ng: " + string + "?</b><br><br>\u26a0\ufe0f L\u01b0u \u00fd: Ng\u01b0\u1eddi d\u00f9ng s\u1ebd \u0111\u01b0\u1ee3c \u0111\u00e1nh d\u1ea5u l\u00e0 '\u0110\u00e3 x\u00f3a' thay v\u00ec x\u00f3a ho\u00e0n to\u00e0n<br>\u0111\u1ec3 tr\u00e1nh m\u1ea5t d\u1eef li\u1ec7u tin nh\u1eafn v\u00e0 l\u1ecbch s\u1eed.</html>");
        jPanel.add((Component)jLabel, "Center");
        int n3 = this.showStyledConfirmDialog(this, jPanel, "X\u00e1c nh\u1eadn x\u00f3a");
        if (n3 == 0) {
            try {
                boolean bl = this.userDAO.updateUserStatus(n2, "deleted");
                if (bl) {
                    this.showSuccess("\u0110\u00e3 \u0111\u00e1nh d\u1ea5u x\u00f3a ng\u01b0\u1eddi d\u00f9ng th\u00e0nh c\u00f4ng!");
                    this.loadUsersFromDatabase();
                } else {
                    this.showError("Kh\u00f4ng th\u1ec3 x\u00f3a ng\u01b0\u1eddi d\u00f9ng");
                }
            }
            catch (SQLException sQLException) {
                String string3 = sQLException.getMessage();
                if (string3 != null && string3.contains("foreign key constraint")) {
                    this.showError("Kh\u00f4ng th\u1ec3 x\u00f3a ng\u01b0\u1eddi d\u00f9ng!\n\nL\u00fd do: Ng\u01b0\u1eddi d\u00f9ng n\u00e0y c\u00f3 d\u1eef li\u1ec7u li\u00ean quan (tin nh\u1eafn, b\u1ea1n b\u00e8, v.v.)\nNg\u01b0\u1eddi d\u00f9ng \u0111\u00e3 \u0111\u01b0\u1ee3c \u0111\u00e1nh d\u1ea5u l\u00e0 '\u0110\u00e3 x\u00f3a' thay th\u1ebf.");
                    try {
                        this.userDAO.updateUserStatus(n2, "deleted");
                        this.loadUsersFromDatabase();
                    }
                    catch (SQLException sQLException2) {
                        sQLException2.printStackTrace();
                    }
                } else {
                    this.showError("L\u1ed7i x\u00f3a ng\u01b0\u1eddi d\u00f9ng: " + string3);
                }
                sQLException.printStackTrace();
            }
        }
    }

    private void showLockAccountDialog() {
        int n = this.userTable.getSelectedRow();
        if (n == -1) {
            this.showWarning("Vui l\u00f2ng ch\u1ecdn ng\u01b0\u1eddi d\u00f9ng c\u1ea7n kh\u00f3a!");
            return;
        }
        int n2 = (Integer)this.userTable.getValueAt(n, 0);
        String string = this.userTable.getValueAt(n, 1).toString();
        int n3 = this.showStyledConfirmDialog(this, "Kh\u00f3a t\u00e0i kho\u1ea3n: " + string + "?", "X\u00e1c nh\u1eadn kh\u00f3a");
        if (n3 == 0) {
            try {
                boolean bl = this.userDAO.updateUserStatus(n2, "locked");
                if (bl) {
                    this.showSuccess("\u0110\u00e3 kh\u00f3a t\u00e0i kho\u1ea3n th\u00e0nh c\u00f4ng!");
                    this.loadUsersFromDatabase();
                } else {
                    this.showError("Kh\u00f4ng th\u1ec3 kh\u00f3a t\u00e0i kho\u1ea3n");
                }
            }
            catch (SQLException sQLException) {
                this.showError("L\u1ed7i kh\u00f3a t\u00e0i kho\u1ea3n: " + sQLException.getMessage());
                sQLException.printStackTrace();
            }
        }
    }

    private void showUnlockAccountDialog() {
        int n = this.userTable.getSelectedRow();
        if (n == -1) {
            this.showWarning("Vui l\u00f2ng ch\u1ecdn ng\u01b0\u1eddi d\u00f9ng c\u1ea7n m\u1edf kh\u00f3a!");
            return;
        }
        int n2 = (Integer)this.userTable.getValueAt(n, 0);
        String string = this.userTable.getValueAt(n, 1).toString();
        int n3 = this.showStyledConfirmDialog(this, "M\u1edf kh\u00f3a t\u00e0i kho\u1ea3n: " + string + "?", "X\u00e1c nh\u1eadn m\u1edf kh\u00f3a");
        if (n3 == 0) {
            try {
                boolean bl = this.userDAO.updateUserStatus(n2, "active");
                if (bl) {
                    this.showSuccess("\u0110\u00e3 m\u1edf kh\u00f3a t\u00e0i kho\u1ea3n th\u00e0nh c\u00f4ng!");
                    this.loadUsersFromDatabase();
                } else {
                    this.showError("Kh\u00f4ng th\u1ec3 m\u1edf kh\u00f3a t\u00e0i kho\u1ea3n");
                }
            }
            catch (SQLException sQLException) {
                this.showError("L\u1ed7i m\u1edf kh\u00f3a t\u00e0i kho\u1ea3n: " + sQLException.getMessage());
                sQLException.printStackTrace();
            }
        }
    }

    private void showChangePasswordDialog() {
        int n = this.userTable.getSelectedRow();
        if (n == -1) {
            this.showWarning("Vui l\u00f2ng ch\u1ecdn ng\u01b0\u1eddi d\u00f9ng c\u1ea7n \u0111\u1ed5i m\u1eadt kh\u1ea9u!");
            return;
        }
        int n2 = (Integer)this.userTable.getValueAt(n, 0);
        String string = this.userTable.getValueAt(n, 1).toString();
        JPasswordField jPasswordField = new JPasswordField(20);
        JPasswordField jPasswordField2 = new JPasswordField(20);
        JPanel jPanel = new JPanel(new GridLayout(3, 2, 10, 10));
        jPanel.add(new JLabel("Ng\u01b0\u1eddi d\u00f9ng:"));
        jPanel.add(new JLabel(string));
        jPanel.add(new JLabel("M\u1eadt kh\u1ea9u m\u1edbi:"));
        jPanel.add(jPasswordField);
        jPanel.add(new JLabel("X\u00e1c nh\u1eadn:"));
        jPanel.add(jPasswordField2);
        int n3 = this.showStyledConfirmDialog(this, jPanel, "\u0110\u1ed5i m\u1eadt kh\u1ea9u");
        if (n3 == 0) {
            String string2 = new String(jPasswordField.getPassword());
            String string3 = new String(jPasswordField2.getPassword());
            if (string2.isEmpty()) {
                this.showWarning("M\u1eadt kh\u1ea9u kh\u00f4ng \u0111\u01b0\u1ee3c \u0111\u1ec3 tr\u1ed1ng!");
                return;
            }
            if (!string2.equals(string3)) {
                this.showWarning("M\u1eadt kh\u1ea9u x\u00e1c nh\u1eadn kh\u00f4ng kh\u1edbp!");
                return;
            }
            try {
                boolean bl = this.userDAO.updatePassword(n2, string2);
                if (bl) {
                    this.showSuccess("\u0110\u1ed5i m\u1eadt kh\u1ea9u th\u00e0nh c\u00f4ng!");
                } else {
                    this.showError("Kh\u00f4ng th\u1ec3 \u0111\u1ed5i m\u1eadt kh\u1ea9u");
                }
            }
            catch (SQLException sQLException) {
                this.showError("L\u1ed7i \u0111\u1ed5i m\u1eadt kh\u1ea9u: " + sQLException.getMessage());
                sQLException.printStackTrace();
            }
        }
    }

    private void showResetPasswordDialog() {
        int n = this.userTable.getSelectedRow();
        if (n == -1) {
            this.showWarning("Vui l\u00f2ng ch\u1ecdn ng\u01b0\u1eddi d\u00f9ng c\u1ea7n reset m\u1eadt kh\u1ea9u!");
            return;
        }
        int n2 = (Integer)this.userTable.getValueAt(n, 0);
        String string = this.userTable.getValueAt(n, 1).toString();
        int n3 = this.showStyledConfirmDialog(this, "Reset m\u1eadt kh\u1ea9u cho user: " + string + "?\nM\u1eadt kh\u1ea9u m\u1edbi s\u1ebd \u0111\u01b0\u1ee3c t\u1ef1 \u0111\u1ed9ng t\u1ea1o.", "X\u00e1c nh\u1eadn Reset");
        if (n3 != 0) {
            return;
        }
        try {
            String string2 = this.generateRandomPassword();
            boolean bl = this.userDAO.updatePassword(n2, string2);
            if (bl) {
                JPanel jPanel = new JPanel(new BorderLayout(10, 10));
                JLabel jLabel = new JLabel("<html><b>M\u1eadt kh\u1ea9u m\u1edbi cho " + string + ":</b></html>");
                JTextField jTextField = new JTextField(string2);
                jTextField.setEditable(false);
                jTextField.setFont(new Font("Monospaced", 1, 14));
                JButton jButton = new JButton("\ud83d\udccb Copy");
                jButton.addActionListener(actionEvent -> {
                    StringSelection stringSelection = new StringSelection(string2);
                    Toolkit.getDefaultToolkit().getSystemClipboard().setContents(stringSelection, null);
                    JOptionPane.showMessageDialog(this, "\u0110\u00e3 copy v\u00e0o clipboard!", "Th\u00f4ng b\u00e1o", 1);
                });
                jPanel.add((Component)jLabel, "North");
                jPanel.add((Component)jTextField, "Center");
                jPanel.add((Component)jButton, "South");
                JOptionPane.showMessageDialog(this, jPanel, "Reset M\u1eadt Kh\u1ea9u Th\u00e0nh C\u00f4ng!", 1);
                this.showSuccess("Reset m\u1eadt kh\u1ea9u th\u00e0nh c\u00f4ng!");
            } else {
                this.showError("Kh\u00f4ng th\u1ec3 reset m\u1eadt kh\u1ea9u");
            }
        }
        catch (SQLException sQLException) {
            this.showError("L\u1ed7i reset m\u1eadt kh\u1ea9u: " + sQLException.getMessage());
            sQLException.printStackTrace();
        }
    }

    private String generateRandomPassword() {
        String string = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
        String string2 = "abcdefghijklmnopqrstuvwxyz";
        String string3 = "0123456789";
        String string4 = "!@#$%^&*";
        String string5 = string + string2 + string3 + string4;
        Random random = new Random();
        int n = 10;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string.charAt(random.nextInt(string.length())));
        stringBuilder.append(string2.charAt(random.nextInt(string2.length())));
        stringBuilder.append(string3.charAt(random.nextInt(string3.length())));
        stringBuilder.append(string4.charAt(random.nextInt(string4.length())));
        for (int i = 4; i < n; ++i) {
            stringBuilder.append(string5.charAt(random.nextInt(string5.length())));
        }
        char[] cArray = stringBuilder.toString().toCharArray();
        for (int i = cArray.length - 1; i > 0; --i) {
            int n2 = random.nextInt(i + 1);
            char c = cArray[i];
            cArray[i] = cArray[n2];
            cArray[n2] = c;
        }
        return new String(cArray);
    }

    private void showSuccess(String string) {
        JOptionPane.showMessageDialog(this, string, "Th\u00e0nh c\u00f4ng", 1);
    }

    private void showError(String string) {
        JOptionPane.showMessageDialog(this, string, "L\u1ed7i", 0);
    }

    private void showLoginHistoryDialog() {
        try {
            Object object;
            List<LoginHistory> list = this.loginHistoryDAO.getAllLoginHistory();
            if (list.isEmpty()) {
                this.showWarning("Ch\u01b0a c\u00f3 l\u1ecbch s\u1eed \u0111\u0103ng nh\u1eadp n\u00e0o trong h\u1ec7 th\u1ed1ng");
                return;
            }
            List<User> list2 = this.userDAO.getAllUsers();
            HashMap<Integer, User> hashMap = new HashMap<Integer, User>();
            for (User objectArray2 : list2) {
                hashMap.put(objectArray2.getId(), objectArray2);
            }
            JDialog jDialog = new JDialog((Frame)SwingUtilities.getWindowAncestor(this), "L\u1ecbch s\u1eed \u0111\u0103ng nh\u1eadp - T\u1ea5t c\u1ea3 ng\u01b0\u1eddi d\u00f9ng", true);
            jDialog.setSize(1100, 600);
            jDialog.setLocationRelativeTo(this);
            Object[] objectArray = new String[]{"ID", "T\u00ean \u0111\u0103ng nh\u1eadp", "H\u1ecd t\u00ean", "\u0110\u1ecba ch\u1ec9", "Ng\u00e0y sinh", "Gi\u1edbi t\u00ednh", "Email", "Th\u1eddi gian", "\u0110\u1ecba ch\u1ec9 IP", "Thi\u1ebft b\u1ecb"};
            DefaultTableModel defaultTableModel = new DefaultTableModel(objectArray, 0){

                @Override
                public boolean isCellEditable(int n, int n2) {
                    return false;
                }
            };
            DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("dd/MM/yyyy");
            DateTimeFormatter dateTimeFormatter2 = DateTimeFormatter.ofPattern("dd/MM/yyyy HH:mm:ss");
            for (LoginHistory loginHistory : list) {
                object = (User)hashMap.get(loginHistory.getUserId());
                if (object == null) continue;
                defaultTableModel.addRow(new Object[]{((User)object).getId(), ((User)object).getUsername(), ((User)object).getFullName() != null ? ((User)object).getFullName() : "", ((User)object).getAddress() != null ? ((User)object).getAddress() : "", ((User)object).getBirthDate() != null ? ((User)object).getBirthDate().format(dateTimeFormatter) : "", ((User)object).getGender() != null ? ((User)object).getGender() : "", ((User)object).getEmail() != null ? ((User)object).getEmail() : "", loginHistory.getLoginTime() != null ? loginHistory.getLoginTime().format(dateTimeFormatter2) : "", loginHistory.getIpAddress() != null ? loginHistory.getIpAddress() : "N/A", loginHistory.getUserAgent() != null ? loginHistory.getUserAgent() : ""});
            }
            JTable jTable = new JTable(defaultTableModel);
            jTable.setRowHeight(24);
            jTable.getTableHeader().setFont(new Font("Arial", 1, 12));
            jTable.getColumnModel().getColumn(0).setPreferredWidth(40);
            jTable.getColumnModel().getColumn(1).setPreferredWidth(100);
            jTable.getColumnModel().getColumn(2).setPreferredWidth(120);
            jTable.getColumnModel().getColumn(3).setPreferredWidth(100);
            jTable.getColumnModel().getColumn(4).setPreferredWidth(90);
            jTable.getColumnModel().getColumn(5).setPreferredWidth(70);
            jTable.getColumnModel().getColumn(6).setPreferredWidth(150);
            jTable.getColumnModel().getColumn(7).setPreferredWidth(130);
            jTable.getColumnModel().getColumn(8).setPreferredWidth(100);
            jTable.getColumnModel().getColumn(9).setPreferredWidth(200);
            jTable.setAutoCreateRowSorter(true);
            jDialog.add((Component)new JScrollPane(jTable), "Center");
            JButton jButton = this.createStyledButton("\u0110\u00f3ng", new Color(108, 117, 125));
            jButton.addActionListener(actionEvent -> jDialog.dispose());
            object = new JPanel(new FlowLayout(2));
            ((Container)object).add(jButton);
            jDialog.add((Component)object, "South");
            jDialog.setVisible(true);
        }
        catch (SQLException sQLException) {
            this.showError("L\u1ed7i l\u1ea5y l\u1ecbch s\u1eed \u0111\u0103ng nh\u1eadp: " + sQLException.getMessage());
            sQLException.printStackTrace();
        }
    }

    private void showFriendsListDialog() {
        int n = this.userTable.getSelectedRow();
        if (n == -1) {
            this.showWarning("Vui l\u00f2ng ch\u1ecdn ng\u01b0\u1eddi d\u00f9ng!");
            return;
        }
        int n2 = (Integer)this.userTable.getValueAt(n, 0);
        String string = this.userTable.getValueAt(n, 1).toString();
        try {
            Object sQLException;
            List<User> list = this.statisticsDAO.getFriendsOfUser(n2);
            if (list.isEmpty()) {
                this.showWarning("Ng\u01b0\u1eddi d\u00f9ng ch\u01b0a c\u00f3 b\u1ea1n b\u00e8");
                return;
            }
            JDialog jDialog = new JDialog((Frame)SwingUtilities.getWindowAncestor(this), "Danh s\u00e1ch b\u1ea1n b\u00e8 - " + string, true);
            jDialog.setSize(1000, 500);
            jDialog.setLocationRelativeTo(this);
            Object[] objectArray = new String[]{"ID", "T\u00ean \u0111\u0103ng nh\u1eadp", "H\u1ecd t\u00ean", "\u0110\u1ecba ch\u1ec9", "Ng\u00e0y sinh", "Gi\u1edbi t\u00ednh", "Email", "Tr\u1ea1ng th\u00e1i", "Ng\u00e0y t\u1ea1o"};
            DefaultTableModel defaultTableModel = new DefaultTableModel(objectArray, 0){

                @Override
                public boolean isCellEditable(int n, int n2) {
                    return false;
                }
            };
            DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("dd/MM/yyyy");
            DateTimeFormatter dateTimeFormatter2 = DateTimeFormatter.ofPattern("dd/MM/yyyy HH:mm:ss");
            for (User object22 : list) {
                try {
                    sQLException = this.userDAO.getUserById(object22.getId());
                    if (sQLException == null) continue;
                    defaultTableModel.addRow(new Object[]{((User)sQLException).getId(), ((User)sQLException).getUsername(), ((User)sQLException).getFullName() != null ? ((User)sQLException).getFullName() : "", ((User)sQLException).getAddress() != null ? ((User)sQLException).getAddress() : "", ((User)sQLException).getBirthDate() != null ? ((User)sQLException).getBirthDate().format(dateTimeFormatter) : "", ((User)sQLException).getGender() != null ? ((User)sQLException).getGender() : "", ((User)sQLException).getEmail() != null ? ((User)sQLException).getEmail() : "", this.formatStatus(((User)sQLException).getStatus()), ((User)sQLException).getCreatedAt() != null ? ((User)sQLException).getCreatedAt().format(dateTimeFormatter2) : ""});
                }
                catch (SQLException sQLException2) {
                    System.err.println("L\u1ed7i l\u1ea5y th\u00f4ng tin user ID: " + object22.getId());
                }
            }
            JTable jTable = new JTable(defaultTableModel);
            jTable.setRowHeight(24);
            jTable.getTableHeader().setFont(new Font("Arial", 1, 12));
            jTable.getColumnModel().getColumn(0).setPreferredWidth(40);
            jTable.getColumnModel().getColumn(1).setPreferredWidth(100);
            jTable.getColumnModel().getColumn(2).setPreferredWidth(120);
            jTable.getColumnModel().getColumn(3).setPreferredWidth(100);
            jTable.getColumnModel().getColumn(4).setPreferredWidth(90);
            jTable.getColumnModel().getColumn(5).setPreferredWidth(70);
            jTable.getColumnModel().getColumn(6).setPreferredWidth(150);
            jTable.getColumnModel().getColumn(7).setPreferredWidth(90);
            jTable.getColumnModel().getColumn(8).setPreferredWidth(130);
            jDialog.add((Component)new JScrollPane(jTable), "Center");
            JButton jButton = this.createStyledButton("\u0110\u00f3ng", new Color(108, 117, 125));
            jButton.addActionListener(actionEvent -> jDialog.dispose());
            sQLException = new JPanel(new FlowLayout(2));
            ((Container)sQLException).add(jButton);
            jDialog.add((Component)sQLException, "South");
            jDialog.setVisible(true);
        }
        catch (SQLException sQLException) {
            this.showError("L\u1ed7i l\u1ea5y danh s\u00e1ch b\u1ea1n b\u00e8: " + sQLException.getMessage());
        }
    }

    private void showWarning(String string) {
        JOptionPane.showMessageDialog(this, string, "C\u1ea3nh b\u00e1o", 2);
    }

    private JButton createStyledButton(String string, Color color) {
        JButton jButton = new JButton(string);
        jButton.setFont(new Font("Arial", 1, 12));
        jButton.setBackground(color);
        jButton.setForeground(Color.WHITE);
        jButton.setOpaque(true);
        jButton.setBorderPainted(false);
        jButton.setFocusPainted(false);
        jButton.setMargin(new Insets(5, 12, 5, 12));
        jButton.setCursor(new Cursor(12));
        return jButton;
    }

    private ImageIcon loadIcon(String string, int n, int n2) {
        try {
            String string2 = "icons/" + string + ".png";
            ImageIcon imageIcon = new ImageIcon(string2);
            if (imageIcon.getImageLoadStatus() == 8) {
                Image image = imageIcon.getImage().getScaledInstance(n, n2, 4);
                return new ImageIcon(image);
            }
        }
        catch (Exception exception) {
            System.err.println("Could not load icon: " + string);
        }
        return null;
    }

    private JButton createButtonWithIcon(String string, String string2, Color color) {
        ImageIcon imageIcon = this.loadIcon(string2, 16, 16);
        JButton jButton = imageIcon != null ? new JButton(string, imageIcon) : new JButton(string);
        jButton.setFont(new Font("Arial", 1, 12));
        jButton.setBackground(color);
        jButton.setForeground(Color.WHITE);
        jButton.setOpaque(true);
        jButton.setBorderPainted(false);
        jButton.setFocusPainted(false);
        jButton.setMargin(new Insets(5, 12, 5, 12));
        jButton.setCursor(new Cursor(12));
        return jButton;
    }

    private void addActionToButton(String string, ActionListener actionListener) {
        Component[] componentArray;
        for (Component component : componentArray = this.getAllComponents(this)) {
            JButton jButton;
            if (!(component instanceof JButton) || !(jButton = (JButton)component).getText().equals(string)) continue;
            jButton.addActionListener(actionListener);
            break;
        }
    }

    private void sortUsers(List<User> list, String string) {
        if (list == null || string == null) {
            return;
        }
        list.sort(switch (string) {
            case "S\u1eafp x\u1ebfp theo t\u00ean (A-Z)" -> {
                Collator var6_5 = Collator.getInstance(new Locale("vi", "VN"));
                var6_5.setStrength(1);
                yield Comparator.comparing(user -> user.getFullName() != null ? user.getFullName() : "", Comparator.nullsLast(var6_5));
            }
            case "S\u1eafp x\u1ebfp theo t\u00ean (Z-A)" -> {
                Collator var7_7 = Collator.getInstance(new Locale("vi", "VN"));
                var7_7.setStrength(1);
                yield Comparator.comparing(user -> user.getFullName() != null ? user.getFullName() : "", Comparator.nullsFirst(var7_7)).reversed();
            }
            case "S\u1eafp x\u1ebfp theo ng\u00e0y t\u1ea1o (C\u0169 nh\u1ea5t)" -> Comparator.comparing(User::getCreatedAt, Comparator.nullsLast(LocalDateTime::compareTo));
            default -> Comparator.comparing(User::getCreatedAt, Comparator.nullsLast(LocalDateTime::compareTo)).reversed();
        });
    }

    private String formatStatus(String string) {
        if (string == null) {
            return "";
        }
        if ("deleted".equalsIgnoreCase(string)) {
            return "\u0110\u00e3 x\u00f3a";
        }
        return "locked".equalsIgnoreCase(string) ? "B\u1ecb kh\u00f3a" : "Ho\u1ea1t \u0111\u1ed9ng";
    }

    private UserDAO.SearchType resolveSearchType(String string) {
        if (string == null) {
            return UserDAO.SearchType.ALL;
        }
        if (string.contains("\u0111\u0103ng nh\u1eadp")) {
            return UserDAO.SearchType.USERNAME;
        }
        if (string.contains("email")) {
            return UserDAO.SearchType.EMAIL;
        }
        if (string.contains("t\u00ean")) {
            return UserDAO.SearchType.FULL_NAME;
        }
        return UserDAO.SearchType.ALL;
    }

    private boolean matchesStatus(User user, String string) {
        if ("T\u1ea5t c\u1ea3".equals(string)) {
            return true;
        }
        String string2 = user.getStatus();
        if (string.equals("Ho\u1ea1t \u0111\u1ed9ng")) {
            return !"locked".equalsIgnoreCase(string2) && !"deleted".equalsIgnoreCase(string2);
        }
        if (string.equals("B\u1ecb kh\u00f3a")) {
            return "locked".equalsIgnoreCase(string2);
        }
        if (string.equals("\u0110\u00e3 x\u00f3a")) {
            return "deleted".equalsIgnoreCase(string2);
        }
        return false;
    }

    private boolean matchesKeyword(User user, String string, UserDAO.SearchType searchType) {
        String string2 = string.toLowerCase();
        switch (searchType) {
            case USERNAME: {
                return user.getUsername() != null && user.getUsername().toLowerCase().contains(string2);
            }
            case FULL_NAME: {
                return user.getFullName() != null && user.getFullName().toLowerCase().contains(string2);
            }
            case EMAIL: {
                return user.getEmail() != null && user.getEmail().toLowerCase().contains(string2);
            }
        }
        return user.getUsername() != null && user.getUsername().toLowerCase().contains(string2) || user.getFullName() != null && user.getFullName().toLowerCase().contains(string2) || user.getEmail() != null && user.getEmail().toLowerCase().contains(string2);
    }

    private Component[] getAllComponents(Container container) {
        Component[] componentArray;
        ArrayList<Component> arrayList = new ArrayList<Component>();
        for (Component component : componentArray = container.getComponents()) {
            Component[] componentArray2;
            arrayList.add(component);
            if (!(component instanceof Container)) continue;
            for (Component component2 : componentArray2 = this.getAllComponents((Container)component)) {
                arrayList.add(component2);
            }
        }
        return arrayList.toArray(new Component[0]);
    }

    private void handleExportCSV() {
        try {
            List<User> list = this.userDAO.getAllUsers();
            if (list.isEmpty()) {
                this.showWarning("Kh\u00f4ng c\u00f3 d\u1eef li\u1ec7u \u0111\u1ec3 xu\u1ea5t!");
                return;
            }
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.setDialogTitle("L\u01b0u file CSV");
            jFileChooser.setSelectedFile(new File("DanhSachNguoiDung.csv"));
            int n = jFileChooser.showSaveDialog(this);
            if (n != 0) {
                return;
            }
            File file = jFileChooser.getSelectedFile();
            Object object = file.getAbsolutePath();
            if (!((String)object).toLowerCase().endsWith(".csv")) {
                object = (String)object + ".csv";
            }
            try (PrintWriter printWriter = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream((String)object), StandardCharsets.UTF_8));){
                printWriter.write(65279);
                printWriter.println("ID,T\u00ean \u0111\u0103ng nh\u1eadp,H\u1ecd t\u00ean,\u0110\u1ecba ch\u1ec9,Ng\u00e0y sinh,Gi\u1edbi t\u00ednh,Email,Tr\u1ea1ng th\u00e1i,Ng\u00e0y t\u1ea1o");
                DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("dd/MM/yyyy");
                for (User user : list) {
                    String string = String.format("%d,\"%s\",\"%s\",\"%s\",\"%s\",\"%s\",\"%s\",\"%s\",\"%s\"", user.getId(), this.escapeCsv(user.getUsername()), this.escapeCsv(user.getFullName()), this.escapeCsv(user.getAddress()), user.getBirthDate() != null ? user.getBirthDate().format(dateTimeFormatter) : "", this.escapeCsv(user.getGender()), this.escapeCsv(user.getEmail()), this.formatStatus(user.getStatus()), user.getCreatedAt() != null ? user.getCreatedAt().format(dateTimeFormatter) : "");
                    printWriter.println(string);
                }
            }
            this.showSuccess("\u0110\u00e3 xu\u1ea5t " + list.size() + " ng\u01b0\u1eddi d\u00f9ng v\u00e0o file:\n" + (String)object);
        }
        catch (Exception exception) {
            this.showError("L\u1ed7i xu\u1ea5t file: " + exception.getMessage());
            exception.printStackTrace();
        }
    }

    private String escapeCsv(String string) {
        if (string == null) {
            return "";
        }
        return string.replace("\"", "\"\"");
    }

    private int showStyledConfirmDialog(Component component, Object object, String string) {
        JComponent jComponent;
        JDialog jDialog = new JDialog((Frame)SwingUtilities.getWindowAncestor(component), string, true);
        jDialog.setLayout(new BorderLayout(10, 10));
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(new EmptyBorder(20, 20, 10, 20));
        if (object instanceof Component) {
            jPanel.add((Component)object, "Center");
        } else {
            jComponent = new JLabel("<html>" + object.toString() + "</html>");
            jComponent.setFont(new Font("Arial", 0, 14));
            jPanel.add((Component)jComponent, "Center");
        }
        jComponent = new JPanel(new FlowLayout(1, 10, 10));
        jComponent.setBorder(new EmptyBorder(10, 20, 20, 20));
        int[] nArray = new int[]{-1};
        JButton jButton = new JButton("C\u00f3");
        jButton.setBackground(new Color(40, 167, 69));
        jButton.setForeground(Color.WHITE);
        jButton.setFont(new Font("Arial", 1, 12));
        jButton.setOpaque(true);
        jButton.setBorderPainted(false);
        jButton.setFocusPainted(false);
        jButton.setPreferredSize(new Dimension(80, 35));
        jButton.setCursor(new Cursor(12));
        jButton.addActionListener(actionEvent -> {
            nArray[0] = 0;
            jDialog.dispose();
        });
        JButton jButton2 = new JButton("H\u1ee7y");
        jButton2.setBackground(new Color(220, 53, 69));
        jButton2.setForeground(Color.WHITE);
        jButton2.setFont(new Font("Arial", 1, 12));
        jButton2.setOpaque(true);
        jButton2.setBorderPainted(false);
        jButton2.setFocusPainted(false);
        jButton2.setPreferredSize(new Dimension(80, 35));
        jButton2.setCursor(new Cursor(12));
        jButton2.addActionListener(actionEvent -> {
            nArray[0] = 1;
            jDialog.dispose();
        });
        jComponent.add(jButton);
        jComponent.add(jButton2);
        jDialog.add((Component)jPanel, "Center");
        jDialog.add((Component)jComponent, "South");
        jDialog.setDefaultCloseOperation(2);
        jDialog.pack();
        jDialog.setLocationRelativeTo(component);
        jDialog.setVisible(true);
        return nArray[0];
    }

    private void exportUsersToCSV() {
        try {
            if (this.userTable.getRowCount() == 0) {
                JOptionPane.showMessageDialog(this, "Kh\u00f4ng c\u00f3 d\u1eef li\u1ec7u \u0111\u1ec3 xu\u1ea5t!", "C\u1ea3nh b\u00e1o", 2);
                return;
            }
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.setDialogTitle("L\u01b0u file CSV");
            jFileChooser.setSelectedFile(new File("DanhSachNguoiDung.csv"));
            if (jFileChooser.showSaveDialog(this) != 0) {
                return;
            }
            Object object = jFileChooser.getSelectedFile().getAbsolutePath();
            if (!((String)object).toLowerCase().endsWith(".csv")) {
                object = (String)object + ".csv";
            }
            try (PrintWriter printWriter = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream((String)object), StandardCharsets.UTF_8));){
                printWriter.write(65279);
                printWriter.println("ID,Username,H\u1ecd t\u00ean,Email,S\u1ed1 \u0111i\u1ec7n tho\u1ea1i,Gi\u1edbi t\u00ednh,Ng\u00e0y sinh,\u0110\u1ecba ch\u1ec9,Tr\u1ea1ng th\u00e1i,Ng\u00e0y t\u1ea1o");
                for (int i = 0; i < this.userTable.getRowCount(); ++i) {
                    printWriter.printf("%s,\"%s\",\"%s\",\"%s\",\"%s\",\"%s\",\"%s\",\"%s\",\"%s\",\"%s\"\n", this.userTable.getValueAt(i, 0), this.userTable.getValueAt(i, 1), this.userTable.getValueAt(i, 2), this.userTable.getValueAt(i, 3), this.userTable.getValueAt(i, 4), this.userTable.getValueAt(i, 5), this.userTable.getValueAt(i, 6), this.userTable.getValueAt(i, 7), this.userTable.getValueAt(i, 8), this.userTable.getValueAt(i, 9));
                }
            }
            JOptionPane.showMessageDialog(this, "\u0110\u00e3 xu\u1ea5t " + this.userTable.getRowCount() + " ng\u01b0\u1eddi d\u00f9ng v\u00e0o:\n" + (String)object, "Th\u00e0nh c\u00f4ng", 1);
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this, "L\u1ed7i xu\u1ea5t file: " + exception.getMessage(), "L\u1ed7i", 0);
            exception.printStackTrace();
        }
    }
}

