/*
 * Decompiled with CFR 0.152.
 */
package admin.service;

import admin.service.DatabaseConnection;
import admin.socket.ChatGroup;
import admin.socket.User;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;

public class GroupDAO {
    private DatabaseConnection dbConnection = DatabaseConnection.getInstance();

    public List<ChatGroup> getAllGroups() throws SQLException {
        ArrayList<ChatGroup> arrayList = new ArrayList<ChatGroup>();
        String string = "SELECT g.group_id, g.group_name, g.admin_id, g.created_at, g.encrypted, COALESCE(u.full_name, 'User #' || g.admin_id) as creator_name, (SELECT COUNT(*) FROM group_members gm WHERE gm.group_id = g.group_id) as member_count, (1 + COALESCE((SELECT COUNT(*) FROM group_members gm2 WHERE gm2.group_id = g.group_id AND gm2.is_admin = true AND gm2.user_id != g.admin_id), 0)) as admin_count FROM groups g LEFT JOIN users u ON g.admin_id = u.user_id ORDER BY g.created_at DESC";
        try (Connection connection = this.dbConnection.getConnection();
             Statement statement = connection.createStatement();
             ResultSet resultSet = statement.executeQuery(string);){
            while (resultSet.next()) {
                ChatGroup chatGroup = this.extractGroupFromResultSet(resultSet);
                try {
                    chatGroup.setAdminCount(resultSet.getInt("admin_count"));
                }
                catch (Exception exception) {
                    chatGroup.setAdminCount(1);
                }
                arrayList.add(chatGroup);
            }
        }
        catch (SQLException sQLException) {
            System.out.println("\u26a0\ufe0f Optimized query failed, using fallback: " + sQLException.getMessage());
            return this.getAllGroupsFallback();
        }
        return arrayList;
    }

    private List<ChatGroup> getAllGroupsFallback() throws SQLException {
        ArrayList<ChatGroup> arrayList = new ArrayList<ChatGroup>();
        String string = "SELECT g.group_id, g.group_name, g.admin_id, g.created_at, g.encrypted, COALESCE(u.full_name, 'User #' || g.admin_id) as creator_name, (SELECT COUNT(*) FROM group_members gm WHERE gm.group_id = g.group_id) as member_count FROM groups g LEFT JOIN users u ON g.admin_id = u.user_id ORDER BY g.created_at DESC";
        try (Connection connection = this.dbConnection.getConnection();
             Statement statement = connection.createStatement();
             ResultSet resultSet = statement.executeQuery(string);){
            while (resultSet.next()) {
                ChatGroup chatGroup = this.extractGroupFromResultSet(resultSet);
                chatGroup.setAdminCount(1);
                arrayList.add(chatGroup);
            }
        }
        return arrayList;
    }

    public List<ChatGroup> searchGroups(String string) throws SQLException {
        ArrayList<ChatGroup> arrayList = new ArrayList<ChatGroup>();
        String string2 = "SELECT g.group_id, g.group_name, g.admin_id, g.created_at, g.encrypted, COALESCE(u.full_name, 'User #' || g.admin_id) as creator_name, (SELECT COUNT(*) FROM group_members gm WHERE gm.group_id = g.group_id) as member_count FROM groups g LEFT JOIN users u ON g.admin_id = u.user_id WHERE g.group_name LIKE ? ORDER BY g.created_at DESC";
        try (Connection connection = this.dbConnection.getConnection();
             PreparedStatement preparedStatement = connection.prepareStatement(string2);){
            preparedStatement.setString(1, "%" + string + "%");
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                while (resultSet.next()) {
                    arrayList.add(this.extractGroupFromResultSet(resultSet));
                }
            }
        }
        return arrayList;
    }

    public List<ChatGroup> searchGroups(String string, boolean bl) throws SQLException {
        if (!bl) {
            return this.searchGroups(string);
        }
        ArrayList<ChatGroup> arrayList = new ArrayList<ChatGroup>();
        String string2 = "SELECT g.group_id, g.group_name, g.admin_id, g.created_at, g.encrypted, COALESCE(u.full_name, 'User #' || g.admin_id) as creator_name, (SELECT COUNT(*) FROM group_members gm WHERE gm.group_id = g.group_id) as member_count FROM groups g LEFT JOIN users u ON g.admin_id = u.user_id WHERE u.full_name LIKE ? OR u.username LIKE ? ORDER BY g.created_at DESC";
        try (Connection connection = this.dbConnection.getConnection();
             PreparedStatement preparedStatement = connection.prepareStatement(string2);){
            String string3 = "%" + string + "%";
            preparedStatement.setString(1, string3);
            preparedStatement.setString(2, string3);
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                while (resultSet.next()) {
                    arrayList.add(this.extractGroupFromResultSet(resultSet));
                }
            }
        }
        return arrayList;
    }

    public ChatGroup getGroupById(int n) throws SQLException {
        String string = "SELECT g.group_id, g.group_name, g.admin_id, g.created_at, g.encrypted, COALESCE(u.full_name, 'User #' || g.admin_id) as creator_name, (SELECT COUNT(*) FROM group_members gm WHERE gm.group_id = g.group_id) as member_count FROM groups g LEFT JOIN users u ON g.admin_id = u.user_id WHERE g.group_id = ?";
        try (Connection connection = this.dbConnection.getConnection();
             PreparedStatement preparedStatement = connection.prepareStatement(string);){
            preparedStatement.setInt(1, n);
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                if (resultSet.next()) {
                    ChatGroup chatGroup = this.extractGroupFromResultSet(resultSet);
                    return chatGroup;
                }
            }
        }
        return null;
    }

    public int getTotalGroups() throws SQLException {
        String string = "SELECT COUNT(*) FROM groups";
        try (Connection connection = this.dbConnection.getConnection();
             Statement statement = connection.createStatement();
             ResultSet resultSet = statement.executeQuery(string);){
            if (resultSet.next()) {
                int n = resultSet.getInt(1);
                return n;
            }
        }
        return 0;
    }

    public boolean deleteGroup(int n) throws SQLException {
        String string = "DELETE FROM groups WHERE group_id = ?";
        try (Connection connection = this.dbConnection.getConnection();){
            boolean bl;
            block12: {
                PreparedStatement preparedStatement = connection.prepareStatement(string);
                try {
                    preparedStatement.setInt(1, n);
                    boolean bl2 = bl = preparedStatement.executeUpdate() > 0;
                    if (preparedStatement == null) break block12;
                }
                catch (Throwable throwable) {
                    if (preparedStatement != null) {
                        try {
                            preparedStatement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                preparedStatement.close();
            }
            return bl;
        }
    }

    private ChatGroup extractGroupFromResultSet(ResultSet resultSet) throws SQLException {
        ChatGroup chatGroup = new ChatGroup();
        chatGroup.setId(resultSet.getInt("group_id"));
        chatGroup.setGroupName(resultSet.getString("group_name"));
        chatGroup.setDescription("");
        chatGroup.setCreatedBy(resultSet.getInt("admin_id"));
        chatGroup.setCreatorName(resultSet.getString("creator_name"));
        chatGroup.setMemberCount(resultSet.getInt("member_count"));
        Timestamp timestamp = resultSet.getTimestamp("created_at");
        if (timestamp != null) {
            chatGroup.setCreatedAt(timestamp.toLocalDateTime());
        }
        return chatGroup;
    }

    public List<User> getGroupMembers(int n) throws SQLException {
        ArrayList<User> arrayList = new ArrayList<User>();
        String string = "SELECT u.* FROM group_members gm JOIN users u ON gm.user_id = u.user_id WHERE gm.group_id = ? ORDER BY u.full_name";
        try (Connection connection = this.dbConnection.getConnection();
             PreparedStatement preparedStatement = connection.prepareStatement(string);){
            preparedStatement.setInt(1, n);
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                while (resultSet.next()) {
                    arrayList.add(this.extractUserSummary(resultSet));
                }
            }
        }
        return arrayList;
    }

    public List<User> getGroupAdmins(int n) throws SQLException {
        AutoCloseable autoCloseable;
        AutoCloseable autoCloseable2;
        ArrayList<User> arrayList = new ArrayList<User>();
        String string = "SELECT u.* FROM groups g JOIN users u ON g.admin_id = u.user_id WHERE g.group_id = ?";
        try (Object object = this.dbConnection.getConnection();){
            autoCloseable2 = object.prepareStatement(string);
            try {
                autoCloseable2.setInt(1, n);
                autoCloseable = autoCloseable2.executeQuery();
                try {
                    if (autoCloseable.next()) {
                        arrayList.add(this.extractUserSummary((ResultSet)autoCloseable));
                    }
                }
                finally {
                    if (autoCloseable != null) {
                        autoCloseable.close();
                    }
                }
            }
            finally {
                if (autoCloseable2 != null) {
                    autoCloseable2.close();
                }
            }
        }
        try {
            object = "SELECT u.* FROM group_members gm JOIN users u ON gm.user_id = u.user_id JOIN groups g ON gm.group_id = g.group_id WHERE gm.group_id = ? AND gm.is_admin = true AND gm.user_id != g.admin_id";
            autoCloseable2 = this.dbConnection.getConnection();
            try {
                autoCloseable = autoCloseable2.prepareStatement((String)object);
                try {
                    autoCloseable.setInt(1, n);
                    try (ResultSet resultSet = autoCloseable.executeQuery();){
                        while (resultSet.next()) {
                            arrayList.add(this.extractUserSummary(resultSet));
                        }
                    }
                }
                finally {
                    if (autoCloseable != null) {
                        autoCloseable.close();
                    }
                }
            }
            finally {
                if (autoCloseable2 != null) {
                    autoCloseable2.close();
                }
            }
        }
        catch (SQLException sQLException) {
            System.out.println("C\u1ed9t is_admin ch\u01b0a t\u1ed3n t\u1ea1i ho\u1eb7c l\u1ed7i: " + sQLException.getMessage());
        }
        return arrayList;
    }

    private User extractUserSummary(ResultSet resultSet) throws SQLException {
        User user = new User();
        user.setId(resultSet.getInt("user_id"));
        user.setUsername(resultSet.getString("username"));
        user.setFullName(resultSet.getString("full_name"));
        user.setEmail(resultSet.getString("email"));
        user.setStatus(resultSet.getString("status"));
        Timestamp timestamp = resultSet.getTimestamp("created_at");
        if (timestamp != null) {
            user.setCreatedAt(timestamp.toLocalDateTime());
        }
        return user;
    }

    public int countGroupAdmins(int n) throws SQLException {
        int n2 = 1;
        try {
            String string = "SELECT COUNT(*) as count FROM group_members gm JOIN groups g ON gm.group_id = g.group_id WHERE gm.group_id = ? AND gm.is_admin = true AND gm.user_id != g.admin_id";
            try (Connection connection = this.dbConnection.getConnection();
                 PreparedStatement preparedStatement = connection.prepareStatement(string);){
                preparedStatement.setInt(1, n);
                try (ResultSet resultSet = preparedStatement.executeQuery();){
                    if (resultSet.next()) {
                        n2 += resultSet.getInt("count");
                    }
                }
            }
        }
        catch (SQLException sQLException) {
            System.out.println("C\u1ed9t is_admin ch\u01b0a t\u1ed3n t\u1ea1i ho\u1eb7c l\u1ed7i: " + sQLException.getMessage());
        }
        return n2;
    }
}

