/*
 * Decompiled with CFR 0.152.
 */
package admin.service;

import admin.service.DatabaseConnection;
import admin.socket.FriendStats;
import admin.socket.User;
import admin.socket.UserActivity;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class StatisticsDAO {
    private DatabaseConnection dbConnection = DatabaseConnection.getInstance();

    public List<FriendStats> getFriendStatistics() throws SQLException {
        ArrayList<FriendStats> arrayList = new ArrayList<FriendStats>();
        String string = "SELECT u.user_id, u.username, u.full_name, u.created_at, COUNT(DISTINCT CASE WHEN f.user_id = u.user_id THEN f.friend_id                     WHEN f.friend_id = u.user_id THEN f.user_id END) as friend_count FROM users u LEFT JOIN friends f ON (u.user_id = f.user_id OR u.user_id = f.friend_id) AND f.status = 'accepted' GROUP BY u.user_id, u.username, u.full_name, u.created_at ORDER BY friend_count DESC";
        try (Object object = this.dbConnection.getConnection();
             Statement statement = object.createStatement();
             ResultSet object2 = statement.executeQuery(string);){
            while (object2.next()) {
                FriendStats friendStats = new FriendStats();
                friendStats.setUserId(object2.getInt("user_id"));
                friendStats.setUsername(object2.getString("username"));
                friendStats.setFullName(object2.getString("full_name"));
                friendStats.setFriendCount(object2.getInt("friend_count"));
                friendStats.setFriendsOfFriendsCount(0);
                Timestamp timestamp = object2.getTimestamp("created_at");
                if (timestamp != null) {
                    friendStats.setCreatedAt(timestamp.toLocalDateTime());
                }
                arrayList.add(friendStats);
            }
        }
        object = this.countAllFriendsOfFriends();
        for (FriendStats friendStats : arrayList) {
            friendStats.setFriendsOfFriendsCount(object.getOrDefault(friendStats.getUserId(), 0));
        }
        return arrayList;
    }

    private Map<Integer, Integer> countAllFriendsOfFriends() throws SQLException {
        HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>();
        String string = "WITH direct_friends AS (  SELECT user_id as uid, friend_id as fid FROM friends WHERE status = 'accepted'   UNION   SELECT friend_id as uid, user_id as fid FROM friends WHERE status = 'accepted' ), friends_of_friends AS (  SELECT df1.uid as user_id, df2.fid as fof_id   FROM direct_friends df1   JOIN direct_friends df2 ON df1.fid = df2.uid   WHERE df2.fid != df1.uid ) SELECT user_id, COUNT(DISTINCT fof_id) as fof_count FROM friends_of_friends GROUP BY user_id";
        try (Connection connection = this.dbConnection.getConnection();
             Statement statement = connection.createStatement();
             ResultSet resultSet = statement.executeQuery(string);){
            while (resultSet.next()) {
                hashMap.put(resultSet.getInt("user_id"), resultSet.getInt("fof_count"));
            }
        }
        return hashMap;
    }

    /*
     * WARNING - void declaration
     */
    public List<FriendStats> getFriendStatisticsWithFilters(String string, String string2, Integer n, String string3) throws SQLException {
        Map<Integer, Integer> map;
        ArrayList<FriendStats> arrayList = new ArrayList<FriendStats>();
        StringBuilder stringBuilder = new StringBuilder("SELECT u.user_id, u.username, u.full_name, u.created_at, COUNT(DISTINCT CASE WHEN f.user_id = u.user_id THEN f.friend_id                     WHEN f.friend_id = u.user_id THEN f.user_id END) as friend_count FROM users u LEFT JOIN friends f ON (u.user_id = f.user_id OR u.user_id = f.friend_id) AND f.status = 'accepted' WHERE 1=1");
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        if (string != null && !string.trim().isEmpty()) {
            stringBuilder.append(" AND (u.username LIKE ? OR u.full_name LIKE ?)");
            map = "%" + string.trim() + "%";
            arrayList2.add(map);
            arrayList2.add(map);
        }
        stringBuilder.append(" GROUP BY u.user_id, u.username, u.full_name, u.created_at");
        if (string2 != null && !"T\u1ea5t c\u1ea3".equals(string2) && n != null) {
            void var10_17;
            map = " HAVING COUNT(DISTINCT CASE WHEN f.user_id = u.user_id THEN f.friend_id WHEN f.friend_id = u.user_id THEN f.user_id END)";
            String string4 = string2;
            int n2 = -1;
            switch (string4.hashCode()) {
                case 61: {
                    if (!string4.equals("=")) break;
                    boolean object = false;
                    break;
                }
                case 62: {
                    if (!string4.equals(">")) break;
                    boolean bl = true;
                    break;
                }
                case 60: {
                    if (!string4.equals("<")) break;
                    int n3 = 2;
                }
            }
            switch (var10_17) {
                case 0: {
                    stringBuilder.append((String)((Object)map) + " = ?");
                    arrayList2.add(n);
                    break;
                }
                case 1: {
                    stringBuilder.append((String)((Object)map) + " > ?");
                    arrayList2.add(n);
                    break;
                }
                case 2: {
                    stringBuilder.append((String)((Object)map) + " < ?");
                    arrayList2.add(n);
                }
            }
        }
        if (string3 != null) {
            switch (string3) {
                case "S\u1eafp x\u1ebfp theo t\u00ean (A-Z)": {
                    stringBuilder.append(" ORDER BY u.full_name ASC");
                    break;
                }
                case "S\u1eafp x\u1ebfp theo t\u00ean (Z-A)": {
                    stringBuilder.append(" ORDER BY u.full_name DESC");
                    break;
                }
                case "S\u1eafp x\u1ebfp theo th\u1eddi gian t\u1ea1o (M\u1edbi nh\u1ea5t)": {
                    stringBuilder.append(" ORDER BY u.created_at DESC");
                    break;
                }
                default: {
                    stringBuilder.append(" ORDER BY u.created_at ASC");
                    break;
                }
            }
        } else {
            stringBuilder.append(" ORDER BY u.created_at DESC");
        }
        map = this.dbConnection.getConnection();
        try (PreparedStatement preparedStatement = map.prepareStatement(stringBuilder.toString());){
            void var10_19;
            boolean bl = false;
            while (var10_19 < arrayList2.size()) {
                preparedStatement.setObject((int)(var10_19 + true), arrayList2.get((int)var10_19));
                ++var10_19;
            }
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                while (resultSet.next()) {
                    FriendStats friendStats = new FriendStats();
                    friendStats.setUserId(resultSet.getInt("user_id"));
                    friendStats.setUsername(resultSet.getString("username"));
                    friendStats.setFullName(resultSet.getString("full_name"));
                    friendStats.setFriendCount(resultSet.getInt("friend_count"));
                    friendStats.setFriendsOfFriendsCount(0);
                    Timestamp timestamp = resultSet.getTimestamp("created_at");
                    if (timestamp != null) {
                        friendStats.setCreatedAt(timestamp.toLocalDateTime());
                    }
                    arrayList.add(friendStats);
                }
            }
        }
        finally {
            if (map != null) {
                map.close();
            }
        }
        map = this.countAllFriendsOfFriends();
        for (FriendStats friendStats : arrayList) {
            friendStats.setFriendsOfFriendsCount(map.getOrDefault(friendStats.getUserId(), 0));
        }
        return arrayList;
    }

    public List<UserActivity> getActiveUsers(int n) throws SQLException {
        ArrayList<UserActivity> arrayList = new ArrayList<UserActivity>();
        String string = "SELECT u.user_id, u.username, u.full_name, COUNT(DISTINCT pm.message_id) + COUNT(DISTINCT gm.message_id) as activity_count, GREATEST(MAX(pm.created_at), MAX(gm.sent_time)) as last_activity FROM users u LEFT JOIN messages pm ON (u.user_id = pm.sender_id) AND pm.created_at >= NOW() - (? * INTERVAL '1 day') LEFT JOIN group_messages gm ON (u.user_id = gm.sender_id) AND gm.sent_time >= NOW() - (? * INTERVAL '1 day') WHERE u.status = 'active' GROUP BY u.user_id, u.username, u.full_name HAVING COUNT(DISTINCT pm.message_id) + COUNT(DISTINCT gm.message_id) > 0 ORDER BY activity_count DESC";
        try (Connection connection = this.dbConnection.getConnection();
             PreparedStatement preparedStatement = connection.prepareStatement(string);){
            preparedStatement.setInt(1, n);
            preparedStatement.setInt(2, n);
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                while (resultSet.next()) {
                    UserActivity userActivity = new UserActivity();
                    userActivity.setUserId(resultSet.getInt("user_id"));
                    userActivity.setUsername(resultSet.getString("username"));
                    userActivity.setFullName(resultSet.getString("full_name"));
                    userActivity.setActivityCount(resultSet.getInt("activity_count"));
                    Timestamp timestamp = resultSet.getTimestamp("last_activity");
                    if (timestamp != null) {
                        userActivity.setLastActivity(timestamp.toLocalDateTime());
                    }
                    arrayList.add(userActivity);
                }
            }
        }
        return arrayList;
    }

    public List<Map<String, Object>> getNewUsers(int n) throws SQLException {
        ArrayList<Map<String, Object>> arrayList = new ArrayList<Map<String, Object>>();
        String string = "SELECT user_id, username, full_name, email, status, created_at FROM users WHERE created_at >= NOW() - (? * INTERVAL '1 day') ORDER BY created_at DESC";
        try (Connection connection = this.dbConnection.getConnection();
             PreparedStatement preparedStatement = connection.prepareStatement(string);){
            preparedStatement.setInt(1, n);
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                while (resultSet.next()) {
                    HashMap<String, Object> hashMap = new HashMap<String, Object>();
                    int n2 = resultSet.getInt("user_id");
                    String string2 = resultSet.getString("username");
                    String string3 = resultSet.getString("full_name");
                    hashMap.put("id", n2);
                    hashMap.put("user_id", n2);
                    hashMap.put("username", string2);
                    hashMap.put("fullName", string3);
                    hashMap.put("full_name", string3);
                    hashMap.put("email", resultSet.getString("email"));
                    hashMap.put("status", resultSet.getString("status"));
                    Timestamp timestamp = resultSet.getTimestamp("created_at");
                    if (timestamp != null) {
                        LocalDateTime localDateTime = timestamp.toLocalDateTime();
                        hashMap.put("createdAt", localDateTime);
                        hashMap.put("created_at", localDateTime);
                    }
                    arrayList.add(hashMap);
                }
            }
        }
        return arrayList;
    }

    public List<User> getNewUsers(LocalDate localDate, LocalDate comparable, String string, String string2, String string3) throws SQLException {
        Comparable<StringBuilder> comparable2;
        boolean bl;
        ArrayList<User> arrayList = new ArrayList<User>();
        boolean bl2 = bl = localDate == null && comparable == null;
        if (!(bl || localDate != null && comparable != null)) {
            return arrayList;
        }
        if (!bl && comparable.isBefore(localDate)) {
            comparable2 = localDate;
            localDate = comparable;
            comparable = comparable2;
        }
        comparable2 = new StringBuilder("SELECT user_id, username, full_name, email, status, created_at FROM users");
        if (!bl) {
            ((StringBuilder)comparable2).append(" WHERE DATE(created_at) BETWEEN ? AND ?");
        } else {
            ((StringBuilder)comparable2).append(" WHERE 1=1");
        }
        if (string != null && !string.isEmpty()) {
            ((StringBuilder)comparable2).append(" AND (username LIKE ? OR full_name LIKE ?)");
        }
        if (string2 != null && !string2.isEmpty()) {
            ((StringBuilder)comparable2).append(" AND email LIKE ?");
        }
        ((StringBuilder)comparable2).append(this.resolveSortClause(string3));
        try (Connection connection = this.dbConnection.getConnection();
             PreparedStatement preparedStatement = connection.prepareStatement(((StringBuilder)comparable2).toString());){
            Object object;
            int n = 1;
            if (!bl) {
                preparedStatement.setDate(n++, Date.valueOf(localDate));
                preparedStatement.setDate(n++, Date.valueOf(comparable));
            }
            if (string != null && !string.isEmpty()) {
                object = "%" + string + "%";
                preparedStatement.setString(n++, (String)object);
                preparedStatement.setString(n++, (String)object);
            }
            if (string2 != null && !string2.isEmpty()) {
                object = "%" + string2 + "%";
                preparedStatement.setString(n++, (String)object);
            }
            object = preparedStatement.executeQuery();
            try {
                while (object.next()) {
                    arrayList.add(this.extractUserSummary((ResultSet)object));
                }
            }
            finally {
                if (object != null) {
                    object.close();
                }
            }
        }
        return arrayList;
    }

    private String resolveSortClause(String string) {
        if (string == null) {
            return " ORDER BY created_at DESC";
        }
        switch (string) {
            case "S\u1eafp x\u1ebfp theo th\u1eddi gian (C\u0169 nh\u1ea5t)": {
                return " ORDER BY created_at ASC";
            }
            case "S\u1eafp x\u1ebfp theo t\u00ean (A-Z)": {
                return " ORDER BY full_name ASC";
            }
            case "S\u1eafp x\u1ebfp theo t\u00ean (Z-A)": {
                return " ORDER BY full_name DESC";
            }
            case "S\u1eafp x\u1ebfp theo email (A-Z)": {
                return " ORDER BY email ASC";
            }
            case "S\u1eafp x\u1ebfp theo email (Z-A)": {
                return " ORDER BY email DESC";
            }
        }
        return " ORDER BY created_at DESC";
    }

    private User extractUserSummary(ResultSet resultSet) throws SQLException {
        User user = new User();
        user.setId(resultSet.getInt("user_id"));
        user.setUsername(resultSet.getString("username"));
        user.setFullName(resultSet.getString("full_name"));
        user.setEmail(resultSet.getString("email"));
        user.setStatus(resultSet.getString("status"));
        Timestamp timestamp = resultSet.getTimestamp("created_at");
        if (timestamp != null) {
            user.setCreatedAt(timestamp.toLocalDateTime());
        }
        return user;
    }

    public List<User> getFriendsOfUser(int n) throws SQLException {
        ArrayList<User> arrayList = new ArrayList<User>();
        String string = "SELECT u.user_id, u.username, u.full_name, u.email, u.status, u.created_at FROM friends f JOIN users u ON u.user_id = CASE WHEN f.user_id = ? THEN f.friend_id ELSE f.user_id END WHERE (f.user_id = ? OR f.friend_id = ?) AND f.status = 'accepted' ORDER BY u.full_name";
        try (Connection connection = this.dbConnection.getConnection();
             PreparedStatement preparedStatement = connection.prepareStatement(string);){
            preparedStatement.setInt(1, n);
            preparedStatement.setInt(2, n);
            preparedStatement.setInt(3, n);
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                while (resultSet.next()) {
                    arrayList.add(this.extractUserSummary(resultSet));
                }
            }
        }
        return arrayList;
    }

    public Map<String, Integer> getUserGrowthByMonth() throws SQLException {
        int n = LocalDate.now().getYear();
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        int[] nArray = this.getUserGrowthByMonth(n);
        for (int i = 1; i <= 12; ++i) {
            hashMap.put(n + "-" + String.format("%02d", i), nArray[i - 1]);
        }
        return hashMap;
    }

    public int[] getUserGrowthByMonth(int n) throws SQLException {
        int[] nArray = new int[12];
        String string = "SELECT EXTRACT(MONTH FROM created_at) as month, COUNT(*) as cnt FROM users WHERE EXTRACT(YEAR FROM created_at) = ? GROUP BY EXTRACT(MONTH FROM created_at) ORDER BY month";
        try (Connection connection = this.dbConnection.getConnection();
             PreparedStatement preparedStatement = connection.prepareStatement(string);){
            preparedStatement.setInt(1, n);
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                while (resultSet.next()) {
                    int n2 = resultSet.getInt("month") - 1;
                    if (n2 < 0 || n2 >= 12) continue;
                    nArray[n2] = resultSet.getInt("cnt");
                }
            }
        }
        return nArray;
    }

    public List<UserActivity> getUserActivities(LocalDate localDate, LocalDate object, String string, String string2) throws SQLException {
        ArrayList<UserActivity> arrayList = new ArrayList<UserActivity>();
        if (localDate == null || object == null) {
            return arrayList;
        }
        if (((LocalDate)object).isBefore(localDate)) {
            Object object2 = localDate;
            localDate = object;
            object = object2;
        }
        switch (string) {
            case "Chat v\u1edbi ng\u01b0\u1eddi": {
                return this.queryUserActivity("messages", "created_at", "sender_id", localDate, (LocalDate)object, string2, "Chat v\u1edbi ng\u01b0\u1eddi");
            }
            case "Chat nh\u00f3m": {
                return this.queryUserActivity("group_messages", "sent_time", "sender_id", localDate, (LocalDate)object, string2, "Chat nh\u00f3m");
            }
        }
        return this.queryUserActivity("login_history", "login_time", "user_id", localDate, (LocalDate)object, string2, "M\u1edf \u1ee9ng d\u1ee5ng");
    }

    private List<UserActivity> queryUserActivity(String string, String string2, String string3, LocalDate localDate, LocalDate localDate2, String string4, String string5) throws SQLException {
        return this.queryUserActivityWithFilters(string, string2, string3, localDate, localDate2, string4, string5, null, null, null);
    }

    private List<UserActivity> queryUserActivityWithFilters(String string, String string2, String string3, LocalDate localDate, LocalDate localDate2, String string4, String string5, String string6, Integer n, String string7) throws SQLException {
        Object object;
        ArrayList<UserActivity> arrayList = new ArrayList<UserActivity>();
        StringBuilder stringBuilder = new StringBuilder("SELECT u.user_id, u.username, u.full_name, u.created_at, COUNT(*) as activity_count, MAX(t." + string2 + ") as last_activity FROM " + string + " t JOIN users u ON u.user_id = t." + string3 + " WHERE t." + string2 + " >= ? AND t." + string2 + " < ?");
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        arrayList2.add(Timestamp.valueOf(localDate.atStartOfDay()));
        arrayList2.add(Timestamp.valueOf(localDate2.plusDays(1L).atStartOfDay()));
        if (string4 != null && !string4.isEmpty()) {
            stringBuilder.append(" AND (u.username LIKE ? OR u.full_name LIKE ?)");
            object = "%" + string4 + "%";
            arrayList2.add(object);
            arrayList2.add(object);
        }
        stringBuilder.append(" GROUP BY u.user_id, u.username, u.full_name, u.created_at");
        if (string6 != null && !"T\u1ea5t c\u1ea3".equals(string6) && n != null) {
            switch (string6) {
                case "=": {
                    stringBuilder.append(" HAVING COUNT(*) = ?");
                    arrayList2.add(n);
                    break;
                }
                case ">": {
                    stringBuilder.append(" HAVING COUNT(*) > ?");
                    arrayList2.add(n);
                    break;
                }
                case "<": {
                    stringBuilder.append(" HAVING COUNT(*) < ?");
                    arrayList2.add(n);
                }
            }
        }
        if (string7 != null) {
            switch (string7) {
                case "S\u1eafp x\u1ebfp theo t\u00ean (A-Z)": {
                    stringBuilder.append(" ORDER BY u.full_name ASC");
                    break;
                }
                case "S\u1eafp x\u1ebfp theo t\u00ean (Z-A)": {
                    stringBuilder.append(" ORDER BY u.full_name DESC");
                    break;
                }
                case "S\u1eafp x\u1ebfp theo th\u1eddi gian t\u1ea1o (M\u1edbi nh\u1ea5t)": {
                    stringBuilder.append(" ORDER BY u.created_at DESC");
                    break;
                }
                case "S\u1eafp x\u1ebfp theo th\u1eddi gian t\u1ea1o (C\u0169 nh\u1ea5t)": {
                    stringBuilder.append(" ORDER BY u.created_at ASC");
                    break;
                }
                default: {
                    stringBuilder.append(" ORDER BY activity_count DESC");
                    break;
                }
            }
        } else {
            stringBuilder.append(" ORDER BY activity_count DESC");
        }
        object = this.dbConnection.getConnection();
        try (PreparedStatement preparedStatement = object.prepareStatement(stringBuilder.toString());){
            for (int i = 0; i < arrayList2.size(); ++i) {
                preparedStatement.setObject(i + 1, arrayList2.get(i));
            }
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                while (resultSet.next()) {
                    Timestamp timestamp;
                    UserActivity userActivity = new UserActivity();
                    userActivity.setUserId(resultSet.getInt("user_id"));
                    userActivity.setUsername(resultSet.getString("username"));
                    userActivity.setFullName(resultSet.getString("full_name"));
                    userActivity.setActivityType(string5);
                    userActivity.setActivityCount(resultSet.getInt("activity_count"));
                    Timestamp timestamp2 = resultSet.getTimestamp("last_activity");
                    if (timestamp2 != null) {
                        userActivity.setLastActivity(timestamp2.toLocalDateTime());
                    }
                    if ((timestamp = resultSet.getTimestamp("created_at")) != null) {
                        userActivity.setCreatedAt(timestamp.toLocalDateTime());
                    }
                    arrayList.add(userActivity);
                }
            }
        }
        finally {
            if (object != null) {
                object.close();
            }
        }
        return arrayList;
    }

    public List<UserActivity> getUserActivitiesWithFilters(LocalDate localDate, LocalDate object, String string, String string2, String string3, Integer n, String string4) throws SQLException {
        if (localDate == null || object == null) {
            return new ArrayList<UserActivity>();
        }
        if (((LocalDate)object).isBefore(localDate)) {
            Object object2 = localDate;
            localDate = object;
            object = object2;
        }
        switch (string) {
            case "Chat v\u1edbi ng\u01b0\u1eddi": {
                return this.queryUserActivityWithFilters("messages", "created_at", "sender_id", localDate, (LocalDate)object, string2, "Chat v\u1edbi ng\u01b0\u1eddi", string3, n, string4);
            }
            case "Chat nh\u00f3m": {
                return this.queryUserActivityWithFilters("group_messages", "sent_time", "sender_id", localDate, (LocalDate)object, string2, "Chat nh\u00f3m", string3, n, string4);
            }
        }
        return this.queryUserActivityWithFilters("login_history", "login_time", "user_id", localDate, (LocalDate)object, string2, "M\u1edf \u1ee9ng d\u1ee5ng", string3, n, string4);
    }

    public int[] getMonthlyActiveUsers(int n) throws SQLException {
        int[] nArray = new int[12];
        String string = "SELECT EXTRACT(MONTH FROM lh.login_time) as month, COUNT(*) as cnt FROM login_history lh WHERE EXTRACT(YEAR FROM lh.login_time) = ? GROUP BY EXTRACT(MONTH FROM lh.login_time) ORDER BY month";
        try (Connection connection = this.dbConnection.getConnection();
             PreparedStatement preparedStatement = connection.prepareStatement(string);){
            preparedStatement.setInt(1, n);
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                while (resultSet.next()) {
                    int n2 = resultSet.getInt("month") - 1;
                    if (n2 < 0 || n2 >= 12) continue;
                    nArray[n2] = resultSet.getInt("cnt");
                }
            }
        }
        return nArray;
    }

    public int getTotalActiveUsersInYear(int n) throws SQLException {
        String string = "SELECT COUNT(*) as total FROM login_history WHERE EXTRACT(YEAR FROM login_time) = ?";
        try (Connection connection = this.dbConnection.getConnection();
             PreparedStatement preparedStatement = connection.prepareStatement(string);){
            preparedStatement.setInt(1, n);
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                if (resultSet.next()) {
                    int n2 = resultSet.getInt("total");
                    return n2;
                }
            }
        }
        return 0;
    }

    public Map<String, Integer> getLoginCountByDay(int n) throws SQLException {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        String string = "SELECT DATE(login_time) as login_date, COUNT(*) as count FROM login_history WHERE login_time >= NOW() - (? * INTERVAL '1 day') GROUP BY login_date ORDER BY login_date";
        try (Connection connection = this.dbConnection.getConnection();
             PreparedStatement preparedStatement = connection.prepareStatement(string);){
            preparedStatement.setInt(1, n);
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                while (resultSet.next()) {
                    hashMap.put(resultSet.getString("login_date"), resultSet.getInt("count"));
                }
            }
        }
        return hashMap;
    }

    public Map<String, Integer> getSystemOverview() throws SQLException {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        try (Connection connection = this.dbConnection.getConnection();
             Statement statement = connection.createStatement();){
            ResultSet resultSet = statement.executeQuery("SELECT COUNT(*) FROM users");
            if (resultSet.next()) {
                hashMap.put("totalUsers", resultSet.getInt(1));
            }
            if ((resultSet = statement.executeQuery("SELECT COUNT(*) FROM users WHERE status = 'active'")).next()) {
                hashMap.put("activeUsers", resultSet.getInt(1));
            }
            if ((resultSet = statement.executeQuery("SELECT COUNT(*) FROM groups")).next()) {
                hashMap.put("totalGroups", resultSet.getInt(1));
            }
            if ((resultSet = statement.executeQuery("SELECT COUNT(*) FROM messages")).next()) {
                hashMap.put("totalMessages", resultSet.getInt(1));
            }
            if ((resultSet = statement.executeQuery("SELECT COUNT(*) FROM spam_reports WHERE status = 'pending'")).next()) {
                hashMap.put("pendingReports", resultSet.getInt(1));
            }
        }
        return hashMap;
    }

    public List<UserActivity> getUserActivitiesComprehensive(LocalDate localDate, LocalDate comparable, String string, String string2, Integer n, String string3) throws SQLException {
        Object object;
        Comparable<StringBuilder> comparable2;
        boolean bl;
        ArrayList<UserActivity> arrayList = new ArrayList<UserActivity>();
        boolean bl2 = bl = localDate == null && comparable == null;
        if (!(bl || localDate != null && comparable != null)) {
            return arrayList;
        }
        if (!bl && ((LocalDate)comparable).isBefore(localDate)) {
            comparable2 = localDate;
            localDate = comparable;
            comparable = comparable2;
        }
        comparable2 = new StringBuilder("WITH user_logins AS (  SELECT user_id, COUNT(*) as login_count, MAX(login_time) as last_login   FROM login_history   GROUP BY user_id), user_private_chats AS (  SELECT sender_id as user_id, COUNT(DISTINCT receiver_id) as chat_count   FROM messages   GROUP BY sender_id), user_group_chats AS (  SELECT sender_id as user_id, COUNT(DISTINCT group_id) as group_count   FROM group_messages   GROUP BY sender_id) SELECT u.user_id, u.username, u.full_name, u.created_at,   COALESCE(ul.login_count, 0) as login_count,   COALESCE(ul.last_login, u.created_at) as last_activity,   COALESCE(upc.chat_count, 0) as private_chat_count,   COALESCE(ugc.group_count, 0) as group_chat_count,   (COALESCE(ul.login_count, 0) + COALESCE(upc.chat_count, 0) + COALESCE(ugc.group_count, 0)) as total_count FROM users u LEFT JOIN user_logins ul ON u.user_id = ul.user_id LEFT JOIN user_private_chats upc ON u.user_id = upc.user_id LEFT JOIN user_group_chats ugc ON u.user_id = ugc.user_id WHERE 1=1");
        if (!bl) {
            ((StringBuilder)comparable2).append(" AND u.created_at >= ? AND u.created_at < ?");
        }
        ((StringBuilder)comparable2).append(" AND (ul.login_count IS NOT NULL OR upc.chat_count IS NOT NULL OR ugc.group_count IS NOT NULL)");
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        if (!bl) {
            object = Timestamp.valueOf(localDate.atStartOfDay());
            Timestamp timestamp = Timestamp.valueOf(((LocalDate)comparable).plusDays(1L).atStartOfDay());
            arrayList2.add(object);
            arrayList2.add(timestamp);
        }
        if (string != null && !string.isEmpty()) {
            ((StringBuilder)comparable2).append(" AND (u.username LIKE ? OR u.full_name LIKE ?)");
            object = "%" + string + "%";
            arrayList2.add(object);
            arrayList2.add(object);
        }
        if (string2 != null && !"T\u1ea5t c\u1ea3".equals(string2) && n != null) {
            switch (string2) {
                case "=": {
                    ((StringBuilder)comparable2).append(" AND COALESCE(ul.login_count, 0) = ?");
                    arrayList2.add(n);
                    break;
                }
                case ">": {
                    ((StringBuilder)comparable2).append(" AND COALESCE(ul.login_count, 0) > ?");
                    arrayList2.add(n);
                    break;
                }
                case "<": {
                    ((StringBuilder)comparable2).append(" AND COALESCE(ul.login_count, 0) < ?");
                    arrayList2.add(n);
                }
            }
        }
        if (string3 != null) {
            switch (string3) {
                case "S\u1eafp x\u1ebfp theo t\u00ean (A-Z)": {
                    ((StringBuilder)comparable2).append(" ORDER BY u.full_name ASC");
                    break;
                }
                case "S\u1eafp x\u1ebfp theo t\u00ean (Z-A)": {
                    ((StringBuilder)comparable2).append(" ORDER BY u.full_name DESC");
                    break;
                }
                case "S\u1eafp x\u1ebfp theo th\u1eddi gian t\u1ea1o (M\u1edbi nh\u1ea5t)": {
                    ((StringBuilder)comparable2).append(" ORDER BY u.created_at DESC");
                    break;
                }
                case "S\u1eafp x\u1ebfp theo th\u1eddi gian t\u1ea1o (C\u0169 nh\u1ea5t)": {
                    ((StringBuilder)comparable2).append(" ORDER BY u.created_at ASC");
                    break;
                }
                default: {
                    ((StringBuilder)comparable2).append(" ORDER BY total_count DESC");
                    break;
                }
            }
        } else {
            ((StringBuilder)comparable2).append(" ORDER BY total_count DESC");
        }
        object = this.dbConnection.getConnection();
        try (PreparedStatement preparedStatement = object.prepareStatement(((StringBuilder)comparable2).toString());){
            for (int i = 0; i < arrayList2.size(); ++i) {
                preparedStatement.setObject(i + 1, arrayList2.get(i));
            }
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                while (resultSet.next()) {
                    Timestamp timestamp;
                    UserActivity userActivity = new UserActivity();
                    userActivity.setUserId(resultSet.getInt("user_id"));
                    userActivity.setUsername(resultSet.getString("username"));
                    userActivity.setFullName(resultSet.getString("full_name"));
                    userActivity.setLoginCount(resultSet.getInt("login_count"));
                    userActivity.setPrivateChatCount(resultSet.getInt("private_chat_count"));
                    userActivity.setGroupChatCount(resultSet.getInt("group_chat_count"));
                    userActivity.setActivityCount(resultSet.getInt("total_count"));
                    Timestamp timestamp2 = resultSet.getTimestamp("last_activity");
                    if (timestamp2 != null) {
                        userActivity.setLastActivity(timestamp2.toLocalDateTime());
                    }
                    if ((timestamp = resultSet.getTimestamp("created_at")) != null) {
                        userActivity.setCreatedAt(timestamp.toLocalDateTime());
                    }
                    arrayList.add(userActivity);
                }
            }
        }
        finally {
            if (object != null) {
                object.close();
            }
        }
        return arrayList;
    }

    public int getTotalUsers() throws SQLException {
        String string = "SELECT COUNT(*) as total FROM users WHERE status IN ('active', 'locked')";
        try (Connection connection = this.dbConnection.getConnection();
             Statement statement = connection.createStatement();
             ResultSet resultSet = statement.executeQuery(string);){
            if (resultSet.next()) {
                int n = resultSet.getInt("total");
                return n;
            }
        }
        return 0;
    }

    public int getOnlineUsers() throws SQLException {
        String string = "SELECT COUNT(*) as total FROM users WHERE status = 'active' AND last_login IS NOT NULL AND last_login >= NOW() - INTERVAL '5 minutes'";
        try (Connection connection = this.dbConnection.getConnection();
             Statement statement = connection.createStatement();
             ResultSet resultSet = statement.executeQuery(string);){
            if (resultSet.next()) {
                int n = resultSet.getInt("total");
                return n;
            }
        }
        return 0;
    }

    public int getTotalGroups() throws SQLException {
        String string = "SELECT COUNT(*) as total FROM groups";
        try (Connection connection = this.dbConnection.getConnection();
             Statement statement = connection.createStatement();
             ResultSet resultSet = statement.executeQuery(string);){
            if (resultSet.next()) {
                int n = resultSet.getInt("total");
                return n;
            }
        }
        return 0;
    }

    public int getTotalMessages() throws SQLException {
        String string = "SELECT (SELECT COUNT(*) FROM messages) + (SELECT COUNT(*) FROM group_messages) as total";
        try (Connection connection = this.dbConnection.getConnection();
             Statement statement = connection.createStatement();
             ResultSet resultSet = statement.executeQuery(string);){
            if (resultSet.next()) {
                int n = resultSet.getInt("total");
                return n;
            }
        }
        return 0;
    }

    public int getTotalSpamReports() throws SQLException {
        String string = "SELECT COUNT(*) FROM spam_reports";
        try (Connection connection = this.dbConnection.getConnection();
             Statement statement = connection.createStatement();
             ResultSet resultSet = statement.executeQuery(string);){
            if (resultSet.next()) {
                int n = resultSet.getInt(1);
                return n;
            }
        }
        return 0;
    }
}

