/*
 * Decompiled with CFR 0.152.
 */
package admin.service;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Properties;

public class SupabaseRestClient {
    private static SupabaseRestClient instance;
    private String supabaseUrl;
    private String apiKey;
    private String serviceKey;
    private static final int CONNECT_TIMEOUT = 10000;
    private static final int READ_TIMEOUT = 15000;

    private SupabaseRestClient() {
        this.loadConfig();
    }

    private void loadConfig() {
        try {
            Properties properties = new Properties();
            try (FileInputStream fileInputStream = new FileInputStream("release/config.properties");){
                properties.load(fileInputStream);
                this.supabaseUrl = properties.getProperty("supabase.url");
                this.apiKey = properties.getProperty("supabase.anon.key");
                this.serviceKey = properties.getProperty("supabase.service.key");
                System.out.println("[Supabase REST] Config loaded");
                System.out.println("[Supabase REST] URL: " + this.supabaseUrl);
            }
        }
        catch (IOException iOException) {
            System.err.println("[Supabase REST] Failed to load config: " + iOException.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SupabaseRestClient getInstance() {
        if (instance != null) return instance;
        Class<SupabaseRestClient> clazz = SupabaseRestClient.class;
        synchronized (SupabaseRestClient.class) {
            if (instance != null) return instance;
            instance = new SupabaseRestClient();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public String get(String string, String string2) throws IOException {
        String string3 = this.supabaseUrl + "/rest/v1/" + string;
        if (string2 != null && !string2.isEmpty()) {
            string3 = string3 + "?" + string2;
        }
        System.out.println("[Supabase REST] GET: " + string3);
        URL uRL = new URL(string3);
        HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
        httpURLConnection.setConnectTimeout(10000);
        httpURLConnection.setReadTimeout(15000);
        httpURLConnection.setRequestMethod("GET");
        httpURLConnection.setRequestProperty("apikey", this.apiKey);
        httpURLConnection.setRequestProperty("Authorization", "Bearer " + this.apiKey);
        httpURLConnection.setRequestProperty("Content-Type", "application/json");
        int n = httpURLConnection.getResponseCode();
        System.out.println("[Supabase REST] Response code: " + n);
        if (n == 200) {
            return this.readResponse(httpURLConnection);
        }
        String string4 = this.readError(httpURLConnection);
        throw new IOException("GET failed [" + n + "]: " + string4);
    }

    public String post(String string, String string2) throws IOException {
        Object object;
        String string3 = this.supabaseUrl + "/rest/v1/" + string;
        System.out.println("[Supabase REST] POST: " + string3);
        System.out.println("[Supabase REST] Body: " + string2);
        URL uRL = new URL(string3);
        HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
        httpURLConnection.setConnectTimeout(10000);
        httpURLConnection.setReadTimeout(15000);
        httpURLConnection.setRequestMethod("POST");
        httpURLConnection.setRequestProperty("apikey", this.apiKey);
        httpURLConnection.setRequestProperty("Authorization", "Bearer " + this.apiKey);
        httpURLConnection.setRequestProperty("Content-Type", "application/json");
        httpURLConnection.setRequestProperty("Prefer", "return=representation");
        httpURLConnection.setDoOutput(true);
        try (OutputStream outputStream = httpURLConnection.getOutputStream();){
            object = string2.getBytes(StandardCharsets.UTF_8);
            outputStream.write((byte[])object, 0, ((byte[])object).length);
        }
        int n = httpURLConnection.getResponseCode();
        System.out.println("[Supabase REST] Response code: " + n);
        if (n == 201 || n == 200) {
            return this.readResponse(httpURLConnection);
        }
        object = this.readError(httpURLConnection);
        throw new IOException("POST failed [" + n + "]: " + (String)object);
    }

    public String patch(String string, String string2, String string3) throws IOException {
        Object object;
        String string4 = this.supabaseUrl + "/rest/v1/" + string + "?" + string2;
        System.out.println("[Supabase REST] PATCH: " + string4);
        URL uRL = new URL(string4);
        HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
        httpURLConnection.setConnectTimeout(10000);
        httpURLConnection.setReadTimeout(15000);
        httpURLConnection.setRequestMethod("PATCH");
        httpURLConnection.setRequestProperty("apikey", this.apiKey);
        httpURLConnection.setRequestProperty("Authorization", "Bearer " + this.apiKey);
        httpURLConnection.setRequestProperty("Content-Type", "application/json");
        httpURLConnection.setRequestProperty("Prefer", "return=representation");
        httpURLConnection.setDoOutput(true);
        try (OutputStream outputStream = httpURLConnection.getOutputStream();){
            object = string3.getBytes(StandardCharsets.UTF_8);
            outputStream.write((byte[])object, 0, ((byte[])object).length);
        }
        int n = httpURLConnection.getResponseCode();
        System.out.println("[Supabase REST] Response code: " + n);
        if (n == 200 || n == 204) {
            return this.readResponse(httpURLConnection);
        }
        object = this.readError(httpURLConnection);
        throw new IOException("PATCH failed [" + n + "]: " + (String)object);
    }

    public String delete(String string, String string2) throws IOException {
        String string3 = this.supabaseUrl + "/rest/v1/" + string + "?" + string2;
        System.out.println("[Supabase REST] DELETE: " + string3);
        URL uRL = new URL(string3);
        HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
        httpURLConnection.setConnectTimeout(10000);
        httpURLConnection.setReadTimeout(15000);
        httpURLConnection.setRequestMethod("DELETE");
        httpURLConnection.setRequestProperty("apikey", this.apiKey);
        httpURLConnection.setRequestProperty("Authorization", "Bearer " + this.apiKey);
        int n = httpURLConnection.getResponseCode();
        System.out.println("[Supabase REST] Response code: " + n);
        if (n == 204 || n == 200) {
            return "Delete successful";
        }
        String string4 = this.readError(httpURLConnection);
        throw new IOException("DELETE failed [" + n + "]: " + string4);
    }

    private String readResponse(HttpURLConnection httpURLConnection) throws IOException {
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(httpURLConnection.getInputStream(), StandardCharsets.UTF_8));){
            String string;
            StringBuilder stringBuilder = new StringBuilder();
            while ((string = bufferedReader.readLine()) != null) {
                stringBuilder.append(string);
            }
            String string2 = stringBuilder.toString();
            return string2;
        }
    }

    private String readError(HttpURLConnection httpURLConnection) {
        String string;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(httpURLConnection.getErrorStream(), StandardCharsets.UTF_8));
        try {
            String string2;
            StringBuilder stringBuilder = new StringBuilder();
            while ((string2 = bufferedReader.readLine()) != null) {
                stringBuilder.append(string2);
            }
            string = stringBuilder.toString();
        }
        catch (Throwable throwable) {
            try {
                try {
                    bufferedReader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception exception) {
                return "Unable to read error: " + exception.getMessage();
            }
        }
        bufferedReader.close();
        return string;
    }

    public boolean testConnection() {
        System.out.println("[Supabase REST] Testing connection...");
        try {
            String string = this.get("users", "select=id&limit=1");
            System.out.println("[Supabase REST] Response: " + string);
            System.out.println("[Supabase REST] \u2705 Connection successful!");
            return true;
        }
        catch (IOException iOException) {
            System.err.println("[Supabase REST] \u274c Connection failed: " + iOException.getMessage());
            if (iOException.getMessage().contains("404")) {
                System.err.println("\n\u26a0\ufe0f  Table 'users' not found!");
                System.err.println("You need to create tables in Supabase:");
                System.err.println("1. Go to Supabase Dashboard \u2192 SQL Editor");
                System.err.println("2. Run script: script/database/create_database_supabase.sql\n");
            } else if (iOException.getMessage().contains("401") || iOException.getMessage().contains("403")) {
                System.err.println("\n\u26a0\ufe0f  Authentication failed!");
                System.err.println("Check your API keys in config.properties\n");
            } else if (iOException.getMessage().contains("timeout")) {
                System.err.println("\n\u26a0\ufe0f  Connection timeout!");
                System.err.println("Check your network connection\n");
            }
            return false;
        }
    }

    public boolean pingSupabase() {
        System.out.println("[Supabase REST] Pinging Supabase...");
        try {
            URL uRL = new URL(this.supabaseUrl + "/rest/v1/");
            HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
            httpURLConnection.setConnectTimeout(5000);
            httpURLConnection.setReadTimeout(5000);
            httpURLConnection.setRequestMethod("GET");
            httpURLConnection.setRequestProperty("apikey", this.apiKey);
            int n = httpURLConnection.getResponseCode();
            System.out.println("[Supabase REST] Ping response: " + n);
            if (n == 200 || n == 404 || n == 401) {
                System.out.println("[Supabase REST] \u2705 Supabase is reachable!");
                return true;
            }
            return false;
        }
        catch (Exception exception) {
            System.err.println("[Supabase REST] \u274c Ping failed: " + exception.getMessage());
            return false;
        }
    }

    public String getSupabaseUrl() {
        return this.supabaseUrl;
    }

    public static void main(String[] stringArray) {
        System.out.println("========================================");
        System.out.println("Testing Supabase REST API Connection...");
        System.out.println("========================================\n");
        SupabaseRestClient supabaseRestClient = SupabaseRestClient.getInstance();
        System.out.println("Test 1: Ping Supabase URL");
        System.out.println("----------------------------------------");
        boolean bl = supabaseRestClient.pingSupabase();
        System.out.println();
        if (!bl) {
            System.out.println("\u274c Cannot reach Supabase!");
            System.out.println("Possible reasons:");
            System.out.println("  - No internet connection");
            System.out.println("  - Firewall blocking HTTPS");
            System.out.println("  - Wrong Supabase URL in config\n");
            System.out.println("========================================");
            return;
        }
        System.out.println("Test 2: Query 'users' table");
        System.out.println("----------------------------------------");
        boolean bl2 = supabaseRestClient.testConnection();
        System.out.println();
        if (bl2) {
            System.out.println("========================================");
            System.out.println("\u2705 ALL TESTS PASSED!");
            System.out.println("Supabase REST API is ready to use!");
            System.out.println("========================================");
        } else {
            System.out.println("========================================");
            System.out.println("\u26a0\ufe0f  Supabase reachable but tables not setup");
            System.out.println("Please create tables in SQL Editor");
            System.out.println("========================================");
        }
    }
}

