/*
 * Decompiled with CFR 0.152.
 */
package user.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Image;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.accessibility.Accessible;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.Timer;
import javax.swing.border.EmptyBorder;
import user.gui.AddFriendDialog;
import user.gui.UIHelper;
import user.gui.ZaloMainFrame;
import user.service.UserService;
import user.socket.Message;

public class ChatListPanel
extends JPanel {
    private static final Color BG_COLOR = new Color(250, 250, 250);
    private static final Color SEARCH_BG = Color.WHITE;
    private static final Color ITEM_HOVER = new Color(240, 240, 240);
    private static final Color PRIMARY_COLOR = new Color(0, 132, 255);
    private static final int PANEL_WIDTH = 350;
    private ZaloMainFrame mainFrame;
    private UserService userService;
    private JTextField searchField;
    private JPanel chatListContainer;
    private Map<String, ChatItemPanel> chatItems = new HashMap<String, ChatItemPanel>();
    private Timer refreshTimer;
    private List<String> onlineUsers = new ArrayList<String>();

    public ChatListPanel(ZaloMainFrame zaloMainFrame) {
        this.mainFrame = zaloMainFrame;
        this.userService = new UserService();
        this.initializeUI();
        this.loadRecentChats();
        this.startAutoRefresh();
    }

    private void initializeUI() {
        this.setBackground(BG_COLOR);
        this.setPreferredSize(new Dimension(350, 0));
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel(new BorderLayout(8, 0));
        jPanel.setBackground(Color.WHITE);
        jPanel.setBorder(BorderFactory.createEmptyBorder(12, 12, 12, 12));
        JPanel jPanel2 = this.createSearchBar();
        JPanel jPanel3 = new JPanel(new FlowLayout(2, 5, 0));
        jPanel3.setOpaque(false);
        JButton jButton = this.createIconButton("icons/paper-plane.png", "T\u00ecm ki\u1ebfm to\u00e0n b\u1ed9 l\u1ecbch s\u1eed", 24);
        jButton.addActionListener(actionEvent -> this.showGlobalSearchDialog());
        JButton jButton2 = this.createIconButton("icons/add-friend.png", "Th\u00eam b\u1ea1n", 24);
        jButton2.addActionListener(actionEvent -> {
            AddFriendDialog addFriendDialog = new AddFriendDialog(this.mainFrame, this.mainFrame.getUsername());
            addFriendDialog.setVisible(true);
        });
        jPanel3.add(jButton);
        jPanel3.add(jButton2);
        jPanel.add((Component)jPanel2, "Center");
        jPanel.add((Component)jPanel3, "East");
        JPanel jPanel4 = new JPanel(new FlowLayout(0, 15, 10));
        jPanel4.setBackground(Color.WHITE);
        jPanel4.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, new Color(230, 230, 230)));
        final JLabel jLabel = this.createTab("T\u1ea5t c\u1ea3", true);
        final JLabel jLabel2 = this.createTab("Online", false);
        jLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                jLabel.setFont(new Font(UIHelper.getDefaultFontName(), 1, 14));
                jLabel.setForeground(new Color(0, 132, 255));
                jLabel.setBorder(BorderFactory.createMatteBorder(0, 0, 2, 0, new Color(0, 132, 255)));
                jLabel2.setFont(new Font(UIHelper.getDefaultFontName(), 0, 14));
                jLabel2.setForeground(new Color(100, 100, 100));
                jLabel2.setBorder(null);
                ChatListPanel.this.loadRecentChats();
            }
        });
        jLabel2.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                jLabel2.setFont(new Font(UIHelper.getDefaultFontName(), 1, 14));
                jLabel2.setForeground(new Color(0, 132, 255));
                jLabel2.setBorder(BorderFactory.createMatteBorder(0, 0, 2, 0, new Color(0, 132, 255)));
                jLabel.setFont(new Font(UIHelper.getDefaultFontName(), 0, 14));
                jLabel.setForeground(new Color(100, 100, 100));
                jLabel.setBorder(null);
                ChatListPanel.this.loadOnlineFriends();
            }
        });
        jPanel4.add(jLabel);
        jPanel4.add(jLabel2);
        this.chatListContainer = new JPanel();
        this.chatListContainer.setLayout(new BoxLayout(this.chatListContainer, 1));
        this.chatListContainer.setBackground(BG_COLOR);
        JScrollPane jScrollPane = new JScrollPane(this.chatListContainer);
        jScrollPane.setBorder(null);
        jScrollPane.getVerticalScrollBar().setUnitIncrement(16);
        JPanel jPanel5 = new JPanel(new BorderLayout());
        jPanel5.add((Component)jPanel, "North");
        jPanel5.add((Component)jPanel4, "South");
        this.add((Component)jPanel5, "North");
        this.add((Component)jScrollPane, "Center");
    }

    private JPanel createSearchBar() {
        Accessible accessible;
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBackground(Color.WHITE);
        jPanel.setPreferredSize(new Dimension(240, 38));
        this.searchField = new JTextField();
        this.searchField.setFont(new Font(UIHelper.getDefaultFontName(), 0, 14));
        this.searchField.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(new Color(220, 220, 220), 1, true), BorderFactory.createEmptyBorder(8, 38, 8, 10)));
        this.searchField.setBackground(new Color(245, 245, 245));
        this.searchField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 10) {
                    ChatListPanel.this.performSearch();
                }
            }
        });
        JPanel jPanel2 = new JPanel(new FlowLayout(0, 10, 8));
        jPanel2.setOpaque(false);
        jPanel2.setCursor(new Cursor(12));
        jPanel2.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                ChatListPanel.this.performSearch();
            }
        });
        try {
            accessible = new ImageIcon("icons/search.png");
            Image image = ((ImageIcon)accessible).getImage().getScaledInstance(18, 18, 4);
            JLabel jLabel = new JLabel(new ImageIcon(image));
            jPanel2.add(jLabel);
        }
        catch (Exception exception) {
            JLabel jLabel = new JLabel("Tim");
            jLabel.setFont(new Font(UIHelper.getDefaultFontName(), 1, 12));
            jLabel.setForeground(new Color(150, 150, 150));
            jPanel2.add(jLabel);
        }
        accessible = new JLayeredPane();
        ((JComponent)((Object)accessible)).setPreferredSize(new Dimension(240, 38));
        this.searchField.setBounds(0, 0, 240, 38);
        jPanel2.setBounds(0, 0, 40, 38);
        ((Container)((Object)accessible)).add((Component)this.searchField, JLayeredPane.DEFAULT_LAYER);
        ((Container)((Object)accessible)).add((Component)jPanel2, JLayeredPane.PALETTE_LAYER);
        jPanel.add((Component)((Object)accessible), "Center");
        return jPanel;
    }

    private void performSearch() {
        String string = this.searchField.getText().trim();
        if (string.isEmpty()) {
            this.loadRecentChats();
        } else {
            this.filterChatList(string);
        }
    }

    private JButton createIconButton(String string, String string2, int n) {
        final JButton jButton = new JButton();
        try {
            ImageIcon imageIcon = new ImageIcon(string);
            Image image = imageIcon.getImage().getScaledInstance(n, n, 4);
            jButton.setIcon(new ImageIcon(image));
        }
        catch (Exception exception) {
            jButton.setText("?");
            jButton.setFont(new Font(UIHelper.getDefaultFontName(), 1, 14));
            jButton.setForeground(new Color(0, 132, 255));
            System.err.println("\u26a0\ufe0f Kh\u00f4ng t\u00ecm th\u1ea5y icon: " + string);
        }
        jButton.setPreferredSize(new Dimension(36, 36));
        jButton.setBackground(Color.WHITE);
        jButton.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
        jButton.setFocusPainted(false);
        jButton.setCursor(new Cursor(12));
        jButton.setToolTipText(string2);
        jButton.setContentAreaFilled(false);
        jButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                jButton.setContentAreaFilled(true);
                jButton.setBackground(new Color(240, 242, 245));
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                jButton.setContentAreaFilled(false);
            }
        });
        return jButton;
    }

    private JLabel createTab(String string, boolean bl) {
        JLabel jLabel = new JLabel(string);
        jLabel.setFont(new Font(UIHelper.getDefaultFontName(), bl ? 1 : 0, 14));
        jLabel.setForeground(bl ? new Color(0, 132, 255) : new Color(100, 100, 100));
        jLabel.setCursor(new Cursor(12));
        if (bl) {
            jLabel.setBorder(BorderFactory.createMatteBorder(0, 0, 2, 0, new Color(0, 132, 255)));
        }
        return jLabel;
    }

    private void loadRecentChats() {
        this.chatListContainer.removeAll();
        this.chatItems.clear();
        SwingWorker<List<Map<String, Object>>, Void> swingWorker = new SwingWorker<List<Map<String, Object>>, Void>(){

            @Override
            protected List<Map<String, Object>> doInBackground() {
                return ChatListPanel.this.userService.getRecentChats(ChatListPanel.this.mainFrame.getUsername());
            }

            @Override
            protected void done() {
                try {
                    List list = (List)this.get();
                    if (list == null || list.isEmpty()) {
                        ChatListPanel.this.showEmptyMessage();
                    } else {
                        for (Map map : list) {
                            final String string = (String)map.get("friend_username");
                            String string2 = (String)map.get("friend_name");
                            String string3 = string2 != null && !string2.isEmpty() ? string2 : string;
                            String string4 = (String)map.get("last_message");
                            Timestamp timestamp = (Timestamp)map.get("sent_at");
                            int n = (Integer)map.get("unread_count");
                            String string5 = ChatListPanel.this.formatTime(timestamp);
                            boolean bl = false;
                            if (ChatListPanel.this.mainFrame.getSocketClient() != null && ChatListPanel.this.mainFrame.getSocketClient().isConnected()) {
                                ChatListPanel.this.onlineUsers = ChatListPanel.this.mainFrame.getSocketClient().getOnlineUsers();
                                bl = ChatListPanel.this.onlineUsers.contains(string);
                            }
                            ChatItemPanel chatItemPanel = new ChatItemPanel(string, string3, string4, string5, bl, n, timestamp);
                            chatItemPanel.addMouseListener(new MouseAdapter(){

                                @Override
                                public void mouseClicked(MouseEvent mouseEvent) {
                                    ChatListPanel.this.mainFrame.openChat(string);
                                }
                            });
                            ChatListPanel.this.chatListContainer.add(chatItemPanel);
                            ChatListPanel.this.chatItems.put(string, chatItemPanel);
                        }
                    }
                    ChatListPanel.this.chatListContainer.revalidate();
                    ChatListPanel.this.chatListContainer.repaint();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    ChatListPanel.this.showEmptyMessage();
                }
            }
        };
        swingWorker.execute();
    }

    private String formatTime(Timestamp timestamp) {
        if (timestamp == null) {
            return "";
        }
        Date date = new Date();
        Date date2 = new Date(timestamp.getTime());
        long l = date.getTime() - date2.getTime();
        long l2 = l / 60000L;
        long l3 = l / 3600000L;
        long l4 = l / 86400000L;
        if (l2 < 1L) {
            return "V\u1eeba xong";
        }
        if (l2 < 60L) {
            return l2 + " ph\u00fat";
        }
        if (l3 < 24L) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("HH:mm");
            return simpleDateFormat.format(date2);
        }
        if (l4 < 7L) {
            if (l4 == 1L) {
                return "H\u00f4m qua";
            }
            return l4 + " ng\u00e0y";
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd/MM");
        return simpleDateFormat.format(date2);
    }

    private void showEmptyMessage() {
        JLabel jLabel = new JLabel("<html><center><b>[Chat]</b><br><br>Ch\u01b0a c\u00f3 cu\u1ed9c tr\u00f2 chuy\u1ec7n n\u00e0o<br>H\u00e3y th\u00eam b\u1ea1n b\u00e8 v\u00e0 b\u1eaft \u0111\u1ea7u chat!</center></html>");
        jLabel.setFont(new Font(UIHelper.getDefaultFontName(), 0, 14));
        jLabel.setForeground(new Color(150, 150, 150));
        jLabel.setAlignmentX(0.5f);
        jLabel.setBorder(new EmptyBorder(80, 20, 80, 20));
        this.chatListContainer.add(jLabel);
        this.chatListContainer.revalidate();
        this.chatListContainer.repaint();
    }

    private void addChatItem(final String string, String string2, String string3, String string4, boolean bl, int n) {
        if (this.mainFrame.getSocketClient() != null && this.mainFrame.getSocketClient().isConnected()) {
            this.onlineUsers = this.mainFrame.getSocketClient().getOnlineUsers();
            bl = this.onlineUsers.contains(string);
        }
        ChatItemPanel chatItemPanel = new ChatItemPanel(string, string2, string3, string4, bl, n, null);
        chatItemPanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                ChatListPanel.this.mainFrame.openChat(string);
            }
        });
        this.chatListContainer.add(chatItemPanel);
        this.chatItems.put(string, chatItemPanel);
    }

    public void updateChatList(Message message) {
        final String string = message.getSender();
        String string2 = message.getContent();
        if (string != null && string.equals(this.mainFrame.getUsername())) {
            return;
        }
        Message.MessageType messageType = message.getType();
        if (messageType != Message.MessageType.PRIVATE_MESSAGE && messageType != Message.MessageType.BROADCAST) {
            return;
        }
        SwingUtilities.invokeLater(() -> {
            Timestamp timestamp = new Timestamp(System.currentTimeMillis());
            boolean bl = this.onlineUsers.contains(string);
            if (!this.chatItems.containsKey(string)) {
                ChatItemPanel chatItemPanel = new ChatItemPanel(string, string, string2, "V\u1eeba xong", bl, 1, timestamp);
                chatItemPanel.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mouseClicked(MouseEvent mouseEvent) {
                        ChatListPanel.this.mainFrame.openChat(string);
                    }
                });
                this.chatListContainer.add((Component)chatItemPanel, 0);
                this.chatItems.put(string, chatItemPanel);
            } else {
                JPanel jPanel = this.chatItems.get(string);
                if (jPanel instanceof ChatItemPanel) {
                    ChatItemPanel chatItemPanel = (ChatItemPanel)jPanel;
                    chatItemPanel.updateLastMessage(string2, timestamp);
                    this.chatListContainer.remove(chatItemPanel);
                    this.chatListContainer.add((Component)chatItemPanel, 0);
                }
            }
            this.chatListContainer.revalidate();
            this.chatListContainer.repaint();
        });
    }

    public void refreshChatList() {
        System.out.println("\ud83d\udd04 Refreshing chat list...");
        this.loadRecentChats();
    }

    private void startAutoRefresh() {
        this.refreshTimer = new Timer(60000, actionEvent -> {
            System.out.println("\u23f0 Auto-refresh chat list (1 ph\u00fat)");
            this.refreshTimeLabels();
        });
        this.refreshTimer.start();
    }

    private void refreshTimeLabels() {
        for (ChatItemPanel chatItemPanel : this.chatItems.values()) {
            chatItemPanel.refreshTimeLabel();
        }
    }

    public void updateOnlineUsers(List<String> list) {
        this.onlineUsers = new ArrayList<String>(list);
        for (Map.Entry<String, ChatItemPanel> entry : this.chatItems.entrySet()) {
            String string = entry.getKey();
            ChatItemPanel chatItemPanel = entry.getValue();
            boolean bl = this.onlineUsers.contains(string);
            chatItemPanel.setOnlineStatus(bl);
        }
    }

    private void filterChatList(final String string) {
        if (string == null || string.isEmpty()) {
            this.loadRecentChats();
            return;
        }
        this.chatListContainer.removeAll();
        this.chatItems.clear();
        SwingWorker<List<Map<String, Object>>, Void> swingWorker = new SwingWorker<List<Map<String, Object>>, Void>(){

            @Override
            protected List<Map<String, Object>> doInBackground() {
                return ChatListPanel.this.userService.searchFriends(ChatListPanel.this.mainFrame.getUsername(), string);
            }

            @Override
            protected void done() {
                try {
                    List list = (List)this.get();
                    if (list == null || list.isEmpty()) {
                        JLabel jLabel = new JLabel("<html><center><b>[?]</b><br><br>Kh\u00f4ng t\u00ecm th\u1ea5y k\u1ebft qu\u1ea3<br>cho '" + string + "'</center></html>");
                        jLabel.setFont(new Font(UIHelper.getDefaultFontName(), 0, 14));
                        jLabel.setForeground(new Color(150, 150, 150));
                        jLabel.setAlignmentX(0.5f);
                        jLabel.setBorder(new EmptyBorder(80, 20, 80, 20));
                        ChatListPanel.this.chatListContainer.add(jLabel);
                    } else {
                        for (Map map : list) {
                            final String string4 = (String)map.get("username");
                            String string2 = (String)map.get("full_name");
                            String string3 = string2 != null && !string2.isEmpty() ? string2 : string4;
                            boolean bl = ChatListPanel.this.onlineUsers.contains(string4);
                            ChatItemPanel chatItemPanel = new ChatItemPanel(string4, string3, "B\u1eaft \u0111\u1ea7u tr\u00f2 chuy\u1ec7n", "", bl, 0, null);
                            chatItemPanel.addMouseListener(new MouseAdapter(){

                                @Override
                                public void mouseClicked(MouseEvent mouseEvent) {
                                    ChatListPanel.this.mainFrame.openChat(string4);
                                }
                            });
                            ChatListPanel.this.chatListContainer.add(chatItemPanel);
                            ChatListPanel.this.chatItems.put(string4, chatItemPanel);
                        }
                    }
                    ChatListPanel.this.chatListContainer.revalidate();
                    ChatListPanel.this.chatListContainer.repaint();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        };
        swingWorker.execute();
    }

    private void loadOnlineFriends() {
        this.chatListContainer.removeAll();
        this.chatItems.clear();
        SwingWorker<List<Map<String, Object>>, Void> swingWorker = new SwingWorker<List<Map<String, Object>>, Void>(){

            @Override
            protected List<Map<String, Object>> doInBackground() {
                List<Map<String, Object>> list = ChatListPanel.this.userService.getRecentChats(ChatListPanel.this.mainFrame.getUsername());
                ArrayList<Map<String, Object>> arrayList = new ArrayList<Map<String, Object>>();
                List<Object> list2 = new ArrayList();
                if (ChatListPanel.this.mainFrame.getSocketClient() != null && ChatListPanel.this.mainFrame.getSocketClient().isConnected()) {
                    list2 = ChatListPanel.this.mainFrame.getSocketClient().getOnlineUsers();
                }
                for (Map<String, Object> map : list) {
                    String string = (String)map.get("friend_username");
                    if (!list2.contains(string)) continue;
                    arrayList.add(map);
                }
                return arrayList;
            }

            @Override
            protected void done() {
                try {
                    List list = (List)this.get();
                    if (list == null || list.isEmpty()) {
                        JLabel jLabel = new JLabel("<html><center>\ud83d\udca4<br><br>Kh\u00f4ng c\u00f3 b\u1ea1n b\u00e8 n\u00e0o \u0111ang online<br>H\u00e3y quay l\u1ea1i sau!</center></html>");
                        jLabel.setFont(new Font(UIHelper.getDefaultFontName(), 0, 14));
                        jLabel.setForeground(new Color(150, 150, 150));
                        jLabel.setAlignmentX(0.5f);
                        jLabel.setBorder(new EmptyBorder(80, 20, 80, 20));
                        ChatListPanel.this.chatListContainer.add(jLabel);
                    } else {
                        for (Map map : list) {
                            final String string = (String)map.get("friend_username");
                            String string2 = (String)map.get("friend_name");
                            String string3 = string2 != null && !string2.isEmpty() ? string2 : string;
                            String string4 = (String)map.get("last_message");
                            Timestamp timestamp = (Timestamp)map.get("sent_at");
                            int n = (Integer)map.get("unread_count");
                            String string5 = ChatListPanel.this.formatTime(timestamp);
                            ChatItemPanel chatItemPanel = new ChatItemPanel(string, string3, string4, string5, true, n, timestamp);
                            chatItemPanel.addMouseListener(new MouseAdapter(){

                                @Override
                                public void mouseClicked(MouseEvent mouseEvent) {
                                    ChatListPanel.this.mainFrame.openChat(string);
                                }
                            });
                            ChatListPanel.this.chatListContainer.add(chatItemPanel);
                            ChatListPanel.this.chatItems.put(string, chatItemPanel);
                        }
                    }
                    ChatListPanel.this.chatListContainer.revalidate();
                    ChatListPanel.this.chatListContainer.repaint();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        };
        swingWorker.execute();
    }

    private void showGlobalSearchDialog() {
        final JDialog jDialog = new JDialog((Frame)SwingUtilities.getWindowAncestor(this), "T\u00ecm ki\u1ebfm to\u00e0n b\u1ed9 l\u1ecbch s\u1eed", true);
        jDialog.setSize(700, 600);
        jDialog.setLocationRelativeTo(this);
        jDialog.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBackground(PRIMARY_COLOR);
        jPanel.setBorder(BorderFactory.createEmptyBorder(15, 20, 15, 20));
        JLabel jLabel = new JLabel("T\u00ecm ki\u1ebfm trong to\u00e0n b\u1ed9 l\u1ecbch s\u1eed chat");
        jLabel.setFont(new Font(UIHelper.getDefaultFontName(), 1, 16));
        jLabel.setForeground(Color.WHITE);
        jPanel.add((Component)jLabel, "West");
        JPanel jPanel2 = new JPanel(new BorderLayout(10, 10));
        jPanel2.setBackground(Color.WHITE);
        jPanel2.setBorder(BorderFactory.createEmptyBorder(15, 20, 10, 20));
        JTextField jTextField = new JTextField();
        jTextField.setFont(new Font(UIHelper.getDefaultFontName(), 0, 14));
        jTextField.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(new Color(200, 200, 200)), BorderFactory.createEmptyBorder(10, 12, 10, 12)));
        jTextField.putClientProperty("JTextField.placeholderText", "Nh\u1eadp t\u1eeb kh\u00f3a t\u00ecm ki\u1ebfm...");
        final JButton jButton = new JButton("T\u00ecm ki\u1ebfm");
        jButton.setFont(new Font(UIHelper.getDefaultFontName(), 1, 14));
        jButton.setBackground(PRIMARY_COLOR);
        jButton.setForeground(Color.WHITE);
        jButton.setFocusPainted(false);
        jButton.setBorderPainted(false);
        jButton.setOpaque(true);
        jButton.setContentAreaFilled(true);
        jButton.setPreferredSize(new Dimension(110, 40));
        jButton.setCursor(new Cursor(12));
        JPanel jPanel3 = new JPanel(new BorderLayout(10, 0));
        jPanel3.setOpaque(false);
        jPanel3.add((Component)jTextField, "Center");
        jPanel3.add((Component)jButton, "East");
        jPanel2.add((Component)jPanel3, "North");
        final JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BoxLayout(jPanel4, 1));
        jPanel4.setBackground(Color.WHITE);
        JScrollPane jScrollPane = new JScrollPane(jPanel4);
        jScrollPane.setBorder(BorderFactory.createTitledBorder("K\u1ebft qu\u1ea3 t\u00ecm ki\u1ebfm"));
        jScrollPane.getVerticalScrollBar().setUnitIncrement(16);
        jPanel2.add((Component)jScrollPane, "Center");
        final JLabel jLabel2 = new JLabel("Nh\u1eadp t\u1eeb kh\u00f3a \u0111\u1ec3 t\u00ecm ki\u1ebfm trong to\u00e0n b\u1ed9 l\u1ecbch s\u1eed chat");
        jLabel2.setFont(new Font(UIHelper.getDefaultFontName(), 2, 12));
        jLabel2.setForeground(new Color(120, 120, 120));
        jLabel2.setBorder(BorderFactory.createEmptyBorder(10, 0, 0, 0));
        jPanel2.add((Component)jLabel2, "South");
        Runnable runnable = () -> {
            final String string = jTextField.getText().trim();
            if (string.isEmpty()) {
                JOptionPane.showMessageDialog(jDialog, "Vui l\u00f2ng nh\u1eadp t\u1eeb kh\u00f3a!", "Th\u00f4ng b\u00e1o", 2);
                return;
            }
            if (string.length() < 2) {
                JOptionPane.showMessageDialog(jDialog, "T\u1eeb kh\u00f3a ph\u1ea3i c\u00f3 \u00edt nh\u1ea5t 2 k\u00fd t\u1ef1!", "Th\u00f4ng b\u00e1o", 2);
                return;
            }
            jPanel4.removeAll();
            jButton.setEnabled(false);
            jButton.setText("\u0110ang t\u00ecm...");
            jLabel2.setText("\u0110ang t\u00ecm ki\u1ebfm...");
            SwingWorker<List<Map<String, Object>>, Void> swingWorker = new SwingWorker<List<Map<String, Object>>, Void>(){

                @Override
                protected List<Map<String, Object>> doInBackground() {
                    return ChatListPanel.this.userService.searchAllChatHistory(ChatListPanel.this.mainFrame.getUsername(), string);
                }

                @Override
                protected void done() {
                    try {
                        List list = (List)this.get();
                        if (list == null || list.isEmpty()) {
                            JLabel jLabel = new JLabel("<html><center>\ud83d\ude14 Kh\u00f4ng t\u00ecm th\u1ea5y k\u1ebft qu\u1ea3 n\u00e0o<br>Th\u1eed t\u1eeb kh\u00f3a kh\u00e1c</center></html>");
                            jLabel.setFont(new Font(UIHelper.getDefaultFontName(), 0, 14));
                            jLabel.setForeground(new Color(150, 150, 150));
                            jLabel.setAlignmentX(0.5f);
                            jLabel.setBorder(BorderFactory.createEmptyBorder(50, 20, 50, 20));
                            jPanel4.add(jLabel);
                            jLabel2.setText("Kh\u00f4ng t\u00ecm th\u1ea5y k\u1ebft qu\u1ea3 n\u00e0o");
                        } else {
                            jLabel2.setText("T\u00ecm th\u1ea5y " + list.size() + " tin nh\u1eafn");
                            for (Map map : list) {
                                String string8 = (String)map.get("friend_username");
                                String string2 = (String)map.get("sender_username");
                                String string3 = (String)map.get("content");
                                Timestamp timestamp = (Timestamp)map.get("sent_at");
                                int n = map.get("message_id") != null ? (Integer)map.get("message_id") : 0;
                                boolean bl = string2.equals(ChatListPanel.this.mainFrame.getUsername());
                                String string4 = string8;
                                final JPanel jPanel = new JPanel(new BorderLayout(10, 5));
                                jPanel.setBackground(Color.WHITE);
                                jPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, new Color(230, 230, 230)), BorderFactory.createEmptyBorder(12, 15, 12, 15)));
                                jPanel.setMaximumSize(new Dimension(Integer.MAX_VALUE, 90));
                                jPanel.setCursor(new Cursor(12));
                                String string5 = new SimpleDateFormat("dd/MM/yyyy HH:mm").format(timestamp);
                                JLabel jLabel = new JLabel("Chat v\u1edbi " + string4 + " - " + string5);
                                jLabel.setFont(new Font(UIHelper.getDefaultFontName(), 1, 12));
                                jLabel.setForeground(PRIMARY_COLOR);
                                String string6 = string3.length() > 100 ? string3.substring(0, 100) + "..." : string3;
                                JLabel jLabel22 = new JLabel("<html>" + ChatListPanel.this.highlightKeyword(string6, string) + "</html>");
                                jLabel22.setFont(new Font(UIHelper.getDefaultFontName(), 0, 13));
                                JLabel jLabel3 = new JLabel((String)(bl ? "B\u1ea1n \u0111\u00e3 g\u1eedi" : string2 + " \u0111\u00e3 g\u1eedi"));
                                jLabel3.setFont(new Font(UIHelper.getDefaultFontName(), 2, 11));
                                jLabel3.setForeground(new Color(120, 120, 120));
                                JLabel jLabel4 = new JLabel("\u2192");
                                jLabel4.setFont(new Font(UIHelper.getDefaultFontName(), 1, 18));
                                jLabel4.setForeground(PRIMARY_COLOR);
                                JPanel jPanel2 = new JPanel();
                                jPanel2.setLayout(new BoxLayout(jPanel2, 1));
                                jPanel2.setOpaque(false);
                                jPanel2.add(jLabel);
                                jPanel2.add(Box.createVerticalStrut(3));
                                jPanel2.add(jLabel22);
                                jPanel2.add(Box.createVerticalStrut(2));
                                jPanel2.add(jLabel3);
                                jPanel.add((Component)jPanel2, "Center");
                                jPanel.add((Component)jLabel4, "East");
                                final String string7 = string4;
                                final int n2 = n;
                                jPanel.addMouseListener(new MouseAdapter(){

                                    @Override
                                    public void mouseClicked(MouseEvent mouseEvent) {
                                        jDialog.dispose();
                                        ChatListPanel.this.mainFrame.openChat(string7);
                                        if (n2 > 0) {
                                            Timer timer = new Timer(500, actionEvent -> ChatListPanel.this.mainFrame.scrollToMessageInChat(n2));
                                            timer.setRepeats(false);
                                            timer.start();
                                        }
                                    }

                                    @Override
                                    public void mouseEntered(MouseEvent mouseEvent) {
                                        jPanel.setBackground(new Color(240, 245, 255));
                                    }

                                    @Override
                                    public void mouseExited(MouseEvent mouseEvent) {
                                        jPanel.setBackground(Color.WHITE);
                                    }
                                });
                                jPanel4.add(jPanel);
                            }
                        }
                        jPanel4.revalidate();
                        jPanel4.repaint();
                        jButton.setEnabled(true);
                        jButton.setText("T\u00ecm ki\u1ebfm");
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        jLabel2.setText("C\u00f3 l\u1ed7i x\u1ea3y ra!");
                        jButton.setEnabled(true);
                        jButton.setText("T\u00ecm ki\u1ebfm");
                    }
                }
            };
            swingWorker.execute();
        };
        jButton.addActionListener(actionEvent -> runnable.run());
        jTextField.addActionListener(actionEvent -> runnable.run());
        jDialog.add((Component)jPanel, "North");
        jDialog.add((Component)jPanel2, "Center");
        jDialog.setVisible(true);
    }

    private String highlightKeyword(String string, String string2) {
        if (string == null || string2 == null) {
            return string;
        }
        return string.replaceAll("(?i)(" + Pattern.quote(string2) + ")", "<span style='background-color: #FFFF00; font-weight: bold;'>$1</span>");
    }

    public void updateChatItemAfterDelete(String string) {
        Component[] componentArray;
        for (Component component : componentArray = this.chatListContainer.getComponents()) {
            if (!(component instanceof ChatItemPanel)) continue;
            ChatItemPanel chatItemPanel = (ChatItemPanel)component;
            if (!chatItemPanel.username.equals(string)) continue;
            chatItemPanel.updateLastMessage("", "");
            break;
        }
    }

    private class ChatItemPanel
    extends JPanel {
        private String username;
        private JLabel nameLabel;
        private JLabel messageLabel;
        private JLabel timeLabel;
        private JLabel badgeLabel;
        private JLabel onlineDot;
        private Timestamp sentAt;

        public ChatItemPanel(String string, String string2, String string3, String string4, boolean bl, int n, Timestamp timestamp) {
            Object object;
            Accessible accessible;
            this.username = string;
            this.sentAt = timestamp;
            this.setLayout(new BorderLayout(10, 5));
            this.setBackground(Color.WHITE);
            this.setBorder(new EmptyBorder(12, 15, 12, 15));
            this.setPreferredSize(new Dimension(350, 70));
            this.setMinimumSize(new Dimension(350, 70));
            this.setMaximumSize(new Dimension(Integer.MAX_VALUE, 70));
            this.setAlignmentX(0.0f);
            this.setCursor(new Cursor(12));
            JPanel jPanel = new JPanel(null);
            jPanel.setPreferredSize(new Dimension(50, 50));
            jPanel.setOpaque(false);
            JLabel jLabel = new JLabel();
            jLabel.setHorizontalAlignment(0);
            jLabel.setBounds(0, 0, 50, 50);
            try {
                accessible = new ImageIcon("icons/user.png");
                object = ((ImageIcon)accessible).getImage().getScaledInstance(40, 40, 4);
                jLabel.setIcon(new ImageIcon((Image)object));
            }
            catch (Exception exception) {
                jLabel.setText("[A]");
                jLabel.setFont(new Font(UIHelper.getDefaultFontName(), 1, 18));
                jLabel.setForeground(new Color(0, 132, 255));
            }
            jPanel.add(jLabel);
            this.onlineDot = new JLabel("\u25cf");
            this.onlineDot.setFont(new Font(UIHelper.getDefaultFontName(), 0, 12));
            this.onlineDot.setForeground(new Color(67, 220, 96));
            this.onlineDot.setBounds(35, 35, 15, 15);
            this.onlineDot.setVisible(bl);
            jPanel.add(this.onlineDot);
            accessible = new JPanel(new BorderLayout());
            ((JComponent)((Object)accessible)).setOpaque(false);
            object = new JPanel(new BorderLayout());
            ((JComponent)object).setOpaque(false);
            this.nameLabel = new JLabel(string2);
            this.nameLabel.setFont(new Font(UIHelper.getDefaultFontName(), 1, 15));
            this.timeLabel = new JLabel(string4);
            this.timeLabel.setFont(new Font(UIHelper.getDefaultFontName(), 0, 12));
            this.timeLabel.setForeground(new Color(120, 120, 120));
            ((Container)object).add((Component)this.nameLabel, "West");
            ((Container)object).add((Component)this.timeLabel, "East");
            JPanel jPanel2 = new JPanel(new BorderLayout());
            jPanel2.setOpaque(false);
            Object object2 = string3;
            if (object2 != null && ((String)object2).length() > 30) {
                object2 = ((String)object2).substring(0, 30) + "...";
            }
            this.messageLabel = new JLabel((String)object2);
            this.messageLabel.setFont(new Font(UIHelper.getDefaultFontName(), 0, 13));
            this.messageLabel.setForeground(new Color(100, 100, 100));
            if (n > 0) {
                this.badgeLabel = new JLabel(String.valueOf(n));
                this.badgeLabel.setFont(new Font(UIHelper.getDefaultFontName(), 1, 11));
                this.badgeLabel.setForeground(Color.WHITE);
                this.badgeLabel.setBackground(new Color(255, 59, 48));
                this.badgeLabel.setOpaque(true);
                this.badgeLabel.setHorizontalAlignment(0);
                this.badgeLabel.setBorder(BorderFactory.createEmptyBorder(2, 6, 2, 6));
                jPanel2.add((Component)this.badgeLabel, "East");
            }
            jPanel2.add((Component)this.messageLabel, "Center");
            ((Container)((Object)accessible)).add((Component)object, "North");
            ((Container)((Object)accessible)).add(jPanel2, "Center");
            this.add((Component)jPanel, "West");
            this.add((Component)((Object)accessible), "Center");
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent mouseEvent) {
                    ChatItemPanel.this.setBackground(ITEM_HOVER);
                }

                @Override
                public void mouseExited(MouseEvent mouseEvent) {
                    ChatItemPanel.this.setBackground(Color.WHITE);
                }
            });
        }

        public void updateLastMessage(String string, String string2) {
            Object object = string;
            if (object != null && ((String)object).length() > 30) {
                object = ((String)object).substring(0, 30) + "...";
            }
            this.messageLabel.setText((String)object);
            this.timeLabel.setText(string2);
        }

        public void updateLastMessage(String string, Timestamp timestamp) {
            this.sentAt = timestamp;
            Object object = string;
            if (object != null && ((String)object).length() > 30) {
                object = ((String)object).substring(0, 30) + "...";
            }
            this.messageLabel.setText((String)object);
            this.timeLabel.setText(ChatListPanel.this.formatTime(timestamp));
        }

        public void refreshTimeLabel() {
            if (this.sentAt != null) {
                this.timeLabel.setText(ChatListPanel.this.formatTime(this.sentAt));
            }
        }

        public void setOnlineStatus(boolean bl) {
            if (this.onlineDot != null) {
                this.onlineDot.setVisible(bl);
            }
        }
    }
}

