/*
 * Decompiled with CFR 0.152.
 */
package user.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import user.gui.LoginFrame;
import user.gui.UIHelper;
import user.service.UserService;

public class ResetPasswordFrame
extends JFrame {
    private static final Color PRIMARY_COLOR = new Color(0, 132, 255);
    private static final Color PRIMARY_DARK = new Color(0, 102, 204);
    private static final Color BACKGROUND_COLOR = new Color(245, 247, 250);
    private static final Color TEXT_COLOR = new Color(51, 51, 51);
    private static final Color PLACEHOLDER_COLOR = new Color(153, 153, 153);
    private String email;
    private String temporaryPassword;
    private JPasswordField tempPasswordField;
    private JPasswordField newPasswordField;
    private JPasswordField confirmPasswordField;
    private JButton resetButton;
    private JLabel titleLabel;
    private JLabel emailLabel;

    public ResetPasswordFrame(String string, String string2) {
        this.email = string;
        this.temporaryPassword = string2;
        this.initializeComponents();
        this.setupLayout();
        this.applyModernStyle();
    }

    private void initializeComponents() {
        this.setTitle("\u0110\u1eb7t l\u1ea1i m\u1eadt kh\u1ea9u - InstantChat");
        this.setDefaultCloseOperation(2);
        this.setSize(450, 550);
        this.setLocationRelativeTo(null);
        this.setResizable(false);
        this.getContentPane().setBackground(BACKGROUND_COLOR);
        this.titleLabel = new JLabel("\ud83d\udd10 \u0110\u1eb7t l\u1ea1i m\u1eadt kh\u1ea9u", 0);
        this.titleLabel.setFont(new Font(UIHelper.getDefaultFontName(), 1, 28));
        this.titleLabel.setForeground(PRIMARY_COLOR);
        this.emailLabel = new JLabel("Email: " + this.email, 0);
        this.emailLabel.setFont(new Font(UIHelper.getDefaultFontName(), 0, 13));
        this.emailLabel.setForeground(PLACEHOLDER_COLOR);
        this.tempPasswordField = this.createStyledPasswordField("M\u1eadt kh\u1ea9u t\u1ea1m t\u1eeb email");
        this.newPasswordField = this.createStyledPasswordField("M\u1eadt kh\u1ea9u m\u1edbi");
        this.confirmPasswordField = this.createStyledPasswordField("X\u00e1c nh\u1eadn m\u1eadt kh\u1ea9u m\u1edbi");
        this.resetButton = this.createPrimaryButton("C\u1eacP NH\u1eacT M\u1eacT KH\u1ea8U");
        this.resetButton.addActionListener(actionEvent -> this.handleResetPassword());
    }

    private void setupLayout() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 40, 10, 40);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(40, 40, 10, 40);
        this.add((Component)this.titleLabel, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(0, 40, 30, 40);
        this.add((Component)this.emailLabel, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(10, 40, 20, 40);
        this.add((Component)this.createInfoPanel(), gridBagConstraints);
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(10, 40, 10, 40);
        this.add((Component)this.createLabeledField("M\u1eadt kh\u1ea9u t\u1ea1m t\u1eeb email:", this.tempPasswordField), gridBagConstraints);
        gridBagConstraints.gridy = 4;
        this.add((Component)this.createLabeledField("M\u1eadt kh\u1ea9u m\u1edbi:", this.newPasswordField), gridBagConstraints);
        gridBagConstraints.gridy = 5;
        this.add((Component)this.createLabeledField("X\u00e1c nh\u1eadn m\u1eadt kh\u1ea9u m\u1edbi:", this.confirmPasswordField), gridBagConstraints);
        gridBagConstraints.gridy = 6;
        gridBagConstraints.insets = new Insets(20, 40, 40, 40);
        this.add((Component)this.resetButton, gridBagConstraints);
    }

    private JPanel createInfoPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.setBackground(new Color(255, 248, 220));
        jPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(new Color(255, 193, 7), 1), BorderFactory.createEmptyBorder(10, 15, 10, 15)));
        JLabel jLabel = new JLabel("\u2139\ufe0f H\u01b0\u1edbng d\u1eabn:");
        jLabel.setFont(new Font(UIHelper.getDefaultFontName(), 1, 12));
        jLabel.setAlignmentX(0.0f);
        JLabel jLabel2 = new JLabel("1. Ki\u1ec3m tra email \u0111\u1ec3 l\u1ea5y m\u1eadt kh\u1ea9u t\u1ea1m th\u1eddi");
        jLabel2.setFont(new Font(UIHelper.getDefaultFontName(), 0, 11));
        jLabel2.setAlignmentX(0.0f);
        JLabel jLabel3 = new JLabel("2. Nh\u1eadp m\u1eadt kh\u1ea9u t\u1ea1m v\u00e0o \u00f4 \u0111\u1ea7u ti\u00ean");
        jLabel3.setFont(new Font(UIHelper.getDefaultFontName(), 0, 11));
        jLabel3.setAlignmentX(0.0f);
        JLabel jLabel4 = new JLabel("3. Nh\u1eadp m\u1eadt kh\u1ea9u m\u1edbi v\u00e0 x\u00e1c nh\u1eadn");
        jLabel4.setFont(new Font(UIHelper.getDefaultFontName(), 0, 11));
        jLabel4.setAlignmentX(0.0f);
        jPanel.add(jLabel);
        jPanel.add(Box.createVerticalStrut(5));
        jPanel.add(jLabel2);
        jPanel.add(jLabel3);
        jPanel.add(jLabel4);
        return jPanel;
    }

    private JPanel createLabeledField(String string, JComponent jComponent) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.setOpaque(false);
        JLabel jLabel = new JLabel(string);
        jLabel.setFont(new Font(UIHelper.getDefaultFontName(), 0, 12));
        jLabel.setForeground(TEXT_COLOR);
        jLabel.setAlignmentX(0.0f);
        jComponent.setAlignmentX(0.0f);
        jPanel.add(jLabel);
        jPanel.add(Box.createVerticalStrut(5));
        jPanel.add(jComponent);
        return jPanel;
    }

    private void applyModernStyle() {
        this.addHoverEffect(this.resetButton, PRIMARY_COLOR, PRIMARY_DARK);
    }

    private JPasswordField createStyledPasswordField(final String string) {
        final JPasswordField jPasswordField = new JPasswordField(20);
        jPasswordField.setFont(new Font(UIHelper.getDefaultFontName(), 0, 14));
        jPasswordField.setForeground(TEXT_COLOR);
        jPasswordField.setEchoChar('\u0000');
        jPasswordField.setText(string);
        jPasswordField.setForeground(PLACEHOLDER_COLOR);
        jPasswordField.setPreferredSize(new Dimension(300, 40));
        jPasswordField.setMaximumSize(new Dimension(300, 40));
        jPasswordField.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(new Color(220, 220, 220), 1), BorderFactory.createEmptyBorder(10, 15, 10, 15)));
        jPasswordField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                if (String.valueOf(jPasswordField.getPassword()).equals(string)) {
                    jPasswordField.setText("");
                    jPasswordField.setEchoChar('\u2022');
                    jPasswordField.setForeground(TEXT_COLOR);
                }
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                if (String.valueOf(jPasswordField.getPassword()).isEmpty()) {
                    jPasswordField.setForeground(PLACEHOLDER_COLOR);
                    jPasswordField.setEchoChar('\u0000');
                    jPasswordField.setText(string);
                }
            }
        });
        return jPasswordField;
    }

    private JButton createPrimaryButton(String string) {
        JButton jButton = new JButton(string);
        jButton.setFont(new Font(UIHelper.getDefaultFontName(), 1, 14));
        jButton.setForeground(Color.WHITE);
        jButton.setBackground(PRIMARY_COLOR);
        jButton.setPreferredSize(new Dimension(300, 45));
        jButton.setMaximumSize(new Dimension(300, 45));
        jButton.setBorderPainted(false);
        jButton.setFocusPainted(false);
        jButton.setCursor(new Cursor(12));
        jButton.setBorder(BorderFactory.createEmptyBorder(10, 20, 10, 20));
        return jButton;
    }

    private void addHoverEffect(final JButton jButton, final Color color, final Color color2) {
        jButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                jButton.setBackground(color2);
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                jButton.setBackground(color);
            }
        });
    }

    private void handleResetPassword() {
        String string;
        String string2;
        final String string3 = String.valueOf(this.tempPasswordField.getPassword());
        if (!this.validateInput(string3, string2 = String.valueOf(this.newPasswordField.getPassword()), string = String.valueOf(this.confirmPasswordField.getPassword()))) {
            return;
        }
        this.resetButton.setEnabled(false);
        this.resetButton.setText("\u0110ang c\u1eadp nh\u1eadt...");
        SwingWorker<Map<String, Object>, Void> swingWorker = new SwingWorker<Map<String, Object>, Void>(){

            @Override
            protected Map<String, Object> doInBackground() throws Exception {
                UserService userService = new UserService();
                return userService.resetPasswordWithTemporary(ResetPasswordFrame.this.email, string3, string2);
            }

            @Override
            protected void done() {
                try {
                    Map map = (Map)this.get();
                    if (((Boolean)map.get("success")).booleanValue()) {
                        JOptionPane.showMessageDialog(ResetPasswordFrame.this, "\u2705 \u0110\u1ed5i m\u1eadt kh\u1ea9u th\u00e0nh c\u00f4ng!\n\nB\u1ea1n c\u00f3 th\u1ec3 \u0111\u0103ng nh\u1eadp b\u1eb1ng m\u1eadt kh\u1ea9u m\u1edbi.", "Th\u00e0nh c\u00f4ng", 1);
                        ResetPasswordFrame.this.dispose();
                        SwingUtilities.invokeLater(() -> {
                            LoginFrame loginFrame = new LoginFrame();
                            loginFrame.setVisible(true);
                        });
                    } else {
                        JOptionPane.showMessageDialog(ResetPasswordFrame.this, map.get("message"), "L\u1ed7i", 0);
                        ResetPasswordFrame.this.resetButton.setEnabled(true);
                        ResetPasswordFrame.this.resetButton.setText("C\u1eacP NH\u1eacT M\u1eacT KH\u1ea8U");
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    JOptionPane.showMessageDialog(ResetPasswordFrame.this, "L\u1ed7i: " + exception.getMessage(), "L\u1ed7i", 0);
                    ResetPasswordFrame.this.resetButton.setEnabled(true);
                    ResetPasswordFrame.this.resetButton.setText("C\u1eacP NH\u1eacT M\u1eacT KH\u1ea8U");
                }
            }
        };
        swingWorker.execute();
    }

    private boolean validateInput(String string, String string2, String string3) {
        if (string.equals("M\u1eadt kh\u1ea9u t\u1ea1m t\u1eeb email") || string.isEmpty()) {
            JOptionPane.showMessageDialog(this, "Vui l\u00f2ng nh\u1eadp m\u1eadt kh\u1ea9u t\u1ea1m t\u1eeb email!", "L\u1ed7i", 2);
            return false;
        }
        if (string2.equals("M\u1eadt kh\u1ea9u m\u1edbi") || string2.isEmpty()) {
            JOptionPane.showMessageDialog(this, "Vui l\u00f2ng nh\u1eadp m\u1eadt kh\u1ea9u m\u1edbi!", "L\u1ed7i", 2);
            return false;
        }
        if (string3.equals("X\u00e1c nh\u1eadn m\u1eadt kh\u1ea9u m\u1edbi") || string3.isEmpty()) {
            JOptionPane.showMessageDialog(this, "Vui l\u00f2ng x\u00e1c nh\u1eadn m\u1eadt kh\u1ea9u m\u1edbi!", "L\u1ed7i", 2);
            return false;
        }
        if (!string.equals(this.temporaryPassword)) {
            JOptionPane.showMessageDialog(this, "\u274c M\u1eadt kh\u1ea9u t\u1ea1m kh\u00f4ng \u0111\u00fang!\n\nVui l\u00f2ng ki\u1ec3m tra l\u1ea1i email.", "L\u1ed7i", 0);
            return false;
        }
        if (string2.length() < 6) {
            JOptionPane.showMessageDialog(this, "M\u1eadt kh\u1ea9u m\u1edbi ph\u1ea3i c\u00f3 \u00edt nh\u1ea5t 6 k\u00fd t\u1ef1!", "L\u1ed7i", 2);
            return false;
        }
        if (!string2.equals(string3)) {
            JOptionPane.showMessageDialog(this, "M\u1eadt kh\u1ea9u x\u00e1c nh\u1eadn kh\u00f4ng kh\u1edbp!", "L\u1ed7i", 2);
            return false;
        }
        return true;
    }
}

