/*
 * Decompiled with CFR 0.152.
 */
package user.socket;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import user.socket.Message;
import user.socket.SocketClient;

public class TestChatClient
extends JFrame {
    private JTextArea chatArea;
    private JTextField messageField;
    private JButton sendButton;
    private SocketClient socketClient;
    private String username;

    public TestChatClient(String string) {
        this.username = string;
        this.initializeGUI();
        this.initializeSocket();
    }

    private void initializeGUI() {
        this.setTitle("Chat Test - " + this.username);
        this.setSize(500, 600);
        this.setDefaultCloseOperation(3);
        this.setLayout(new BorderLayout());
        this.chatArea = new JTextArea();
        this.chatArea.setEditable(false);
        this.chatArea.setFont(new Font("Segoe UI", 0, 14));
        this.chatArea.setLineWrap(true);
        this.chatArea.setWrapStyleWord(true);
        JScrollPane jScrollPane = new JScrollPane(this.chatArea);
        JPanel jPanel = new JPanel(new BorderLayout(5, 5));
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.messageField = new JTextField();
        this.messageField.setFont(new Font("Segoe UI", 0, 14));
        this.sendButton = new JButton("G\u1eedi");
        this.sendButton.setFont(new Font("Segoe UI", 1, 13));
        jPanel.add((Component)this.messageField, "Center");
        jPanel.add((Component)this.sendButton, "East");
        this.add((Component)jScrollPane, "Center");
        this.add((Component)jPanel, "South");
        this.sendButton.addActionListener(actionEvent -> this.sendMessage());
        this.messageField.addActionListener(actionEvent -> this.sendMessage());
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                if (TestChatClient.this.socketClient != null) {
                    TestChatClient.this.socketClient.disconnect();
                }
            }
        });
    }

    private void initializeSocket() {
        this.socketClient = new SocketClient(this.username, this::handleMessage);
        this.appendChat("\ud83d\udd0c \u0110ang k\u1ebft n\u1ed1i \u0111\u1ebfn server...");
        new Thread(() -> {
            boolean bl = this.socketClient.connect();
            if (bl) {
                this.appendChat("\u2705 \u0110\u00e3 k\u1ebft n\u1ed1i th\u00e0nh c\u00f4ng!");
            } else {
                this.appendChat("\u274c Kh\u00f4ng th\u1ec3 k\u1ebft n\u1ed1i \u0111\u1ebfn server!");
            }
        }).start();
    }

    private void sendMessage() {
        String string = this.messageField.getText().trim();
        if (!string.isEmpty() && this.socketClient != null) {
            this.socketClient.sendChatMessage(string);
            this.appendChat("[" + this.getCurrentTime() + "] B\u1ea1n: " + string);
            this.messageField.setText("");
        }
    }

    private void handleMessage(Message message) {
        SwingUtilities.invokeLater(() -> {
            switch (message.getType()) {
                case CHAT: 
                case PRIVATE_MESSAGE: {
                    this.appendChat("[" + this.getCurrentTime() + "] " + message.getSender() + ": " + message.getContent());
                    break;
                }
                case USER_JOINED: {
                    this.appendChat("\ud83d\udfe2 " + message.getSender() + " \u0111\u00e3 tham gia");
                    break;
                }
                case USER_LEFT: {
                    this.appendChat("\ud83d\udd34 " + message.getSender() + " \u0111\u00e3 r\u1eddi \u0111i");
                    break;
                }
                case ONLINE_USERS: {
                    if (message.getData() == null) break;
                    List list = (List)message.getData();
                    this.appendChat("\ud83d\udc65 Ng\u01b0\u1eddi d\u00f9ng online: " + String.valueOf(list));
                    break;
                }
                case SUCCESS: {
                    this.appendChat("\u2705 " + message.getContent());
                    break;
                }
                case ERROR: {
                    this.appendChat("\u274c " + message.getContent());
                    break;
                }
                default: {
                    this.appendChat("\ud83d\udce8 " + String.valueOf((Object)message.getType()) + ": " + message.getContent());
                }
            }
        });
    }

    private void appendChat(String string) {
        SwingUtilities.invokeLater(() -> {
            this.chatArea.append(string + "\n");
            this.chatArea.setCaretPosition(this.chatArea.getDocument().getLength());
        });
    }

    private String getCurrentTime() {
        return LocalDateTime.now().format(DateTimeFormatter.ofPattern("HH:mm:ss"));
    }

    public static void main(String[] stringArray) {
        Object object = "User1";
        if (stringArray.length > 0) {
            object = stringArray[0];
        } else {
            object = JOptionPane.showInputDialog(null, "Nh\u1eadp t\u00ean c\u1ee7a b\u1ea1n:", "Chat Test Client", 3);
            if (object == null || ((String)object).trim().isEmpty()) {
                object = "User" + System.currentTimeMillis() % 1000L;
            }
        }
        String string = object;
        SwingUtilities.invokeLater(() -> {
            TestChatClient testChatClient = new TestChatClient(string);
            testChatClient.setLocationRelativeTo(null);
            testChatClient.setVisible(true);
        });
    }
}

