/*
 * Decompiled with CFR 0.152.
 */
package admin.gui;

import admin.service.StatisticsDAO;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.SQLException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;

public class AdminMainFrame
extends JFrame {
    private static final Color ZALO_BLUE = new Color(0, 102, 255);
    private static final Color SUCCESS_GREEN = new Color(40, 167, 69);
    private static final Color WARNING_ORANGE = new Color(255, 193, 7);
    private static final Color DANGER_RED = new Color(220, 53, 69);
    private static final Color LIGHT_GRAY = new Color(248, 249, 250);
    private static final Color INFO_CYAN = new Color(23, 162, 184);
    private JMenuBar menuBar;
    private JPanel contentPanel;
    private JLabel statusLabel;
    private JPanel homePanel;
    private StatisticsDAO statisticsDAO = new StatisticsDAO();

    public AdminMainFrame() {
        this.initializeComponents();
        this.setupLayout();
        this.setupMenu();
        this.showHomePage();
    }

    private void showHomePage() {
        this.contentPanel.removeAll();
        this.homePanel = new JPanel(new BorderLayout(15, 15));
        this.homePanel.setBackground(LIGHT_GRAY);
        this.homePanel.setBorder(new EmptyBorder(20, 20, 20, 20));
        JPanel jPanel = this.createHeaderPanel();
        this.homePanel.add((Component)jPanel, "North");
        JPanel jPanel2 = new JPanel(new BorderLayout(15, 15));
        jPanel2.setOpaque(false);
        JPanel jPanel3 = this.createStatisticsPanel();
        jPanel2.add((Component)jPanel3, "North");
        JPanel jPanel4 = this.createQuickActionsPanel();
        jPanel2.add((Component)jPanel4, "Center");
        this.homePanel.add((Component)jPanel2, "Center");
        this.contentPanel.add((Component)this.homePanel, "Center");
        this.contentPanel.revalidate();
        this.contentPanel.repaint();
    }

    private JPanel createHeaderPanel() {
        JLabel jLabel;
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBackground(Color.WHITE);
        jPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 0, 3, 0, ZALO_BLUE), new EmptyBorder(15, 20, 15, 20)));
        JPanel jPanel2 = new JPanel(new FlowLayout(0, 0, 0));
        jPanel2.setOpaque(false);
        ImageIcon imageIcon = this.loadIcon("home", 24, 24);
        if (imageIcon != null) {
            jLabel = new JLabel("Trang ch\u1ee7 qu\u1ea3n tr\u1ecb", imageIcon, 2);
            jLabel.setIconTextGap(8);
        } else {
            jLabel = new JLabel("Trang ch\u1ee7 qu\u1ea3n tr\u1ecb");
        }
        jLabel.setFont(new Font("Arial", 1, 24));
        jLabel.setForeground(ZALO_BLUE);
        jPanel2.add(jLabel);
        JPanel jPanel3 = new JPanel(new FlowLayout(2, 0, 0));
        jPanel3.setOpaque(false);
        JLabel jLabel2 = new JLabel(LocalDateTime.now().format(DateTimeFormatter.ofPattern("HH:mm - dd/MM/yyyy")));
        jLabel2.setFont(new Font("Arial", 0, 13));
        jLabel2.setForeground(Color.GRAY);
        jPanel3.add(jLabel2);
        jPanel.add((Component)jPanel2, "West");
        jPanel.add((Component)jPanel3, "East");
        return jPanel;
    }

    private JPanel createStatisticsPanel() {
        JPanel jPanel = new JPanel(new GridLayout(1, 4, 12, 0));
        jPanel.setOpaque(false);
        jPanel.setPreferredSize(new Dimension(1160, 180));
        final JPanel jPanel2 = this.createStatCard("Ng\u01b0\u1eddi d\u00f9ng", "...", ZALO_BLUE, "user");
        final JPanel jPanel3 = this.createStatCard("B\u00e1o c\u00e1o spam", "...", ZALO_BLUE, "notification");
        final JPanel jPanel4 = this.createStatCard("Nh\u00f3m chat", "...", ZALO_BLUE, "chat");
        final JPanel jPanel5 = this.createStatCard("Tin nh\u1eafn", "...", ZALO_BLUE, "message");
        jPanel.add(jPanel2);
        jPanel.add(jPanel3);
        jPanel.add(jPanel4);
        jPanel.add(jPanel5);
        SwingWorker<int[], Void> swingWorker = new SwingWorker<int[], Void>(){

            @Override
            protected int[] doInBackground() throws Exception {
                int n = AdminMainFrame.this.getDashboardStat(() -> AdminMainFrame.this.statisticsDAO.getTotalUsers());
                int n2 = AdminMainFrame.this.getDashboardStat(() -> AdminMainFrame.this.statisticsDAO.getTotalSpamReports());
                int n3 = AdminMainFrame.this.getDashboardStat(() -> AdminMainFrame.this.statisticsDAO.getTotalGroups());
                int n4 = AdminMainFrame.this.getDashboardStat(() -> AdminMainFrame.this.statisticsDAO.getTotalMessages());
                return new int[]{n, n2, n3, n4};
            }

            @Override
            protected void done() {
                try {
                    int[] nArray = (int[])this.get();
                    AdminMainFrame.this.updateStatCard(jPanel2, AdminMainFrame.this.formatNumber(nArray[0]));
                    AdminMainFrame.this.updateStatCard(jPanel3, AdminMainFrame.this.formatNumber(nArray[1]));
                    AdminMainFrame.this.updateStatCard(jPanel4, AdminMainFrame.this.formatNumber(nArray[2]));
                    AdminMainFrame.this.updateStatCard(jPanel5, AdminMainFrame.this.formatNumber(nArray[3]));
                }
                catch (Exception exception) {
                    System.err.println("Error loading dashboard stats: " + exception.getMessage());
                    AdminMainFrame.this.updateStatCard(jPanel2, "N/A");
                    AdminMainFrame.this.updateStatCard(jPanel3, "N/A");
                    AdminMainFrame.this.updateStatCard(jPanel4, "N/A");
                    AdminMainFrame.this.updateStatCard(jPanel5, "N/A");
                }
            }
        };
        swingWorker.execute();
        return jPanel;
    }

    private void updateStatCard(JPanel jPanel, String string) {
        Component[] componentArray;
        for (Component component : componentArray = jPanel.getComponents()) {
            if (!(component instanceof JLabel)) continue;
            JLabel jLabel = (JLabel)component;
            try {
                if (jLabel.getFont().getSize() != 30) continue;
                jLabel.setText(string);
                break;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private int getDashboardStat(SQLSupplier sQLSupplier) {
        try {
            return sQLSupplier.get();
        }
        catch (Exception exception) {
            System.err.println("Error getting dashboard stat: " + exception.getMessage());
            return 0;
        }
    }

    private String formatNumber(int n) {
        return String.format("%,d", n);
    }

    private ImageIcon loadIcon(String string, int n, int n2) {
        try {
            String string2 = "icons/" + string + ".png";
            ImageIcon imageIcon = new ImageIcon(string2);
            if (imageIcon.getImageLoadStatus() == 8) {
                Image image = imageIcon.getImage().getScaledInstance(n, n2, 4);
                return new ImageIcon(image);
            }
        }
        catch (Exception exception) {
            System.err.println("Could not load icon: " + string);
        }
        return null;
    }

    private JPanel createStatCard(String string, String string2, Color color, String string3) {
        JLabel jLabel;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.setBackground(Color.WHITE);
        jPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(color, 2), new EmptyBorder(12, 12, 12, 12)));
        ImageIcon imageIcon = this.loadIcon(string3, 32, 32);
        if (imageIcon != null) {
            jLabel = new JLabel(imageIcon);
        } else {
            jLabel = new JLabel(string3.toUpperCase().substring(0, 1));
            jLabel.setFont(new Font("Arial", 1, 32));
        }
        jLabel.setAlignmentX(0.5f);
        JLabel jLabel2 = new JLabel(string);
        jLabel2.setFont(new Font("Arial", 0, 13));
        jLabel2.setForeground(Color.GRAY);
        jLabel2.setAlignmentX(0.5f);
        JLabel jLabel3 = new JLabel(string2);
        jLabel3.setFont(new Font("Arial", 1, 30));
        jLabel3.setForeground(color);
        jLabel3.setAlignmentX(0.5f);
        jPanel.add(Box.createVerticalGlue());
        jPanel.add(jLabel);
        jPanel.add(Box.createVerticalStrut(8));
        jPanel.add(jLabel2);
        jPanel.add(Box.createVerticalStrut(5));
        jPanel.add(jLabel3);
        jPanel.add(Box.createVerticalGlue());
        return jPanel;
    }

    private JPanel createQuickActionsPanel() {
        JPanel jPanel = new JPanel(new BorderLayout(10, 10));
        jPanel.setOpaque(false);
        JLabel jLabel = new JLabel(">> Thao t\u00e1c nhanh");
        jLabel.setFont(new Font("Arial", 1, 18));
        jLabel.setForeground(ZALO_BLUE);
        jLabel.setBorder(new EmptyBorder(8, 0, 10, 0));
        JPanel jPanel2 = new JPanel(new GridLayout(3, 3, 10, 10));
        jPanel2.setOpaque(false);
        jPanel2.add(this.createActionCard("Qu\u1ea3n l\u00fd ng\u01b0\u1eddi d\u00f9ng", "Qu\u1ea3n l\u00fd danh s\u00e1ch ng\u01b0\u1eddi d\u00f9ng", ZALO_BLUE, "user", actionEvent -> this.openUserManagement()));
        jPanel2.add(this.createActionCard("L\u1ecbch s\u1eed \u0111\u0103ng nh\u1eadp", "Xem danh s\u00e1ch \u0111\u0103ng nh\u1eadp theo th\u1ee9 t\u1ef1 th\u1eddi gian", ZALO_BLUE, "history", actionEvent -> this.openLoginHistory()));
        jPanel2.add(this.createActionCard("Danh s\u00e1ch nh\u00f3m", "Xem danh s\u00e1ch c\u00e1c nh\u00f3m chat", ZALO_BLUE, "chat", actionEvent -> this.openGroupManagement()));
        jPanel2.add(this.createActionCard("B\u00e1o c\u00e1o spam", "Xem danh s\u00e1ch b\u00e1o c\u00e1o spam", ZALO_BLUE, "notification", actionEvent -> this.openSpamReport()));
        jPanel2.add(this.createActionCard("Ng\u01b0\u1eddi d\u00f9ng m\u1edbi", "Xem danh s\u00e1ch ng\u01b0\u1eddi d\u00f9ng \u0111\u0103ng k\u00fd m\u1edbi", ZALO_BLUE, "add", actionEvent -> this.openNewUserReport()));
        jPanel2.add(this.createActionCard("Th\u1ed1ng k\u00ea", "Bi\u1ec3u \u0111\u1ed3 s\u1ed1 l\u01b0\u1ee3ng ng\u01b0\u1eddi \u0111\u0103ng k\u00fd m\u1edbi theo n\u0103m", ZALO_BLUE, "chart", actionEvent -> this.openStatistics()));
        jPanel2.add(this.createActionCard("B\u1ea1n b\u00e8", "Xem danh s\u00e1ch ng\u01b0\u1eddi d\u00f9ng v\u00e0 s\u1ed1 l\u01b0\u1ee3ng b\u1ea1n b\u00e8", ZALO_BLUE, "friends", actionEvent -> this.openFriendStats()));
        jPanel2.add(this.createActionCard("Ng\u01b0\u1eddi ho\u1ea1t \u0111\u1ed9ng", "Xem danh s\u00e1ch ng\u01b0\u1eddi d\u00f9ng ho\u1ea1t \u0111\u1ed9ng", ZALO_BLUE, "dashboard", actionEvent -> this.openActiveUserReport()));
        jPanel2.add(this.createActionCard("Bi\u1ec3u \u0111\u1ed3", "Bi\u1ec3u \u0111\u1ed3 s\u1ed1 l\u01b0\u1ee3ng ng\u01b0\u1eddi ho\u1ea1t \u0111\u1ed9ng theo n\u0103m", ZALO_BLUE, "chart", actionEvent -> this.openActiveUserChart()));
        jPanel.add((Component)jLabel, "North");
        jPanel.add((Component)jPanel2, "Center");
        return jPanel;
    }

    private JPanel createActionCard(String string, String string2, final Color color, String string3, final ActionListener actionListener) {
        JLabel jLabel;
        final JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.setBackground(Color.WHITE);
        jPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(color, 2), new EmptyBorder(18, 15, 18, 15)));
        jPanel.setCursor(new Cursor(12));
        JPanel jPanel2 = new JPanel(new FlowLayout(0, 8, 0));
        jPanel2.setOpaque(false);
        jPanel2.setAlignmentX(0.0f);
        ImageIcon imageIcon = this.loadIcon(string3, 20, 20);
        int n = 0;
        if (imageIcon != null) {
            jLabel = new JLabel(imageIcon);
            n = imageIcon.getIconWidth();
            jPanel2.add(jLabel);
        }
        jLabel = new JLabel(string);
        jLabel.setFont(new Font("Arial", 1, 15));
        jLabel.setForeground(color);
        FontMetrics fontMetrics = jLabel.getFontMetrics(jLabel.getFont());
        int n2 = fontMetrics.stringWidth(string);
        int n3 = 30;
        int n4 = n2 + n3;
        jLabel.setMinimumSize(new Dimension(n4, 25));
        jLabel.setPreferredSize(new Dimension(n4, 25));
        jLabel.setMaximumSize(new Dimension(Integer.MAX_VALUE, 25));
        jLabel.setHorizontalAlignment(2);
        jLabel.setVerticalAlignment(0);
        jPanel2.add(jLabel);
        int n5 = n + 8 + n4;
        jPanel2.setMinimumSize(new Dimension(n5, 30));
        jPanel2.setPreferredSize(new Dimension(Integer.MAX_VALUE, 30));
        JLabel jLabel2 = new JLabel(string2);
        jLabel2.setFont(new Font("Arial", 0, 12));
        jLabel2.setForeground(Color.GRAY);
        jLabel2.setAlignmentX(0.0f);
        jPanel.add(jPanel2);
        jPanel.add(Box.createVerticalStrut(6));
        jPanel.add(jLabel2);
        jPanel.addMouseListener(new MouseAdapter(){
            private final Color hoverColor = new Color(245, 245, 245);

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                jPanel.setBackground(this.hoverColor);
                jPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(color, 3), new EmptyBorder(18, 15, 18, 15)));
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                jPanel.setBackground(Color.WHITE);
                jPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(color, 2), new EmptyBorder(18, 15, 18, 15)));
            }

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                actionListener.actionPerformed(null);
            }
        });
        return jPanel;
    }

    private void initializeComponents() {
        this.setTitle("H\u1ec7 th\u1ed1ng qu\u1ea3n tr\u1ecb - Chat System");
        this.setDefaultCloseOperation(3);
        this.setSize(1200, 820);
        this.setLocationRelativeTo(null);
        this.menuBar = new JMenuBar();
        this.contentPanel = new JPanel(new BorderLayout());
        this.statusLabel = new JLabel(" Tr\u1ea1ng th\u00e1i: S\u1eb5n s\u00e0ng");
        this.statusLabel.setBorder(new EmptyBorder(5, 10, 5, 10));
    }

    private void setupLayout() {
        this.setJMenuBar(this.menuBar);
        this.add((Component)this.contentPanel, "Center");
        this.add((Component)this.statusLabel, "South");
    }

    private void setupMenu() {
        ImageIcon imageIcon = this.loadIcon("settings", 16, 16);
        JMenu jMenu = new JMenu("L\u1ef1a ch\u1ecdn ch\u1ee9c n\u0103ng");
        if (imageIcon != null) {
            jMenu.setIcon(imageIcon);
        }
        this.addMenuItem(jMenu, "Qu\u1ea3n l\u00fd ng\u01b0\u1eddi d\u00f9ng", actionEvent -> this.openUserManagement());
        this.addMenuItem(jMenu, "L\u1ecbch s\u1eed \u0111\u0103ng nh\u1eadp", actionEvent -> this.openLoginHistory());
        this.addMenuItem(jMenu, "Xem danh s\u00e1ch nh\u00f3m chat", actionEvent -> this.openGroupManagement());
        this.addMenuItem(jMenu, "Xem danh s\u00e1ch b\u00e1o c\u00e1o spam", actionEvent -> this.openSpamReport());
        this.addMenuItem(jMenu, "Xem danh s\u00e1ch ng\u01b0\u1eddi d\u00f9ng m\u1edbi", actionEvent -> this.openNewUserReport());
        this.addMenuItem(jMenu, "Th\u1ed1ng k\u00ea ng\u01b0\u1eddi d\u00f9ng", actionEvent -> this.openStatistics());
        this.addMenuItem(jMenu, "Danh s\u00e1ch ng\u01b0\u1eddi d\u00f9ng v\u00e0 s\u1ed1 l\u01b0\u1ee3ng b\u1ea1n b\u00e8", actionEvent -> this.openFriendStats());
        this.addMenuItem(jMenu, "Xem danh s\u00e1ch ng\u01b0\u1eddi d\u00f9ng ho\u1ea1t \u0111\u1ed9ng", actionEvent -> this.openActiveUserReport());
        this.addMenuItem(jMenu, "Xem bi\u1ec3u \u0111\u1ed3 ng\u01b0\u1eddi d\u00f9ng ho\u1ea1t \u0111\u1ed9ng", actionEvent -> this.openActiveUserChart());
        this.menuBar.add(jMenu);
    }

    private void addMenuItem(JMenu jMenu, String string, ActionListener actionListener) {
        JMenuItem jMenuItem = new JMenuItem(string);
        jMenuItem.addActionListener(actionListener);
        jMenu.add(jMenuItem);
    }

    private void openUserManagement() {
        this.openPanel("Qu\u1ea3n l\u00fd ng\u01b0\u1eddi d\u00f9ng", this.loadPanelByClassName("admin.gui.UserManagementPanel"));
    }

    private void openLoginHistory() {
        this.openPanel("L\u1ecbch s\u1eed \u0111\u0103ng nh\u1eadp", this.loadPanelByClassName("admin.gui.LoginHistoryPanel"));
    }

    private void openGroupManagement() {
        this.openPanel("Qu\u1ea3n l\u00fd nh\u00f3m chat", this.loadPanelByClassName("admin.gui.GroupManagementPanel"));
    }

    private void openSpamReport() {
        this.openPanel("Xem danh s\u00e1ch b\u00e1o c\u00e1o spam", this.loadPanelByClassName("admin.gui.SpamReportPanel"));
    }

    private void openNewUserReport() {
        this.openPanel("Xem danh s\u00e1ch ng\u01b0\u1eddi d\u00f9ng m\u1edbi", this.loadPanelByClassName("admin.gui.NewUserReportPanel"));
    }

    private void openStatistics() {
        this.openPanel("Th\u1ed1ng k\u00ea ng\u01b0\u1eddi d\u00f9ng", this.loadPanelByClassName("admin.gui.StatisticsPanel"));
    }

    private void openFriendStats() {
        this.openPanel("Th\u1ed1ng k\u00ea b\u1ea1n b\u00e8", this.loadPanelByClassName("admin.gui.FriendStatsPanel"));
    }

    private void openActiveUserReport() {
        this.openPanel("B\u00e1o c\u00e1o ng\u01b0\u1eddi d\u00f9ng ho\u1ea1t \u0111\u1ed9ng", this.loadPanelByClassName("admin.gui.ActiveUserReportPanel"));
    }

    private void openActiveUserChart() {
        this.openPanel("Bi\u1ec3u \u0111\u1ed3 ng\u01b0\u1eddi d\u00f9ng ho\u1ea1t \u0111\u1ed9ng", this.loadPanelByClassName("admin.gui.ActiveUserChartPanel"));
    }

    private JPanel loadPanelByClassName(String string) {
        try {
            Class<?> clazz = Class.forName(string);
            Object obj = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            if (obj instanceof JPanel) {
                return (JPanel)obj;
            }
            return this.createErrorPanel("Class " + string + " kh\u00f4ng ph\u1ea3i l\u00e0 JPanel");
        }
        catch (ClassNotFoundException classNotFoundException) {
            return this.createErrorPanel("Ch\u1ee9c n\u0103ng \u0111ang ph\u00e1t tri\u1ec3n - Class ch\u01b0a t\u1ed3n t\u1ea1i: " + string);
        }
        catch (Exception exception) {
            return this.createErrorPanel("L\u1ed7i khi t\u1ea1o panel: " + exception.getMessage());
        }
    }

    private void openPanel(String string, JPanel jPanel) {
        JButton jButton;
        JLabel jLabel;
        int n;
        this.contentPanel.removeAll();
        JPanel jPanel2 = new JPanel(new BorderLayout());
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.setBackground(Color.WHITE);
        jPanel3.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 0, 3, 0, ZALO_BLUE), new EmptyBorder(15, 20, 15, 20)));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BoxLayout(jPanel4, 0));
        jPanel4.setOpaque(false);
        String string2 = this.getIconNameForTitle(string);
        ImageIcon imageIcon = this.loadIcon(string2, 24, 24);
        int n2 = imageIcon != null ? imageIcon.getIconWidth() : 0;
        int n3 = n = imageIcon != null ? 15 : 10;
        if (imageIcon != null) {
            jLabel = new JLabel(imageIcon);
            jPanel4.add(jLabel);
            jPanel4.add(Box.createRigidArea(new Dimension(n, 0)));
        } else {
            jLabel = new JLabel(this.getEmojiForTitle(string));
            jLabel.setFont(new Font("Arial", 1, 24));
            jPanel4.add(jLabel);
            jPanel4.add(Box.createRigidArea(new Dimension(n, 0)));
        }
        jLabel = new JLabel(string);
        jLabel.setFont(new Font("Arial", 1, 24));
        jLabel.setForeground(ZALO_BLUE);
        FontMetrics fontMetrics = jLabel.getFontMetrics(jLabel.getFont());
        int n4 = fontMetrics.stringWidth(string);
        int n5 = 50;
        int n6 = n4 + n5;
        jLabel.setMinimumSize(new Dimension(n6, 35));
        jLabel.setPreferredSize(new Dimension(n6, 35));
        jLabel.setMaximumSize(new Dimension(Integer.MAX_VALUE, 35));
        jLabel.setHorizontalAlignment(2);
        jLabel.setVerticalAlignment(0);
        jPanel4.add(jLabel);
        jPanel4.add(Box.createHorizontalGlue());
        int n7 = n2 + n + n6;
        jPanel4.setMinimumSize(new Dimension(n7, 45));
        jPanel4.setPreferredSize(new Dimension(Integer.MAX_VALUE, 45));
        jPanel3.add((Component)jPanel4, "Center");
        jPanel2.add((Component)jPanel3, "North");
        jPanel2.add((Component)jPanel, "Center");
        ImageIcon imageIcon2 = this.loadIcon("home", 16, 16);
        if (imageIcon2 != null) {
            jButton = new JButton("Quay l\u1ea1i trang ch\u1ee7", imageIcon2);
            jButton.setHorizontalTextPosition(4);
            jButton.setIconTextGap(8);
        } else {
            jButton = new JButton("Quay l\u1ea1i trang ch\u1ee7");
        }
        jButton.setFont(new Font("Arial", 1, 14));
        jButton.setBackground(new Color(108, 117, 125));
        jButton.setForeground(Color.WHITE);
        jButton.setFocusPainted(false);
        jButton.setBorderPainted(false);
        jButton.setOpaque(true);
        jButton.setMargin(new Insets(8, 15, 8, 15));
        jButton.setCursor(new Cursor(12));
        jButton.addActionListener(actionEvent -> this.showHomePage());
        JPanel jPanel5 = new JPanel(new FlowLayout(0, 10, 10));
        jPanel5.add(jButton);
        jPanel2.add((Component)jPanel5, "South");
        this.contentPanel.add((Component)jPanel2, "Center");
        this.contentPanel.revalidate();
        this.contentPanel.repaint();
    }

    private String getIconNameForTitle(String string) {
        if (string.contains("ng\u01b0\u1eddi d\u00f9ng")) {
            return "user";
        }
        if (string.contains("l\u1ecbch s\u1eed")) {
            return "history";
        }
        if (string.contains("nh\u00f3m")) {
            return "chat";
        }
        if (string.contains("spam")) {
            return "notification";
        }
        if (string.contains("m\u1edbi")) {
            return "new";
        }
        if (string.contains("Th\u1ed1ng k\u00ea")) {
            return "statistics";
        }
        if (string.contains("b\u1ea1n b\u00e8")) {
            return "friend";
        }
        if (string.contains("ho\u1ea1t \u0111\u1ed9ng")) {
            return "dashboard";
        }
        if (string.contains("Bi\u1ec3u \u0111\u1ed3")) {
            return "chart";
        }
        return "default";
    }

    private String getEmojiForTitle(String string) {
        if (string.contains("ng\u01b0\u1eddi d\u00f9ng")) {
            return "\ud83d\udc64";
        }
        if (string.contains("l\u1ecbch s\u1eed")) {
            return "\ud83d\udcdc";
        }
        if (string.contains("nh\u00f3m")) {
            return "\ud83d\udc65";
        }
        if (string.contains("spam")) {
            return "\ud83d\udd14";
        }
        if (string.contains("m\u1edbi")) {
            return "\ud83c\udd95";
        }
        if (string.contains("Th\u1ed1ng k\u00ea")) {
            return "\ud83d\udcca";
        }
        if (string.contains("b\u1ea1n b\u00e8")) {
            return "\ud83d\udc9d";
        }
        if (string.contains("ho\u1ea1t \u0111\u1ed9ng")) {
            return "\ud83d\udcc8";
        }
        if (string.contains("Bi\u1ec3u \u0111\u1ed3")) {
            return "\ud83d\udcc9";
        }
        return "\ud83d\udccb";
    }

    private JPanel createErrorPanel(String string) {
        JPanel jPanel = new JPanel(new BorderLayout());
        JLabel jLabel = new JLabel("<html><center>" + string + "<br><br>Vui l\u00f2ng t\u1ea1o file class t\u01b0\u01a1ng \u1ee9ng</center></html>");
        jLabel.setFont(new Font("Arial", 0, 16));
        jLabel.setForeground(Color.RED);
        jLabel.setHorizontalAlignment(0);
        jPanel.add((Component)jLabel, "Center");
        return jPanel;
    }

    public static void main(String[] stringArray) {
        SwingUtilities.invokeLater(() -> {
            try {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            new AdminMainFrame().setVisible(true);
        });
    }

    @FunctionalInterface
    static interface SQLSupplier {
        public int get() throws SQLException;
    }
}

