/*
 * Decompiled with CFR 0.152.
 */
package admin.service;

import admin.service.DatabaseConnection;
import admin.socket.User;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;

public class UserDAO {
    private DatabaseConnection dbConnection = DatabaseConnection.getInstance();

    public List<User> getAllUsers() throws SQLException {
        ArrayList<User> arrayList = new ArrayList<User>();
        String string = "SELECT user_id, username, password, full_name, email, address, dob, gender, status, created_at, last_login FROM users ORDER BY created_at DESC";
        try (Connection connection = this.dbConnection.getConnection();
             Statement statement = connection.createStatement();
             ResultSet resultSet = statement.executeQuery(string);){
            while (resultSet.next()) {
                arrayList.add(this.extractUserFromResultSet(resultSet));
            }
        }
        return arrayList;
    }

    public List<User> searchUsers(String string) throws SQLException {
        return this.searchUsers(string, SearchType.ALL);
    }

    public List<User> searchUsers(String string, SearchType searchType) throws SQLException {
        ArrayList<User> arrayList = new ArrayList<User>();
        if (string == null || string.isEmpty()) {
            return arrayList;
        }
        String string2 = "SELECT user_id, username, password, full_name, email, address, dob, gender, status, created_at, last_login FROM users ";
        String string3 = switch (searchType) {
            case SearchType.USERNAME -> string2 + "WHERE username LIKE ? ORDER BY created_at DESC";
            case SearchType.FULL_NAME -> string2 + "WHERE full_name LIKE ? ORDER BY created_at DESC";
            case SearchType.EMAIL -> string2 + "WHERE email LIKE ? ORDER BY created_at DESC";
            default -> string2 + "WHERE username LIKE ? OR full_name LIKE ? OR email LIKE ? ORDER BY created_at DESC";
        };
        try (Connection connection = this.dbConnection.getConnection();
             PreparedStatement preparedStatement = connection.prepareStatement(string3);){
            String string4 = "%" + string + "%";
            preparedStatement.setString(1, string4);
            if (searchType == SearchType.ALL) {
                preparedStatement.setString(2, string4);
                preparedStatement.setString(3, string4);
            }
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                while (resultSet.next()) {
                    arrayList.add(this.extractUserFromResultSet(resultSet));
                }
            }
        }
        return arrayList;
    }

    public List<User> getUsersByStatus(String string) throws SQLException {
        ArrayList<User> arrayList = new ArrayList<User>();
        String string2 = "SELECT user_id, username, password, full_name, email, address, dob, gender, status, created_at, last_login FROM users WHERE status = ? ORDER BY created_at DESC";
        try (Connection connection = this.dbConnection.getConnection();
             PreparedStatement preparedStatement = connection.prepareStatement(string2);){
            preparedStatement.setString(1, string);
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                while (resultSet.next()) {
                    arrayList.add(this.extractUserFromResultSet(resultSet));
                }
            }
        }
        return arrayList;
    }

    public User getUserById(int n) throws SQLException {
        String string = "SELECT user_id, username, password, full_name, email, address, dob, gender, status, created_at, last_login FROM users WHERE user_id = ?";
        try (Connection connection = this.dbConnection.getConnection();
             PreparedStatement preparedStatement = connection.prepareStatement(string);){
            preparedStatement.setInt(1, n);
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                if (resultSet.next()) {
                    User user = this.extractUserFromResultSet(resultSet);
                    return user;
                }
            }
        }
        return null;
    }

    public boolean addUser(User user) throws SQLException {
        String string = "INSERT INTO users (username, password, full_name, email, address, dob, gender, status) VALUES (?, ?, ?, ?, ?, ?, ?, ?)";
        try (Connection connection = this.dbConnection.getConnection();){
            boolean bl;
            block12: {
                PreparedStatement preparedStatement = connection.prepareStatement(string);
                try {
                    preparedStatement.setString(1, user.getUsername());
                    preparedStatement.setString(2, this.hashPassword(user.getPassword()));
                    preparedStatement.setString(3, user.getFullName());
                    preparedStatement.setString(4, user.getEmail());
                    preparedStatement.setString(5, user.getAddress());
                    preparedStatement.setDate(6, user.getBirthDate() != null ? Date.valueOf(user.getBirthDate()) : null);
                    preparedStatement.setString(7, user.getGender());
                    preparedStatement.setString(8, user.getStatus());
                    boolean bl2 = bl = preparedStatement.executeUpdate() > 0;
                    if (preparedStatement == null) break block12;
                }
                catch (Throwable throwable) {
                    if (preparedStatement != null) {
                        try {
                            preparedStatement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                preparedStatement.close();
            }
            return bl;
        }
    }

    public boolean updateUser(User user) throws SQLException {
        String string = "UPDATE users SET full_name = ?, email = ?, address = ?, dob = ?, gender = ?, status = ? WHERE user_id = ?";
        try (Connection connection = this.dbConnection.getConnection();){
            boolean bl;
            block12: {
                PreparedStatement preparedStatement = connection.prepareStatement(string);
                try {
                    preparedStatement.setString(1, user.getFullName());
                    preparedStatement.setString(2, user.getEmail());
                    preparedStatement.setString(3, user.getAddress());
                    preparedStatement.setDate(4, user.getBirthDate() != null ? Date.valueOf(user.getBirthDate()) : null);
                    preparedStatement.setString(5, user.getGender());
                    preparedStatement.setString(6, user.getStatus());
                    preparedStatement.setInt(7, user.getId());
                    boolean bl2 = bl = preparedStatement.executeUpdate() > 0;
                    if (preparedStatement == null) break block12;
                }
                catch (Throwable throwable) {
                    if (preparedStatement != null) {
                        try {
                            preparedStatement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                preparedStatement.close();
            }
            return bl;
        }
    }

    public boolean deleteUser(int n) throws SQLException {
        String string = "DELETE FROM users WHERE user_id = ?";
        try (Connection connection = this.dbConnection.getConnection();){
            boolean bl;
            block12: {
                PreparedStatement preparedStatement = connection.prepareStatement(string);
                try {
                    preparedStatement.setInt(1, n);
                    boolean bl2 = bl = preparedStatement.executeUpdate() > 0;
                    if (preparedStatement == null) break block12;
                }
                catch (Throwable throwable) {
                    if (preparedStatement != null) {
                        try {
                            preparedStatement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                preparedStatement.close();
            }
            return bl;
        }
    }

    public boolean updateUserStatus(int n, String string) throws SQLException {
        String string2 = "UPDATE users SET status = ? WHERE user_id = ?";
        try (Connection connection = this.dbConnection.getConnection();){
            boolean bl;
            block12: {
                PreparedStatement preparedStatement = connection.prepareStatement(string2);
                try {
                    preparedStatement.setString(1, string);
                    preparedStatement.setInt(2, n);
                    boolean bl2 = bl = preparedStatement.executeUpdate() > 0;
                    if (preparedStatement == null) break block12;
                }
                catch (Throwable throwable) {
                    if (preparedStatement != null) {
                        try {
                            preparedStatement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                preparedStatement.close();
            }
            return bl;
        }
    }

    public boolean updatePassword(int n, String string) throws SQLException {
        String string2 = "UPDATE users SET password = ? WHERE user_id = ?";
        try (Connection connection = this.dbConnection.getConnection();){
            boolean bl;
            block12: {
                PreparedStatement preparedStatement = connection.prepareStatement(string2);
                try {
                    preparedStatement.setString(1, this.hashPassword(string));
                    preparedStatement.setInt(2, n);
                    boolean bl2 = bl = preparedStatement.executeUpdate() > 0;
                    if (preparedStatement == null) break block12;
                }
                catch (Throwable throwable) {
                    if (preparedStatement != null) {
                        try {
                            preparedStatement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                preparedStatement.close();
            }
            return bl;
        }
    }

    private String hashPassword(String string) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
            byte[] byArray = messageDigest.digest(string.getBytes());
            StringBuilder stringBuilder = new StringBuilder();
            for (byte by : byArray) {
                stringBuilder.append(String.format("%02x", by));
            }
            return stringBuilder.toString();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            System.err.println("L\u1ed7i hash password: " + noSuchAlgorithmException.getMessage());
            return string;
        }
    }

    public int getTotalUsers() throws SQLException {
        String string = "SELECT COUNT(*) FROM users";
        try (Connection connection = this.dbConnection.getConnection();
             Statement statement = connection.createStatement();
             ResultSet resultSet = statement.executeQuery(string);){
            if (resultSet.next()) {
                int n = resultSet.getInt(1);
                return n;
            }
        }
        return 0;
    }

    public int countUsersByStatus(String string) throws SQLException {
        String string2 = "SELECT COUNT(*) FROM users WHERE status = ?";
        try (Connection connection = this.dbConnection.getConnection();
             PreparedStatement preparedStatement = connection.prepareStatement(string2);){
            preparedStatement.setString(1, string);
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                if (resultSet.next()) {
                    int n = resultSet.getInt(1);
                    return n;
                }
            }
        }
        return 0;
    }

    public boolean usernameExists(String string) throws SQLException {
        if (string == null || string.trim().isEmpty()) {
            return false;
        }
        String string2 = "SELECT COUNT(*) FROM users WHERE username = ?";
        try (Connection connection = this.dbConnection.getConnection();
             PreparedStatement preparedStatement = connection.prepareStatement(string2);){
            preparedStatement.setString(1, string.trim());
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                if (resultSet.next()) {
                    boolean bl = resultSet.getInt(1) > 0;
                    return bl;
                }
            }
        }
        return false;
    }

    public boolean emailExists(String string) throws SQLException {
        if (string == null || string.trim().isEmpty()) {
            return false;
        }
        String string2 = "SELECT COUNT(*) FROM users WHERE email = ?";
        try (Connection connection = this.dbConnection.getConnection();
             PreparedStatement preparedStatement = connection.prepareStatement(string2);){
            preparedStatement.setString(1, string.trim());
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                if (resultSet.next()) {
                    boolean bl = resultSet.getInt(1) > 0;
                    return bl;
                }
            }
        }
        return false;
    }

    public boolean emailExists(String string, int n) throws SQLException {
        if (string == null || string.trim().isEmpty()) {
            return false;
        }
        String string2 = "SELECT COUNT(*) FROM users WHERE email = ? AND user_id != ?";
        try (Connection connection = this.dbConnection.getConnection();
             PreparedStatement preparedStatement = connection.prepareStatement(string2);){
            preparedStatement.setString(1, string.trim());
            preparedStatement.setInt(2, n);
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                if (resultSet.next()) {
                    boolean bl = resultSet.getInt(1) > 0;
                    return bl;
                }
            }
        }
        return false;
    }

    private User extractUserFromResultSet(ResultSet resultSet) throws SQLException {
        Timestamp timestamp;
        User user = new User();
        user.setId(resultSet.getInt("user_id"));
        user.setUsername(resultSet.getString("username"));
        user.setPassword(resultSet.getString("password"));
        user.setFullName(resultSet.getString("full_name"));
        user.setEmail(resultSet.getString("email"));
        user.setAddress(resultSet.getString("address"));
        Date date = resultSet.getDate("dob");
        if (date != null) {
            user.setBirthDate(date.toLocalDate());
        }
        user.setGender(resultSet.getString("gender"));
        user.setStatus(resultSet.getString("status"));
        Timestamp timestamp2 = resultSet.getTimestamp("created_at");
        if (timestamp2 != null) {
            user.setCreatedAt(timestamp2.toLocalDateTime());
        }
        if ((timestamp = resultSet.getTimestamp("last_login")) != null) {
            user.setUpdatedAt(timestamp.toLocalDateTime());
        }
        return user;
    }

    public static enum SearchType {
        ALL,
        USERNAME,
        FULL_NAME,
        EMAIL;

    }
}

