/*
 * Decompiled with CFR 0.152.
 */
package user.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.SwingWorker;
import javax.swing.border.EmptyBorder;
import user.gui.UIHelper;
import user.gui.ZaloMainFrame;
import user.service.GroupService;
import user.service.UserService;

public class CreateGroupWithUserDialog
extends JDialog {
    private static final Color PRIMARY_COLOR = new Color(0, 132, 255);
    private static final Color BG_COLOR = new Color(245, 247, 250);
    private ZaloMainFrame mainFrame;
    private GroupService groupService;
    private UserService userService;
    private String preSelectedUsername;
    private String preSelectedFullName;
    private JTextField groupNameField;
    private JTextArea descriptionArea;
    private JList<CheckableItem> membersList;
    private DefaultListModel<CheckableItem> membersListModel;

    public CreateGroupWithUserDialog(ZaloMainFrame zaloMainFrame, String string, String string2) {
        super(zaloMainFrame, "T\u1ea1o nh\u00f3m chat m\u1edbi", true);
        this.mainFrame = zaloMainFrame;
        this.preSelectedUsername = string;
        this.preSelectedFullName = string2;
        this.groupService = new GroupService();
        this.userService = new UserService();
        this.initComponents();
        this.loadMembers();
    }

    private void initComponents() {
        this.setSize(500, 600);
        this.setLocationRelativeTo(this.mainFrame);
        this.setResizable(false);
        this.getContentPane().setBackground(BG_COLOR);
        this.setLayout(new BorderLayout(0, 15));
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBackground(Color.WHITE);
        jPanel.setBorder(new EmptyBorder(20, 20, 20, 20));
        JLabel jLabel = new JLabel("T\u1ea1o nh\u00f3m chat v\u1edbi " + (this.preSelectedFullName != null ? this.preSelectedFullName : this.preSelectedUsername));
        jLabel.setFont(new Font(UIHelper.getDefaultFontName(), 1, 18));
        jLabel.setForeground(PRIMARY_COLOR);
        JLabel jLabel2 = new JLabel("Th\u00eam th\u00e0nh vi\u00ean kh\u00e1c n\u1ebfu mu\u1ed1n");
        jLabel2.setFont(new Font(UIHelper.getDefaultFontName(), 0, 13));
        jLabel2.setForeground(new Color(120, 120, 120));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        jPanel2.setBackground(Color.WHITE);
        jPanel2.add(jLabel);
        jPanel2.add(Box.createVerticalStrut(5));
        jPanel2.add(jLabel2);
        jPanel.add((Component)jPanel2, "Center");
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 1));
        jPanel3.setBackground(BG_COLOR);
        jPanel3.setBorder(new EmptyBorder(0, 20, 20, 20));
        this.groupNameField = new JTextField();
        JPanel jPanel4 = this.createInputPanel("T\u00ean nh\u00f3m:", this.groupNameField);
        this.groupNameField.setFont(new Font(UIHelper.getDefaultFontName(), 0, 14));
        jPanel3.add(jPanel4);
        jPanel3.add(Box.createVerticalStrut(15));
        JPanel jPanel5 = new JPanel(new BorderLayout(0, 5));
        jPanel5.setBackground(BG_COLOR);
        jPanel5.setAlignmentX(0.0f);
        JLabel jLabel3 = new JLabel("M\u00f4 t\u1ea3 (t\u00f9y ch\u1ecdn):");
        jLabel3.setFont(new Font(UIHelper.getDefaultFontName(), 1, 13));
        this.descriptionArea = new JTextArea(3, 20);
        this.descriptionArea.setFont(new Font(UIHelper.getDefaultFontName(), 0, 14));
        this.descriptionArea.setLineWrap(true);
        this.descriptionArea.setWrapStyleWord(true);
        JScrollPane jScrollPane = new JScrollPane(this.descriptionArea);
        jScrollPane.setBorder(BorderFactory.createLineBorder(new Color(220, 220, 220)));
        jPanel5.add((Component)jLabel3, "North");
        jPanel5.add((Component)jScrollPane, "Center");
        jPanel3.add(jPanel5);
        jPanel3.add(Box.createVerticalStrut(15));
        JPanel jPanel6 = new JPanel(new FlowLayout(0));
        jPanel6.setBackground(new Color(230, 245, 255));
        jPanel6.setBorder(new EmptyBorder(10, 10, 10, 10));
        JLabel jLabel4 = new JLabel("\u2713 \u0110\u00e3 ch\u1ecdn: " + (this.preSelectedFullName != null ? this.preSelectedFullName : this.preSelectedUsername) + " (@" + this.preSelectedUsername + ")");
        jLabel4.setFont(new Font(UIHelper.getDefaultFontName(), 1, 13));
        jLabel4.setForeground(PRIMARY_COLOR);
        jPanel6.add(jLabel4);
        jPanel6.setAlignmentX(0.0f);
        jPanel6.setMaximumSize(new Dimension(Integer.MAX_VALUE, 50));
        jPanel3.add(jPanel6);
        jPanel3.add(Box.createVerticalStrut(15));
        JPanel jPanel7 = new JPanel(new BorderLayout(0, 5));
        jPanel7.setBackground(BG_COLOR);
        jPanel7.setAlignmentX(0.0f);
        JLabel jLabel5 = new JLabel("Th\u00eam th\u00e0nh vi\u00ean kh\u00e1c (t\u00f9y ch\u1ecdn):");
        jLabel5.setFont(new Font(UIHelper.getDefaultFontName(), 1, 13));
        this.membersListModel = new DefaultListModel();
        this.membersList = new JList<CheckableItem>(this.membersListModel);
        this.membersList.setCellRenderer(new CheckableListCellRenderer());
        this.membersList.setSelectionMode(0);
        this.membersList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                int n = CreateGroupWithUserDialog.this.membersList.locationToIndex(mouseEvent.getPoint());
                if (n >= 0) {
                    CheckableItem checkableItem;
                    checkableItem.setSelected(!(checkableItem = CreateGroupWithUserDialog.this.membersListModel.get(n)).isSelected());
                    CreateGroupWithUserDialog.this.membersList.repaint();
                }
            }
        });
        JScrollPane jScrollPane2 = new JScrollPane(this.membersList);
        jScrollPane2.setPreferredSize(new Dimension(400, 150));
        jScrollPane2.setBorder(BorderFactory.createLineBorder(new Color(220, 220, 220)));
        jPanel7.add((Component)jLabel5, "North");
        jPanel7.add((Component)jScrollPane2, "Center");
        jPanel3.add(jPanel7);
        JPanel jPanel8 = new JPanel(new FlowLayout(2, 10, 0));
        jPanel8.setBackground(BG_COLOR);
        jPanel8.setBorder(new EmptyBorder(15, 0, 0, 0));
        JButton jButton = new JButton("H\u1ee7y");
        jButton.setFont(new Font(UIHelper.getDefaultFontName(), 0, 14));
        jButton.setPreferredSize(new Dimension(100, 38));
        jButton.addActionListener(actionEvent -> this.dispose());
        JButton jButton2 = new JButton("T\u1ea1o nh\u00f3m");
        jButton2.setFont(new Font(UIHelper.getDefaultFontName(), 1, 14));
        jButton2.setForeground(Color.WHITE);
        jButton2.setBackground(PRIMARY_COLOR);
        jButton2.setBorderPainted(false);
        jButton2.setPreferredSize(new Dimension(120, 38));
        jButton2.addActionListener(actionEvent -> this.handleCreateGroup());
        jPanel8.add(jButton);
        jPanel8.add(jButton2);
        jPanel3.add(jPanel8);
        this.add((Component)jPanel, "North");
        this.add((Component)jPanel3, "Center");
    }

    private JPanel createInputPanel(String string, JTextField jTextField) {
        JPanel jPanel = new JPanel(new BorderLayout(0, 5));
        jPanel.setBackground(BG_COLOR);
        jPanel.setAlignmentX(0.0f);
        JLabel jLabel = new JLabel(string);
        jLabel.setFont(new Font(UIHelper.getDefaultFontName(), 1, 13));
        jTextField.setPreferredSize(new Dimension(400, 35));
        jTextField.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(new Color(220, 220, 220)), new EmptyBorder(5, 10, 5, 10)));
        jPanel.add((Component)jLabel, "North");
        jPanel.add((Component)jTextField, "Center");
        return jPanel;
    }

    private void loadMembers() {
        SwingWorker<List<Map<String, Object>>, Void> swingWorker = new SwingWorker<List<Map<String, Object>>, Void>(){

            @Override
            protected List<Map<String, Object>> doInBackground() throws Exception {
                return CreateGroupWithUserDialog.this.userService.getFriendsList(CreateGroupWithUserDialog.this.mainFrame.getUsername());
            }

            @Override
            protected void done() {
                try {
                    List list = (List)this.get();
                    CreateGroupWithUserDialog.this.membersListModel.clear();
                    for (Map map : list) {
                        String string = (String)map.get("username");
                        String string2 = (String)map.get("full_name");
                        if (string.equals(CreateGroupWithUserDialog.this.preSelectedUsername)) continue;
                        String string3 = string2 != null ? string2 + " (@" + string + ")" : "@" + string;
                        CreateGroupWithUserDialog.this.membersListModel.addElement(new CheckableItem(string, string3, false));
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        };
        swingWorker.execute();
    }

    private void handleCreateGroup() {
        Object object;
        final String string = this.groupNameField.getText().trim();
        if (string.isEmpty()) {
            JOptionPane.showMessageDialog(this, "Vui l\u00f2ng nh\u1eadp t\u00ean nh\u00f3m!", "L\u1ed7i", 2);
            return;
        }
        final ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(this.preSelectedUsername);
        for (int i = 0; i < this.membersListModel.size(); ++i) {
            object = this.membersListModel.get(i);
            if (!((CheckableItem)object).isSelected()) continue;
            arrayList.add(((CheckableItem)object).getUsername());
        }
        final String string2 = this.descriptionArea.getText().trim();
        object = new SwingWorker<Integer, Void>(){

            @Override
            protected Integer doInBackground() throws Exception {
                return CreateGroupWithUserDialog.this.groupService.createGroup(string, string2, CreateGroupWithUserDialog.this.mainFrame.getUsername(), arrayList, false);
            }

            @Override
            protected void done() {
                try {
                    int n = (Integer)this.get();
                    if (n > 0) {
                        JOptionPane.showMessageDialog(CreateGroupWithUserDialog.this, "\u2705 \u0110\u00e3 t\u1ea1o nh\u00f3m \"" + string + "\" th\u00e0nh c\u00f4ng!", "Th\u00e0nh c\u00f4ng", 1);
                        CreateGroupWithUserDialog.this.mainFrame.refreshGroupList();
                        CreateGroupWithUserDialog.this.dispose();
                    } else {
                        JOptionPane.showMessageDialog(CreateGroupWithUserDialog.this, "\u274c Kh\u00f4ng th\u1ec3 t\u1ea1o nh\u00f3m. Vui l\u00f2ng th\u1eed l\u1ea1i!", "L\u1ed7i", 0);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    JOptionPane.showMessageDialog(CreateGroupWithUserDialog.this, "\u274c L\u1ed7i: " + exception.getMessage(), "L\u1ed7i", 0);
                }
            }
        };
        ((SwingWorker)object).execute();
    }

    class CheckableListCellRenderer
    extends JPanel
    implements ListCellRenderer<CheckableItem> {
        private JCheckBox checkBox;
        private JLabel label;

        public CheckableListCellRenderer() {
            this.setLayout(new BorderLayout(10, 0));
            this.setBackground(Color.WHITE);
            this.setBorder(new EmptyBorder(8, 10, 8, 10));
            this.checkBox = new JCheckBox();
            this.checkBox.setOpaque(false);
            this.label = new JLabel();
            this.label.setFont(new Font(UIHelper.getDefaultFontName(), 0, 14));
            this.add((Component)this.checkBox, "West");
            this.add((Component)this.label, "Center");
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends CheckableItem> jList, CheckableItem checkableItem, int n, boolean bl, boolean bl2) {
            this.checkBox.setSelected(checkableItem.isSelected());
            this.label.setText(checkableItem.getDisplayName());
            if (bl) {
                this.setBackground(new Color(240, 245, 255));
            } else {
                this.setBackground(Color.WHITE);
            }
            return this;
        }
    }

    class CheckableItem {
        private String username;
        private String displayName;
        private boolean selected;

        public CheckableItem(String string, String string2, boolean bl) {
            this.username = string;
            this.displayName = string2;
            this.selected = bl;
        }

        public String getUsername() {
            return this.username;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public boolean isSelected() {
            return this.selected;
        }

        public void setSelected(boolean bl) {
            this.selected = bl;
        }

        public String toString() {
            return this.displayName;
        }
    }
}

