/*
 * Decompiled with CFR 0.152.
 */
package user.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Image;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.accessibility.Accessible;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.border.EmptyBorder;
import user.gui.UIHelper;
import user.gui.ZaloMainFrame;
import user.service.UserService;

public class FriendRequestPanel
extends JPanel {
    private static final Color BG_COLOR = new Color(250, 250, 250);
    private static final Color PRIMARY_COLOR = new Color(0, 132, 255);
    private ZaloMainFrame mainFrame;
    private UserService userService;
    private JPanel receivedPanel;
    private JPanel sentPanel;
    private JTabbedPane tabbedPane;
    private JTextField receivedSearchField;
    private JTextField sentSearchField;
    private List<Map<String, Object>> allReceivedRequests;
    private List<Map<String, Object>> allSentRequests;

    public FriendRequestPanel(ZaloMainFrame zaloMainFrame) {
        this.mainFrame = zaloMainFrame;
        this.userService = new UserService();
        this.initializeUI();
        this.loadFriendRequests();
    }

    private void initializeUI() {
        this.setLayout(new BorderLayout());
        this.setBackground(BG_COLOR);
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.setFont(new Font(UIHelper.getDefaultFontName(), 0, 13));
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBackground(BG_COLOR);
        this.receivedSearchField = this.createSearchField("T\u00ecm ki\u1ebfm theo t\u00ean...");
        this.receivedSearchField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                FriendRequestPanel.this.filterReceivedRequests(FriendRequestPanel.this.receivedSearchField.getText());
            }
        });
        JPanel jPanel2 = new JPanel(new BorderLayout(10, 10));
        jPanel2.setBackground(Color.WHITE);
        jPanel2.setBorder(new EmptyBorder(10, 15, 10, 15));
        jPanel2.add((Component)this.receivedSearchField, "Center");
        this.receivedPanel = new JPanel();
        this.receivedPanel.setLayout(new BoxLayout(this.receivedPanel, 1));
        this.receivedPanel.setBackground(BG_COLOR);
        JScrollPane jScrollPane = new JScrollPane(this.receivedPanel);
        jScrollPane.setBorder(null);
        jScrollPane.getVerticalScrollBar().setUnitIncrement(16);
        jPanel.add((Component)jPanel2, "North");
        jPanel.add((Component)jScrollPane, "Center");
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.setBackground(BG_COLOR);
        this.sentSearchField = this.createSearchField("T\u00ecm ki\u1ebfm theo t\u00ean...");
        this.sentSearchField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                FriendRequestPanel.this.filterSentRequests(FriendRequestPanel.this.sentSearchField.getText());
            }
        });
        JPanel jPanel4 = new JPanel(new BorderLayout(10, 10));
        jPanel4.setBackground(Color.WHITE);
        jPanel4.setBorder(new EmptyBorder(10, 15, 10, 15));
        jPanel4.add((Component)this.sentSearchField, "Center");
        this.sentPanel = new JPanel();
        this.sentPanel.setLayout(new BoxLayout(this.sentPanel, 1));
        this.sentPanel.setBackground(BG_COLOR);
        JScrollPane jScrollPane2 = new JScrollPane(this.sentPanel);
        jScrollPane2.setBorder(null);
        jScrollPane2.getVerticalScrollBar().setUnitIncrement(16);
        jPanel3.add((Component)jPanel4, "North");
        jPanel3.add((Component)jScrollPane2, "Center");
        this.tabbedPane.addTab("L\u1eddi m\u1eddi \u0111\u00e3 nh\u1eadn (0)", jPanel);
        this.tabbedPane.addTab("L\u1eddi m\u1eddi \u0111\u00e3 g\u1eedi (0)", jPanel3);
        this.add((Component)this.tabbedPane, "Center");
    }

    private JTextField createSearchField(final String string) {
        final JTextField jTextField = new JTextField();
        jTextField.setFont(new Font(UIHelper.getDefaultFontName(), 0, 14));
        jTextField.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(new Color(220, 220, 220), 1), new EmptyBorder(8, 12, 8, 12)));
        jTextField.setForeground(new Color(150, 150, 150));
        jTextField.setText(string);
        jTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                if (jTextField.getText().equals(string)) {
                    jTextField.setText("");
                    jTextField.setForeground(Color.BLACK);
                }
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                if (jTextField.getText().isEmpty()) {
                    jTextField.setForeground(new Color(150, 150, 150));
                    jTextField.setText(string);
                }
            }
        });
        return jTextField;
    }

    private void loadFriendRequests() {
        this.loadReceivedRequests();
        this.loadSentRequests();
    }

    private void loadReceivedRequests() {
        this.receivedPanel.removeAll();
        SwingWorker<List<Map<String, Object>>, Void> swingWorker = new SwingWorker<List<Map<String, Object>>, Void>(){

            @Override
            protected List<Map<String, Object>> doInBackground() throws Exception {
                return FriendRequestPanel.this.userService.getReceivedFriendRequests(FriendRequestPanel.this.mainFrame.getUsername());
            }

            @Override
            protected void done() {
                try {
                    List list;
                    FriendRequestPanel.this.allReceivedRequests = list = (List)this.get();
                    if (list == null || list.isEmpty()) {
                        FriendRequestPanel.this.showEmptyMessage(FriendRequestPanel.this.receivedPanel, "Kh\u00f4ng c\u00f3 l\u1eddi m\u1eddi k\u1ebft b\u1ea1n");
                        FriendRequestPanel.this.tabbedPane.setTitleAt(0, "L\u1eddi m\u1eddi \u0111\u00e3 nh\u1eadn (0)");
                    } else {
                        FriendRequestPanel.this.displayReceivedRequests(list);
                    }
                    FriendRequestPanel.this.receivedPanel.revalidate();
                    FriendRequestPanel.this.receivedPanel.repaint();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    FriendRequestPanel.this.showEmptyMessage(FriendRequestPanel.this.receivedPanel, "L\u1ed7i: " + exception.getMessage());
                }
            }
        };
        swingWorker.execute();
    }

    private void displayReceivedRequests(List<Map<String, Object>> list) {
        this.receivedPanel.removeAll();
        if (list == null || list.isEmpty()) {
            this.showEmptyMessage(this.receivedPanel, "Kh\u00f4ng t\u00ecm th\u1ea5y k\u1ebft qu\u1ea3");
            this.tabbedPane.setTitleAt(0, "L\u1eddi m\u1eddi \u0111\u00e3 nh\u1eadn (0)");
        } else {
            for (Map<String, Object> map : list) {
                ReceivedRequestPanel receivedRequestPanel = new ReceivedRequestPanel(map);
                this.receivedPanel.add(receivedRequestPanel);
            }
            this.tabbedPane.setTitleAt(0, "L\u1eddi m\u1eddi \u0111\u00e3 nh\u1eadn (" + list.size() + ")");
        }
        this.receivedPanel.revalidate();
        this.receivedPanel.repaint();
    }

    private void filterReceivedRequests(String string) {
        if (this.allReceivedRequests == null) {
            return;
        }
        if (string.isEmpty() || string.equals("T\u00ecm ki\u1ebfm theo t\u00ean...")) {
            this.displayReceivedRequests(this.allReceivedRequests);
            return;
        }
        ArrayList<Map<String, Object>> arrayList = new ArrayList<Map<String, Object>>();
        String string2 = string.toLowerCase();
        for (Map<String, Object> map : this.allReceivedRequests) {
            String string3 = (String)map.get("sender_name");
            String string4 = (String)map.get("sender_username");
            if ((string3 == null || !string3.toLowerCase().contains(string2)) && (string4 == null || !string4.toLowerCase().contains(string2))) continue;
            arrayList.add(map);
        }
        this.displayReceivedRequests(arrayList);
    }

    private void loadSentRequests() {
        this.sentPanel.removeAll();
        SwingWorker<List<Map<String, Object>>, Void> swingWorker = new SwingWorker<List<Map<String, Object>>, Void>(){

            @Override
            protected List<Map<String, Object>> doInBackground() throws Exception {
                return FriendRequestPanel.this.userService.getSentFriendRequests(FriendRequestPanel.this.mainFrame.getUsername());
            }

            @Override
            protected void done() {
                try {
                    List list;
                    FriendRequestPanel.this.allSentRequests = list = (List)this.get();
                    if (list == null || list.isEmpty()) {
                        FriendRequestPanel.this.showEmptyMessage(FriendRequestPanel.this.sentPanel, "B\u1ea1n ch\u01b0a g\u1eedi l\u1eddi m\u1eddi n\u00e0o");
                        FriendRequestPanel.this.tabbedPane.setTitleAt(1, "L\u1eddi m\u1eddi \u0111\u00e1 g\u1eedi (0)");
                    } else {
                        FriendRequestPanel.this.displaySentRequests(list);
                    }
                    FriendRequestPanel.this.sentPanel.revalidate();
                    FriendRequestPanel.this.sentPanel.repaint();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    FriendRequestPanel.this.showEmptyMessage(FriendRequestPanel.this.sentPanel, "L\u1ed7i: " + exception.getMessage());
                }
            }
        };
        swingWorker.execute();
    }

    private void displaySentRequests(List<Map<String, Object>> list) {
        this.sentPanel.removeAll();
        if (list == null || list.isEmpty()) {
            this.showEmptyMessage(this.sentPanel, "Kh\u00f4ng t\u00ecm th\u1ea5y k\u1ebft qu\u1ea3");
            this.tabbedPane.setTitleAt(1, "L\u1eddi m\u1eddi \u0111\u00e3 g\u1eedi (0)");
        } else {
            for (Map<String, Object> map : list) {
                SentRequestPanel sentRequestPanel = new SentRequestPanel(map);
                this.sentPanel.add(sentRequestPanel);
            }
            this.tabbedPane.setTitleAt(1, "L\u1eddi m\u1eddi \u0111\u00e3 g\u1eedi (" + list.size() + ")");
        }
        this.sentPanel.revalidate();
        this.sentPanel.repaint();
    }

    private void filterSentRequests(String string) {
        if (this.allSentRequests == null) {
            return;
        }
        if (string.isEmpty() || string.equals("T\u00ecm ki\u1ebfm theo t\u00ean...")) {
            this.displaySentRequests(this.allSentRequests);
            return;
        }
        ArrayList<Map<String, Object>> arrayList = new ArrayList<Map<String, Object>>();
        String string2 = string.toLowerCase();
        for (Map<String, Object> map : this.allSentRequests) {
            String string3 = (String)map.get("receiver_name");
            String string4 = (String)map.get("receiver_username");
            if ((string3 == null || !string3.toLowerCase().contains(string2)) && (string4 == null || !string4.toLowerCase().contains(string2))) continue;
            arrayList.add(map);
        }
        this.displaySentRequests(arrayList);
    }

    private void showEmptyMessage(JPanel jPanel, String string) {
        jPanel.removeAll();
        JLabel jLabel = new JLabel("<html><center>\ud83d\ude14<br><br>" + string + "</center></html>");
        jLabel.setFont(new Font(UIHelper.getDefaultFontName(), 0, 14));
        jLabel.setForeground(new Color(150, 150, 150));
        jLabel.setAlignmentX(0.5f);
        jLabel.setBorder(new EmptyBorder(80, 20, 80, 20));
        jPanel.add(jLabel);
        jPanel.revalidate();
        jPanel.repaint();
    }

    private JButton createActionButton(String string, Color color, Color color2) {
        JButton jButton = new JButton(string);
        jButton.setFont(new Font(UIHelper.getDefaultFontName(), 1, 13));
        jButton.setForeground(color2);
        jButton.setBackground(color);
        jButton.setPreferredSize(new Dimension(100, 36));
        jButton.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(color.equals(Color.WHITE) ? new Color(200, 200, 200) : color, 1, true), new EmptyBorder(6, 12, 6, 12)));
        jButton.setFocusPainted(false);
        jButton.setOpaque(true);
        jButton.setContentAreaFilled(true);
        jButton.setCursor(new Cursor(12));
        return jButton;
    }

    private void acceptFriendRequest(final String string, Map<String, Object> map) {
        final int n = (Integer)map.get("friendship_id");
        new SwingWorker<Boolean, Void>(){

            @Override
            protected Boolean doInBackground() {
                return FriendRequestPanel.this.userService.acceptFriendRequest(n);
            }

            @Override
            protected void done() {
                try {
                    if (((Boolean)this.get()).booleanValue()) {
                        System.out.println("\u2705 \u0110\u00e3 ch\u1ea5p nh\u1eadn l\u1eddi m\u1eddi t\u1eeb: " + string);
                        FriendRequestPanel.this.mainFrame.sendFriendRequestAcceptedNotification(string);
                        JOptionPane.showMessageDialog(FriendRequestPanel.this, "\u2705 \u0110\u00e3 ch\u1ea5p nh\u1eadn l\u1eddi m\u1eddi k\u1ebft b\u1ea1n!", "Th\u00e0nh c\u00f4ng", 1);
                        FriendRequestPanel.this.loadReceivedRequests();
                        FriendRequestPanel.this.mainFrame.refreshChatAndFriendList();
                    } else {
                        JOptionPane.showMessageDialog(FriendRequestPanel.this, "\u274c Kh\u00f4ng th\u1ec3 ch\u1ea5p nh\u1eadn l\u1eddi m\u1eddi!", "L\u1ed7i", 0);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }.execute();
    }

    private void rejectFriendRequest(final String string, Map<String, Object> map) {
        final int n = (Integer)map.get("friendship_id");
        int n2 = JOptionPane.showConfirmDialog(this, "B\u1ea1n c\u00f3 ch\u1eafc mu\u1ed1n t\u1eeb ch\u1ed1i l\u1eddi m\u1eddi t\u1eeb " + string + "?", "X\u00e1c nh\u1eadn", 0);
        if (n2 != 0) {
            return;
        }
        new SwingWorker<Boolean, Void>(){

            @Override
            protected Boolean doInBackground() {
                return FriendRequestPanel.this.userService.rejectFriendRequest(n);
            }

            @Override
            protected void done() {
                try {
                    if (((Boolean)this.get()).booleanValue()) {
                        System.out.println("\u274c \u0110\u00e3 t\u1eeb ch\u1ed1i l\u1eddi m\u1eddi t\u1eeb: " + string);
                        FriendRequestPanel.this.mainFrame.sendFriendRequestRejectedNotification(string);
                        JOptionPane.showMessageDialog(FriendRequestPanel.this, "\u2705 \u0110\u00e3 t\u1eeb ch\u1ed1i l\u1eddi m\u1eddi!", "Th\u00e0nh c\u00f4ng", 1);
                        FriendRequestPanel.this.loadReceivedRequests();
                    } else {
                        JOptionPane.showMessageDialog(FriendRequestPanel.this, "\u274c Kh\u00f4ng th\u1ec3 t\u1eeb ch\u1ed1i l\u1eddi m\u1eddi!", "L\u1ed7i", 0);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }.execute();
    }

    private void recallFriendRequest(final String string, Map<String, Object> map) {
        final int n = (Integer)map.get("friendship_id");
        int n2 = JOptionPane.showConfirmDialog(this, "B\u1ea1n c\u00f3 ch\u1eafc mu\u1ed1n thu h\u1ed3i l\u1eddi m\u1eddi g\u1eedi cho " + string + "?", "X\u00e1c nh\u1eadn", 0);
        if (n2 != 0) {
            return;
        }
        new SwingWorker<Boolean, Void>(){

            @Override
            protected Boolean doInBackground() {
                return FriendRequestPanel.this.userService.recallFriendRequest(n);
            }

            @Override
            protected void done() {
                try {
                    if (((Boolean)this.get()).booleanValue()) {
                        System.out.println("\ud83d\udd19 \u0110\u00e3 thu h\u1ed3i l\u1eddi m\u1eddi g\u1eedi cho: " + string);
                        FriendRequestPanel.this.mainFrame.sendFriendRequestRecalledNotification(string);
                        JOptionPane.showMessageDialog(FriendRequestPanel.this, "\u2705 \u0110\u00e3 thu h\u1ed3i l\u1eddi m\u1eddi!", "Th\u00e0nh c\u00f4ng", 1);
                        FriendRequestPanel.this.loadSentRequests();
                    } else {
                        JOptionPane.showMessageDialog(FriendRequestPanel.this, "\u274c Kh\u00f4ng th\u1ec3 thu h\u1ed3i l\u1eddi m\u1eddi!", "L\u1ed7i", 0);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }.execute();
    }

    public void refreshFriendRequests() {
        System.out.println("\ud83d\udd04 Refreshing friend requests...");
        SwingUtilities.invokeLater(() -> {
            this.loadReceivedRequests();
            this.loadSentRequests();
        });
    }

    private class ReceivedRequestPanel
    extends JPanel {
        public ReceivedRequestPanel(Map<String, Object> map) {
            Object object;
            Accessible accessible;
            this.setLayout(new BorderLayout(12, 0));
            this.setBackground(Color.WHITE);
            this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, new Color(230, 230, 230)), new EmptyBorder(12, 15, 12, 15)));
            this.setMaximumSize(new Dimension(Integer.MAX_VALUE, 120));
            String string = (String)map.get("sender_username");
            String string2 = (String)map.get("sender_name");
            String string3 = map.get("created_at") != null ? map.get("created_at").toString() : "18/10";
            JPanel jPanel = new JPanel(new BorderLayout(10, 0));
            jPanel.setOpaque(false);
            JLabel jLabel = new JLabel();
            jLabel.setPreferredSize(new Dimension(50, 50));
            jLabel.setHorizontalAlignment(0);
            try {
                accessible = new ImageIcon("icons/user.png");
                object = ((ImageIcon)accessible).getImage().getScaledInstance(40, 40, 4);
                jLabel.setIcon(new ImageIcon((Image)object));
            }
            catch (Exception exception) {
                jLabel.setText("[A]");
                jLabel.setFont(new Font(UIHelper.getDefaultFontName(), 1, 16));
            }
            accessible = new JPanel();
            ((Container)((Object)accessible)).setLayout(new BoxLayout((Container)((Object)accessible), 1));
            ((JComponent)((Object)accessible)).setOpaque(false);
            object = new JLabel(string2 != null ? string2 : string);
            ((JComponent)object).setFont(new Font(UIHelper.getDefaultFontName(), 1, 15));
            JLabel jLabel2 = new JLabel(string3);
            jLabel2.setFont(new Font(UIHelper.getDefaultFontName(), 0, 12));
            jLabel2.setForeground(new Color(120, 120, 120));
            JLabel jLabel3 = new JLabel("Xin ch\u00e0o, m\u00ecnh l\u00e0 " + (string2 != null ? string2 : string) + ". K\u1ebft b\u1ea1n v\u1edbi m\u00ecnh nh\u00e9!");
            jLabel3.setFont(new Font(UIHelper.getDefaultFontName(), 0, 12));
            jLabel3.setForeground(new Color(100, 100, 100));
            ((Container)((Object)accessible)).add((Component)object);
            ((Container)((Object)accessible)).add(Box.createRigidArea(new Dimension(0, 3)));
            ((Container)((Object)accessible)).add(jLabel2);
            ((Container)((Object)accessible)).add(Box.createRigidArea(new Dimension(0, 5)));
            ((Container)((Object)accessible)).add(jLabel3);
            jPanel.add((Component)jLabel, "West");
            jPanel.add((Component)((Object)accessible), "Center");
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout(new BoxLayout(jPanel2, 1));
            jPanel2.setOpaque(false);
            JButton jButton = FriendRequestPanel.this.createActionButton("\u0110\u1ed3ng \u00fd", PRIMARY_COLOR, Color.WHITE);
            JButton jButton2 = FriendRequestPanel.this.createActionButton("T\u1eeb ch\u1ed1i", Color.WHITE, new Color(100, 100, 100));
            jButton.addActionListener(actionEvent -> FriendRequestPanel.this.acceptFriendRequest(string, map));
            jButton2.addActionListener(actionEvent -> FriendRequestPanel.this.rejectFriendRequest(string, map));
            jPanel2.add(jButton);
            jPanel2.add(Box.createRigidArea(new Dimension(0, 8)));
            jPanel2.add(jButton2);
            this.add((Component)jPanel, "Center");
            this.add((Component)jPanel2, "East");
        }
    }

    private class SentRequestPanel
    extends JPanel {
        public SentRequestPanel(Map<String, Object> map) {
            Object object;
            Accessible accessible;
            this.setLayout(new BorderLayout(12, 0));
            this.setBackground(Color.WHITE);
            this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, new Color(230, 230, 230)), new EmptyBorder(12, 15, 12, 15)));
            this.setMaximumSize(new Dimension(Integer.MAX_VALUE, 80));
            String string = (String)map.get("receiver_username");
            String string2 = (String)map.get("receiver_name");
            JPanel jPanel = new JPanel(new BorderLayout(10, 0));
            jPanel.setOpaque(false);
            JLabel jLabel = new JLabel();
            jLabel.setPreferredSize(new Dimension(50, 50));
            jLabel.setHorizontalAlignment(0);
            try {
                accessible = new ImageIcon("icons/user.png");
                object = ((ImageIcon)accessible).getImage().getScaledInstance(40, 40, 4);
                jLabel.setIcon(new ImageIcon((Image)object));
            }
            catch (Exception exception) {
                jLabel.setText("[A]");
                jLabel.setFont(new Font(UIHelper.getDefaultFontName(), 1, 16));
            }
            accessible = new JPanel();
            ((Container)((Object)accessible)).setLayout(new BoxLayout((Container)((Object)accessible), 1));
            ((JComponent)((Object)accessible)).setOpaque(false);
            object = new JLabel(string2 != null ? string2 : string);
            ((JComponent)object).setFont(new Font(UIHelper.getDefaultFontName(), 1, 15));
            JLabel jLabel2 = new JLabel("B\u1ea1n \u0111\u00e3 g\u1eedi l\u1eddi m\u1eddi");
            jLabel2.setFont(new Font(UIHelper.getDefaultFontName(), 0, 12));
            jLabel2.setForeground(new Color(120, 120, 120));
            ((Container)((Object)accessible)).add((Component)object);
            ((Container)((Object)accessible)).add(Box.createRigidArea(new Dimension(0, 5)));
            ((Container)((Object)accessible)).add(jLabel2);
            jPanel.add((Component)jLabel, "West");
            jPanel.add((Component)((Object)accessible), "Center");
            JButton jButton = FriendRequestPanel.this.createActionButton("Thu h\u1ed3i l\u1eddi m\u1eddi", Color.WHITE, new Color(100, 100, 100));
            jButton.addActionListener(actionEvent -> FriendRequestPanel.this.recallFriendRequest(string, map));
            this.add((Component)jPanel, "Center");
            this.add((Component)jButton, "East");
        }
    }
}

