/*
 * Decompiled with CFR 0.152.
 */
package user.socket;

import java.io.EOFException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.Socket;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.Consumer;
import user.socket.Message;

public class SocketClient {
    private static final String SERVER_HOST = "localhost";
    private static final int SERVER_PORT = 8888;
    private Socket socket;
    private ObjectOutputStream out;
    private ObjectInputStream in;
    private String username;
    private Consumer<Message> messageHandler;
    private List<String> onlineUsers = new ArrayList<String>();
    private volatile boolean running = false;
    private Thread listenerThread;

    public SocketClient(String string, Consumer<Message> consumer) {
        this.username = string;
        this.messageHandler = consumer;
    }

    public boolean connect() {
        try {
            this.socket = new Socket(SERVER_HOST, 8888);
            System.out.println("\u2705 Connected to server: localhost:8888");
            this.out = new ObjectOutputStream(this.socket.getOutputStream());
            this.out.flush();
            this.in = new ObjectInputStream(this.socket.getInputStream());
            Message message = new Message(Message.MessageType.LOGIN, this.username, null);
            this.sendMessage(message);
            this.running = true;
            this.listenerThread = new Thread(this::listenForMessages);
            this.listenerThread.start();
            return true;
        }
        catch (IOException iOException) {
            System.err.println("\u274c Could not connect to server: " + iOException.getMessage());
            return false;
        }
    }

    private void listenForMessages() {
        try {
            while (this.running) {
                Object object;
                Message message = (Message)this.in.readObject();
                System.out.println("\ud83d\udce8 Received from server: " + String.valueOf((Object)message.getType()));
                if (message.getType() == Message.MessageType.ONLINE_USERS && (object = message.getData()) instanceof List) {
                    this.onlineUsers = new ArrayList<String>((List)object);
                    System.out.println("\ud83d\udc65 Online users updated: " + this.onlineUsers.size());
                }
                if (this.messageHandler == null) continue;
                this.messageHandler.accept(message);
            }
        }
        catch (EOFException eOFException) {
            System.out.println("\ud83d\udce4 Server closed connection");
        }
        catch (IOException | ClassNotFoundException exception) {
            if (this.running) {
                System.err.println("\u274c Error receiving message: " + exception.getMessage());
            }
        }
        finally {
            this.disconnect();
        }
    }

    public void sendMessage(Message message) {
        try {
            if (this.out != null && this.socket != null && this.socket.isConnected()) {
                this.out.writeObject(message);
                this.out.flush();
                System.out.println("\ud83d\udce4 Sent: " + String.valueOf((Object)message.getType()));
            } else {
                System.err.println("\u274c Not connected to server!");
            }
        }
        catch (IOException iOException) {
            System.err.println("\u274c Error sending message: " + iOException.getMessage());
            this.disconnect();
        }
    }

    public void sendChatMessage(String string) {
        Message message = new Message(Message.MessageType.CHAT, this.username, string);
        this.sendMessage(message);
    }

    public void sendPrivateMessage(String string, String string2) {
        Message message = new Message(Message.MessageType.PRIVATE_MESSAGE, this.username, string, string2);
        this.sendMessage(message);
    }

    public void sendTyping(String string) {
        Message message = new Message(Message.MessageType.TYPING, this.username, null);
        message.setReceiver(string);
        this.sendMessage(message);
    }

    public void sendGroupMessage(int n, String string) {
        Message message = new Message(Message.MessageType.GROUP_MESSAGE, this.username, string);
        message.setData(n);
        this.sendMessage(message);
    }

    public void sendGroupCreatedNotification(int n, String string, List<String> list) {
        Message message = new Message(Message.MessageType.GROUP_CREATED, this.username, string);
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("groupId", n);
        hashMap.put("members", list);
        message.setData(hashMap);
        this.sendMessage(message);
    }

    public void disconnect() {
        this.running = false;
        try {
            if (this.out != null && this.socket != null && this.socket.isConnected()) {
                Message message = new Message(Message.MessageType.LOGOUT, this.username, null);
                this.out.writeObject(message);
                this.out.flush();
                System.out.println("\ud83d\udce4 Sent LOGOUT");
            }
            if (this.out != null) {
                this.out.close();
            }
            if (this.in != null) {
                this.in.close();
            }
            if (this.socket != null && !this.socket.isClosed()) {
                this.socket.close();
            }
            System.out.println("\ud83d\udc4b Disconnected from server");
        }
        catch (IOException iOException) {
            System.err.println("\u274c Error disconnecting: " + iOException.getMessage());
        }
    }

    public boolean isConnected() {
        return this.socket != null && this.socket.isConnected() && this.running;
    }

    public String getUsername() {
        return this.username;
    }

    public List<String> getOnlineUsers() {
        return new ArrayList<String>(this.onlineUsers);
    }
}

